/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.persist.compiler.codeaction.PersistCodeActionName;
import io.ballerina.stdlib.persist.compiler.utils.Utils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractAddSyntax
implements CodeAction {
    public static final String ADD_TEXT_RANGE = "add.text.range";
    public static final String ADD_TEXT = "add.text";

    public List<String> supportedDiagnosticCodes() {
        return this.getSupportedDiagnosticCodes();
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext codeActionContext) {
        Diagnostic diagnostic = codeActionContext.diagnostic();
        List properties = diagnostic.properties();
        TextRange lineAddLocation = TextRange.from((int)Utils.getNumericDiagnosticProperty(properties, 0), (int)0);
        CodeActionArgument lineAddLocationArg = CodeActionArgument.from((String)ADD_TEXT_RANGE, (Object)lineAddLocation);
        CodeActionArgument addTextArg = CodeActionArgument.from((String)ADD_TEXT, (Object)this.getAddText(diagnostic));
        return Optional.of(CodeActionInfo.from((String)this.getTitle(diagnostic), List.of(lineAddLocationArg, addTextArg)));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        TextRange startFrom = Utils.getTextRangeArgument(context, ADD_TEXT_RANGE);
        String addText = Utils.getStringArgument(context, ADD_TEXT);
        if (startFrom == null || addText == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)startFrom, (String)addText));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    public String name() {
        return PersistCodeActionName.ADD_SINGLE_TEXT.getName();
    }

    protected abstract List<String> getSupportedDiagnosticCodes();

    protected abstract String getTitle(Diagnostic var1);

    protected abstract String getAddText(Diagnostic var1);
}

