/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.persist.compiler.DiagnosticsCodes;
import io.ballerina.stdlib.persist.compiler.codeaction.PersistCodeActionName;
import io.ballerina.stdlib.persist.compiler.utils.Utils;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ChangeToClosedRecord
implements CodeAction {
    private static final String START_DELIMITER_TEXT_RANGE = "start.text.range";
    private static final String END_DELIMITER_TEXT_RANGE = "end.text.range";

    public List<String> supportedDiagnosticCodes() {
        return List.of(DiagnosticsCodes.PERSIST_201.getCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        List properties = context.diagnostic().properties();
        TextRange startDelimiterFrom = TextRange.from((int)Utils.getNumericDiagnosticProperty(properties, 0), (int)0);
        TextRange endDelimiterFrom = TextRange.from((int)Utils.getNumericDiagnosticProperty(properties, 1), (int)0);
        CodeActionArgument startLocationArg = CodeActionArgument.from((String)START_DELIMITER_TEXT_RANGE, (Object)startDelimiterFrom);
        CodeActionArgument endLocationArg = CodeActionArgument.from((String)END_DELIMITER_TEXT_RANGE, (Object)endDelimiterFrom);
        return Optional.of(CodeActionInfo.from((String)"Change to closed record", List.of(startLocationArg, endLocationArg)));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        TextRange startDelimiterFrom = Utils.getTextRangeArgument(context, START_DELIMITER_TEXT_RANGE);
        TextRange endDelimiterFrom = Utils.getTextRangeArgument(context, END_DELIMITER_TEXT_RANGE);
        if (startDelimiterFrom == null || endDelimiterFrom == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)startDelimiterFrom, (String)SyntaxKind.PIPE_TOKEN.stringValue()));
        textEdits.add(TextEdit.from((TextRange)endDelimiterFrom, (String)SyntaxKind.PIPE_TOKEN.stringValue()));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    public String name() {
        return PersistCodeActionName.CHANGE_TO_CLOSED_RECORD.getName();
    }
}

