/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.codeaction;

import io.ballerina.stdlib.persist.compiler.DiagnosticsCodes;
import io.ballerina.stdlib.persist.compiler.codeaction.AbstractRemoveUnsupportedSyntax;
import io.ballerina.stdlib.persist.compiler.codeaction.PersistCodeActionName;
import io.ballerina.stdlib.persist.compiler.utils.Utils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextRange;
import java.text.MessageFormat;
import java.util.List;

public class RemoveTextRange
extends AbstractRemoveUnsupportedSyntax {
    @Override
    protected String getName() {
        return PersistCodeActionName.REMOVE_TEXT_RANGE.getName();
    }

    @Override
    protected List<String> getSupportedDiagnosticCodes() {
        return List.of(DiagnosticsCodes.PERSIST_102.getCode(), DiagnosticsCodes.PERSIST_302.getCode(), DiagnosticsCodes.PERSIST_304.getCode(), DiagnosticsCodes.PERSIST_503.getCode(), DiagnosticsCodes.PERSIST_003.getCode(), DiagnosticsCodes.PERSIST_306.getCode(), DiagnosticsCodes.PERSIST_406.getCode(), DiagnosticsCodes.PERSIST_502.getCode());
    }

    @Override
    protected String getTitle(Diagnostic diagnostic) {
        String code = diagnostic.diagnosticInfo().code();
        if (code.equals(DiagnosticsCodes.PERSIST_102.getCode())) {
            return "Remove import prefix";
        }
        if (code.equals(DiagnosticsCodes.PERSIST_302.getCode())) {
            return "Remove default value";
        }
        if (code.equals(DiagnosticsCodes.PERSIST_304.getCode())) {
            return "Make field mandatory";
        }
        if (code.equals(DiagnosticsCodes.PERSIST_503.getCode())) {
            return "Change to non-identity field";
        }
        if (code.equals(DiagnosticsCodes.PERSIST_003.getCode())) {
            return MessageFormat.format("Change ''{0}'' to non-nillable field", Utils.getStringDiagnosticProperty(diagnostic.properties(), 2));
        }
        return MessageFormat.format("Change to ''{0}'' type", Utils.getStringDiagnosticProperty(diagnostic.properties(), 2));
    }

    @Override
    protected TextRange getNodeLocation(Diagnostic diagnostic) {
        int startOffset = Utils.getNumericDiagnosticProperty(diagnostic.properties(), 0);
        int length = Utils.getNumericDiagnosticProperty(diagnostic.properties(), 1);
        return TextRange.from((int)startOffset, (int)length);
    }
}

