/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.model;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.stdlib.persist.compiler.model.RelationType;
import java.util.Collections;
import java.util.List;

public class RelationField {
    private final String name;
    private final String type;
    private final int typeEndOffset;
    private final boolean isOptionalType;
    private final int nullableStartOffset;
    private final boolean isArrayType;
    private final int arrayStartOffset;
    private final int arrayRangeLength;
    private final String containingEntity;
    private final NodeLocation location;
    private boolean isOwnerIdentifiable = false;
    private String owner = null;
    private RelationType relationType;
    private final List<AnnotationNode> annotations;

    public RelationField(String name, String type, int typeEndOffset, boolean isOptionalType, int nullableStartOffset, boolean isArrayType, int arrayStartOffset, int arrayRangeLength, NodeLocation location, String containingEntity, List<AnnotationNode> annotations) {
        this.name = name;
        this.type = type;
        this.typeEndOffset = typeEndOffset;
        this.isOptionalType = isOptionalType;
        this.nullableStartOffset = nullableStartOffset;
        this.isArrayType = isArrayType;
        this.arrayStartOffset = arrayStartOffset;
        this.arrayRangeLength = arrayRangeLength;
        this.location = location;
        this.containingEntity = containingEntity;
        this.annotations = Collections.unmodifiableList(annotations);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getTypeEndOffset() {
        return this.typeEndOffset;
    }

    public boolean isOptionalType() {
        return this.isOptionalType;
    }

    public int getNullableStartOffset() {
        return this.nullableStartOffset;
    }

    public boolean isArrayType() {
        return this.isArrayType;
    }

    public int getArrayStartOffset() {
        return this.arrayStartOffset;
    }

    public int getArrayRangeLength() {
        return this.arrayRangeLength;
    }

    public String getContainingEntity() {
        return this.containingEntity;
    }

    public NodeLocation getLocation() {
        return this.location;
    }

    public boolean isOwnerIdentifiable() {
        return this.isOwnerIdentifiable;
    }

    public void setOwnerIdentifiable(boolean ownerIdentifiable) {
        this.isOwnerIdentifiable = ownerIdentifiable;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public void setRelationType(RelationType relationType) {
        this.relationType = relationType;
    }

    public List<AnnotationNode> getAnnotations() {
        return this.annotations;
    }
}

