/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.utils;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.stdlib.persist.compiler.DiagnosticsCodes;
import io.ballerina.stdlib.persist.compiler.model.Entity;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import java.text.MessageFormat;
import java.util.List;

public final class ValidatorsByDatastore {
    private ValidatorsByDatastore() {
    }

    public static boolean validateSimpleTypes(Entity entity, Node typeNode, String typeNamePostfix, boolean isArrayType, boolean isOptionalType, List<DiagnosticProperty<?>> properties, String type, String datastore) {
        boolean validFlag = true;
        if (isOptionalType && ("googlesheets".equals(datastore) || "redis".equals(datastore))) {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_308.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_308.getMessage(), type), DiagnosticsCodes.PERSIST_308.getSeverity(), typeNode.location(), properties);
            validFlag = false;
        }
        if (isArrayType) {
            if (!ValidatorsByDatastore.isValidArrayType(type, datastore)) {
                if (ValidatorsByDatastore.isValidSimpleType(type, datastore)) {
                    entity.reportDiagnostic(DiagnosticsCodes.PERSIST_306.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_306.getMessage(), type), DiagnosticsCodes.PERSIST_306.getSeverity(), typeNode.location(), properties);
                } else {
                    entity.reportDiagnostic(DiagnosticsCodes.PERSIST_306.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_306.getMessage(), type), DiagnosticsCodes.PERSIST_306.getSeverity(), typeNode.location());
                }
                validFlag = false;
            }
        } else if (!ValidatorsByDatastore.isValidSimpleType(type, datastore)) {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_305.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_305.getMessage(), type + typeNamePostfix), DiagnosticsCodes.PERSIST_305.getSeverity(), typeNode.location());
            validFlag = false;
        }
        return validFlag;
    }

    public static boolean validateImportedTypes(Entity entity, Node typeNode, boolean isArrayType, boolean isOptionalType, List<DiagnosticProperty<?>> properties, String modulePrefix, String identifier, String datastore) {
        boolean validFlag = true;
        if (isOptionalType && datastore.equals("redis")) {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_308.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_308.getMessage(), modulePrefix + ":" + identifier), DiagnosticsCodes.PERSIST_308.getSeverity(), typeNode.location(), properties);
            validFlag = false;
        }
        if (ValidatorsByDatastore.isValidImportedType(modulePrefix, identifier, datastore)) {
            if (isArrayType && !ValidatorsByDatastore.isValidArrayType(modulePrefix + ":" + identifier, datastore)) {
                entity.reportDiagnostic(DiagnosticsCodes.PERSIST_306.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_306.getMessage(), modulePrefix + ":" + identifier), DiagnosticsCodes.PERSIST_306.getSeverity(), typeNode.location(), properties);
            } else {
                validFlag = true;
            }
        } else if (isArrayType) {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_306.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_306.getMessage(), modulePrefix + ":" + identifier), DiagnosticsCodes.PERSIST_305.getSeverity(), typeNode.location());
        } else {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_305.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_305.getMessage(), modulePrefix + ":" + identifier), DiagnosticsCodes.PERSIST_305.getSeverity(), typeNode.location());
        }
        return validFlag;
    }

    public static boolean isValidSimpleType(String type, String datastore) {
        if (null == datastore) {
            return true;
        }
        return switch (datastore) {
            case "mysql" -> ValidatorsByDatastore.isValidMysqlType(type);
            case "mssql" -> ValidatorsByDatastore.isValidMssqlType(type);
            case "postgresql" -> ValidatorsByDatastore.isValidPostgresqlType(type);
            case "h2" -> ValidatorsByDatastore.isValidH2Type(type);
            case "inmemory" -> ValidatorsByDatastore.isValidInMemoryType(type);
            case "googlesheets" -> ValidatorsByDatastore.isValidGoogleSheetsType(type);
            case "redis" -> ValidatorsByDatastore.isValidRedisType(type);
            default -> false;
        };
    }

    public static boolean isValidArrayType(String type, String datastore) {
        if (null == datastore) {
            return true;
        }
        return switch (datastore) {
            case "mysql" -> ValidatorsByDatastore.isValidMysqlArrayType(type);
            case "mssql" -> ValidatorsByDatastore.isValidMssqlArrayType(type);
            case "postgresql" -> ValidatorsByDatastore.isValidPostgresqlArrayType(type);
            case "h2" -> ValidatorsByDatastore.isValidH2ArrayType(type);
            case "inmemory" -> ValidatorsByDatastore.isValidInMemoryArrayType(type);
            case "googlesheets" -> ValidatorsByDatastore.isValidGoogleSheetsArrayType(type);
            case "redis" -> ValidatorsByDatastore.isValidRedisArrayType(type);
            default -> false;
        };
    }

    public static boolean isValidImportedType(String modulePrefix, String identifier, String datastore) {
        if (null == datastore) {
            return true;
        }
        return switch (datastore) {
            case "mysql" -> ValidatorsByDatastore.isValidMysqlImportedType(modulePrefix, identifier);
            case "mssql" -> ValidatorsByDatastore.isValidMssqlImportedType(modulePrefix, identifier);
            case "postgresql" -> ValidatorsByDatastore.isValidPostgresqlImportedType(modulePrefix, identifier);
            case "h2" -> ValidatorsByDatastore.isValidH2ImportedType(modulePrefix, identifier);
            case "inmemory" -> ValidatorsByDatastore.isValidInMemoryImportedType(modulePrefix, identifier);
            case "googlesheets" -> ValidatorsByDatastore.isValidGoogleSheetsImportedType(modulePrefix, identifier);
            case "redis" -> ValidatorsByDatastore.isValidRedisImportedType(modulePrefix, identifier);
            default -> false;
        };
    }

    public static boolean isValidMysqlType(String type) {
        switch (type) {
            case "int": 
            case "boolean": 
            case "decimal": 
            case "float": 
            case "string": 
            case "enum": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidMssqlType(String type) {
        switch (type) {
            case "int": 
            case "boolean": 
            case "decimal": 
            case "float": 
            case "string": 
            case "enum": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPostgresqlType(String type) {
        switch (type) {
            case "int": 
            case "boolean": 
            case "decimal": 
            case "float": 
            case "string": 
            case "enum": {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidH2Type(String type) {
        return switch (type) {
            case "int", "boolean", "decimal", "float", "string", "enum" -> true;
            default -> false;
        };
    }

    public static boolean isValidInMemoryType(String type) {
        return true;
    }

    public static boolean isValidGoogleSheetsType(String type) {
        switch (type) {
            case "int": 
            case "boolean": 
            case "decimal": 
            case "float": 
            case "string": 
            case "enum": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidRedisType(String type) {
        switch (type) {
            case "int": 
            case "boolean": 
            case "decimal": 
            case "float": 
            case "string": 
            case "enum": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidMysqlArrayType(String type) {
        switch (type) {
            case "byte": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidMssqlArrayType(String type) {
        switch (type) {
            case "byte": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPostgresqlArrayType(String type) {
        switch (type) {
            case "byte": {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidH2ArrayType(String type) {
        return type.equals("byte");
    }

    public static boolean isValidInMemoryArrayType(String type) {
        return true;
    }

    public static boolean isValidGoogleSheetsArrayType(String type) {
        return false;
    }

    public static boolean isValidRedisArrayType(String type) {
        return false;
    }

    public static boolean isValidMysqlImportedType(String modulePrefix, String identifier) {
        if (!modulePrefix.equals("time")) {
            return false;
        }
        switch (identifier) {
            case "Date": 
            case "TimeOfDay": 
            case "Utc": 
            case "Civil": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidMssqlImportedType(String modulePrefix, String identifier) {
        if (!modulePrefix.equals("time")) {
            return false;
        }
        switch (identifier) {
            case "Date": 
            case "TimeOfDay": 
            case "Utc": 
            case "Civil": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPostgresqlImportedType(String modulePrefix, String identifier) {
        if (!modulePrefix.equals("time")) {
            return false;
        }
        switch (identifier) {
            case "Date": 
            case "TimeOfDay": 
            case "Utc": 
            case "Civil": {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidH2ImportedType(String modulePrefix, String identifier) {
        if (!modulePrefix.equals("time")) {
            return false;
        }
        return switch (identifier) {
            case "Date", "TimeOfDay", "Utc", "Civil" -> true;
            default -> false;
        };
    }

    public static boolean isValidInMemoryImportedType(String modulePrefix, String identifier) {
        return true;
    }

    public static boolean isValidGoogleSheetsImportedType(String modulePrefix, String identifier) {
        if (!modulePrefix.equals("time")) {
            return false;
        }
        switch (identifier) {
            case "Date": 
            case "TimeOfDay": 
            case "Utc": 
            case "Civil": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidRedisImportedType(String modulePrefix, String identifier) {
        if (!modulePrefix.equals("time")) {
            return false;
        }
        switch (identifier) {
            case "Date": 
            case "TimeOfDay": 
            case "Civil": 
            case "Utc": {
                return true;
            }
        }
        return false;
    }
}

