/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.bindgen.model.BFunction;
import org.ballerinalang.bindgen.model.JConstructor;
import org.ballerinalang.bindgen.model.JField;
import org.ballerinalang.bindgen.model.JMethod;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JClass {
    private final BindgenEnv env;
    private final Class<?> currentClass;
    private final String prefix;
    private final String packageName;
    private final boolean modulesFlag;
    private String shortClassName;
    private boolean importJavaArraysModule = false;
    private final Map<String, String> superClassPackage = new HashMap<String, String>();
    private final Set<String> importedPackages = new HashSet<String>();
    private final List<JField> fieldList = new ArrayList<JField>();
    private final List<JMethod> methodList = new ArrayList<JMethod>();
    private final List<JConstructor> constructorList = new ArrayList<JConstructor>();
    private final Map<String, Integer> overloadedMethods = new HashMap<String, Integer>();

    public JClass(Class<?> c, BindgenEnv env) {
        Class<?> sClass;
        this.env = env;
        this.currentClass = c;
        this.prefix = c.getName().replace(".", "_").replace("$", "_");
        this.shortClassName = BindgenUtils.getAlias(c, env.getAliases());
        this.packageName = c.getPackage().getName();
        this.shortClassName = this.getExceptionName(c, this.shortClassName);
        this.modulesFlag = env.getModulesFlag();
        for (sClass = c.getSuperclass(); sClass != null && !BindgenUtils.isPublicClass(sClass); sClass = sClass.getSuperclass()) {
        }
        if (sClass != null) {
            env.setSuperClasses(sClass);
            String simpleClassName = BindgenUtils.getAlias(sClass, env.getAliases()).replace("$", "");
            simpleClassName = this.getExceptionName(sClass, simpleClassName);
            this.superClassPackage.put(simpleClassName, sClass.getPackageName().replace(".", ""));
        }
        if (env.isDirectJavaClass()) {
            boolean isAbstract = Modifier.isAbstract(c.getModifiers());
            if (!isAbstract) {
                this.populateConstructors(c.getConstructors());
            }
            this.populateMethods(c);
            this.populateFields(c.getFields());
        }
        if (this.modulesFlag) {
            this.importedPackages.remove(c.getPackageName());
        }
    }

    private String getExceptionName(Class<?> exception, String name) {
        try {
            if (this.getClass().getClassLoader().loadClass(Exception.class.getCanonicalName()).isAssignableFrom(exception)) {
                String shortClassName = "J" + name;
                this.env.setAlias(shortClassName, exception.getName());
                return shortClassName;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return name;
    }

    private List<Method> getMethodsAsList(Class<?> classObject) {
        Method[] declaredMethods = classObject.getMethods();
        LinkedList<Method> classMethods = new LinkedList<Method>();
        for (Method m : declaredMethods) {
            if (m.isSynthetic() || m.getName().equals("toString") || !BindgenUtils.isPublicMethod(m)) continue;
            classMethods.add(m);
        }
        return classMethods;
    }

    private void populateConstructors(Constructor<?>[] constructors) {
        int i = 1;
        ArrayList<JConstructor> tempList = new ArrayList<JConstructor>();
        for (Constructor<?> constructor : constructors) {
            if (!BindgenUtils.isPublicConstructor(constructor)) continue;
            tempList.add(new JConstructor(constructor, this.env, this, null));
        }
        tempList.sort(Comparator.comparing(JConstructor::getParamTypes));
        for (JConstructor constructor : tempList) {
            JConstructor jConstructor = new JConstructor(constructor.getConstructor(), this.env, this, "new" + this.shortClassName + i);
            if (this.modulesFlag) {
                this.importedPackages.addAll(jConstructor.getImportedPackages());
            }
            this.constructorList.add(jConstructor);
            if (jConstructor.requireJavaArrays()) {
                this.importJavaArraysModule = true;
            }
            ++i;
        }
    }

    private void populateMethods(Class<?> c) {
        List<JMethod> tempList = this.sortInheritedMethods(this.getMethodsAsList(c), new ArrayList<JMethod>(), c);
        for (JMethod method : tempList) {
            this.setMethodCount(method.getJavaMethodName());
            JMethod jMethod = new JMethod(method.getMethod(), this.env, this.prefix, this.currentClass, this.isOverloaded(method.getMethod()) ? this.getMethodCount(method.getJavaMethodName()) : 0);
            if (jMethod.requireJavaArrays()) {
                this.importJavaArraysModule = true;
            }
            if (this.modulesFlag) {
                this.importedPackages.addAll(jMethod.getImportedPackages());
            }
            this.methodList.add(jMethod);
        }
        this.methodList.sort(Comparator.comparing(JMethod::getMethodName));
    }

    private List<JMethod> sortInheritedMethods(List<Method> methods, List<JMethod> sortedMethods, Class<?> declaringClass) {
        if (declaringClass == null) {
            return sortedMethods;
        }
        List<Method> superClassMethods = this.getSuperClassMethods(declaringClass.getSuperclass(), new ArrayList<Method>());
        ArrayList<JMethod> tempList = new ArrayList<JMethod>();
        ArrayList<Method> tempMethodList = new ArrayList<Method>(methods);
        for (Method method : tempMethodList) {
            boolean isInherited = superClassMethods.stream().anyMatch(m -> method.getName().equals(m.getName()) && Arrays.equals(method.getParameterTypes(), m.getParameterTypes()));
            if (isInherited) continue;
            tempList.add(new JMethod(method, this.env, this.prefix, this.currentClass, 0));
            methods.remove(method);
        }
        tempList.sort(Comparator.comparing(JMethod::getParamTypes));
        sortedMethods.addAll(0, tempList);
        return this.sortInheritedMethods(methods, sortedMethods, declaringClass.getSuperclass());
    }

    private List<Method> getSuperClassMethods(Class<?> superClass, List<Method> methods) {
        if (superClass == null) {
            return methods;
        }
        methods.addAll(this.getMethodsAsList(superClass));
        return this.getSuperClassMethods(superClass.getSuperclass(), methods);
    }

    private void populateFields(Field[] fields) {
        boolean addField = true;
        for (Field field : fields) {
            for (JField jField : this.fieldList) {
                if (!jField.getFieldName().equals(field.getName()) && BindgenUtils.isPublicField(field)) continue;
                addField = false;
            }
            if (!addField) continue;
            JField jFieldGetter = new JField(field, BFunction.BFunctionKind.FIELD_GET, this.env, this);
            this.fieldList.add(jFieldGetter);
            if (this.modulesFlag) {
                BindgenUtils.addImportedPackage(field.getType(), this.importedPackages);
            }
            if (jFieldGetter.requireJavaArrays()) {
                this.importJavaArraysModule = true;
            }
            if (BindgenUtils.isFinalField(field) || !BindgenUtils.isPublicField(field)) continue;
            this.fieldList.add(new JField(field, BFunction.BFunctionKind.FIELD_SET, this.env, this));
        }
    }

    private boolean isOverloaded(Method method) {
        boolean overloaded = false;
        int count = 0;
        for (Method m : this.getMethodsAsList(this.currentClass)) {
            if (!m.getName().equals(method.getName())) continue;
            ++count;
        }
        if (count > 1) {
            overloaded = true;
        }
        return overloaded;
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void setMethodCount(String methodName) {
        Integer methodCount = this.overloadedMethods.get(methodName);
        if (methodCount == null) {
            this.overloadedMethods.put(methodName, 1);
        } else {
            this.overloadedMethods.replace(methodName, methodCount + 1);
        }
    }

    private Integer getMethodCount(String methodName) {
        return this.overloadedMethods.get(methodName);
    }

    public Class<?> getCurrentClass() {
        return this.currentClass;
    }

    public boolean isImportJavaArraysModule() {
        return this.importJavaArraysModule;
    }

    public Set<String> getImportedPackages() {
        return this.importedPackages;
    }

    public List<JField> getFieldList() {
        return this.fieldList;
    }

    public List<JMethod> getMethodList() {
        return this.methodList;
    }

    public List<JConstructor> getConstructorList() {
        return this.constructorList;
    }

    public Map<String, String> getSuperClassPackage() {
        return this.superClassPackage;
    }
}

