/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.ballerinalang.bindgen.model.BFunction;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.BindgenConstants;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JMethod
extends BFunction {
    private final BindgenEnv env;
    private final boolean isStatic;
    private boolean hasReturn = false;
    private boolean returnError = false;
    private boolean objectReturn = false;
    private boolean isArrayReturn = false;
    private boolean hasException = false;
    private boolean handleException = false;
    private boolean isStringReturn = false;
    private boolean isStringArrayReturn = false;
    private boolean javaArraysModule = false;
    private final boolean isOptionalReturnTypes;
    private final String parentPrefix;
    private final Class<?> parentClass;
    private final Method method;
    private String methodName;
    private final String unescapedMethodName;
    private String returnType;
    private String exceptionName;
    private String returnTypeJava;
    private final String javaMethodName;
    private String exceptionConstName;
    private String returnComponentType;
    private final List<JParameter> parameters = new ArrayList<JParameter>();
    private final StringBuilder paramTypes = new StringBuilder();
    private final Set<String> importedPackages = new HashSet<String>();

    JMethod(Method m, BindgenEnv env, String parentPrefix, Class<?> jClass, int overloaded) {
        super(BFunction.BFunctionKind.METHOD, env);
        this.env = env;
        this.parentPrefix = parentPrefix;
        this.method = m;
        this.javaMethodName = m.getName();
        this.methodName = overloaded > 1 ? m.getName() + overloaded : m.getName();
        this.isStatic = BindgenUtils.isStaticMethod(m);
        super.setStatic(this.isStatic);
        this.parentClass = jClass;
        this.setDeclaringClass(this.parentClass);
        this.isOptionalReturnTypes = env.isOptionalTypes() || env.isOptionalReturnTypes();
        Class<?> returnTypeClass = m.getReturnType();
        if (!returnTypeClass.equals(Void.TYPE)) {
            this.setReturnTypeAttributes(returnTypeClass);
        }
        this.setExternalFunctionName(jClass.getName().replace(".", "_").replace("$", "_") + "_" + this.methodName);
        for (Class<?> exceptionType : m.getExceptionTypes()) {
            try {
                if (this.getClass().getClassLoader().loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom(exceptionType)) continue;
                JError jError = new JError(exceptionType);
                this.setThrowable(jError);
                BindgenUtils.addImportedPackage(exceptionType, this.importedPackages);
                this.exceptionName = jError.getShortExceptionName();
                this.exceptionConstName = jError.getExceptionConstName();
                if (env.getModulesFlag()) {
                    this.exceptionName = this.getPackageAlias(this.exceptionName, exceptionType);
                    this.exceptionConstName = this.getPackageAlias(this.exceptionConstName, exceptionType);
                }
                env.setExceptionList(jError);
                this.hasException = true;
                this.handleException = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.setErrorType(this.exceptionName);
        this.setParameters(m.getParameters());
        if (this.objectReturn && !env.getAllJavaClasses().contains(returnTypeClass.getName())) {
            if (this.isArrayReturn) {
                env.setClassListForLooping(returnTypeClass.getComponentType().getName());
            } else {
                env.setClassListForLooping(returnTypeClass.getName());
            }
        }
        this.unescapedMethodName = this.methodName;
        if (this.isStatic) {
            super.setFunctionName(BindgenUtils.getAlias(jClass, env.getAliases()) + "_" + this.methodName);
        } else {
            List<String> reservedWords = Arrays.asList(BindgenConstants.BALLERINA_RESERVED_WORDS);
            if (reservedWords.contains(this.methodName)) {
                this.methodName = "'" + this.methodName;
            }
            super.setFunctionName(this.methodName);
        }
        if (this.exceptionName == null && this.returnType == null && this.javaArraysModule) {
            this.setErrorType("error?");
        }
    }

    private void setReturnTypeAttributes(Class<?> returnTypeClass) {
        this.hasReturn = true;
        BindgenUtils.addImportedPackage(returnTypeClass, this.importedPackages);
        this.returnTypeJava = BindgenUtils.getBalReturnType(this.env, returnTypeClass);
        this.setExternalReturnType(BindgenUtils.getBallerinaHandleType(this.env, returnTypeClass));
        this.returnType = BindgenUtils.getBallerinaReturnType(this.env, returnTypeClass);
        this.returnType = this.getExceptionName(returnTypeClass, this.returnType);
        if (returnTypeClass.isArray()) {
            this.javaArraysModule = true;
            this.hasException = true;
            this.returnError = true;
            this.isArrayReturn = true;
            if (returnTypeClass.getComponentType().isPrimitive()) {
                this.objectReturn = false;
            } else if (BindgenUtils.getAlias(returnTypeClass, this.env.getAliases()).equals("String[]")) {
                this.objectReturn = false;
                this.isStringArrayReturn = true;
            } else {
                this.returnComponentType = BindgenUtils.getAlias(returnTypeClass.getComponentType(), this.env.getAliases());
                this.returnComponentType = this.isOptionalReturnTypes ? this.returnComponentType + "?" : this.returnComponentType;
                this.returnComponentType = this.getExceptionName(returnTypeClass.getComponentType(), this.returnComponentType);
                this.returnType = this.returnComponentType + "[]";
                Object object = this.returnType = this.isOptionalReturnTypes ? this.returnType + "?" : this.returnType;
                if (this.env.getModulesFlag()) {
                    this.returnType = this.getPackageAlias(this.returnType, returnTypeClass.getComponentType());
                    this.returnComponentType = this.getPackageAlias(this.returnComponentType, returnTypeClass.getComponentType());
                }
                this.objectReturn = true;
            }
        } else if (returnTypeClass.isPrimitive()) {
            this.objectReturn = false;
        } else if (BindgenUtils.getAlias(returnTypeClass, this.env.getAliases()).equals("String")) {
            this.isStringReturn = true;
        } else {
            if (this.env.getModulesFlag()) {
                this.returnType = this.getPackageAlias(this.returnType, returnTypeClass);
            }
            this.objectReturn = true;
        }
        this.setReturnType(this.returnType);
    }

    private String getPackageAlias(String shortClassName, Class<?> objectType) {
        if (objectType.getPackage() != this.parentClass.getPackage()) {
            return objectType.getPackageName().replace(".", "") + ":" + shortClassName;
        }
        return shortClassName;
    }

    private String getExceptionName(Class<?> exception, String name) {
        try {
            if (this.getClass().getClassLoader().loadClass(Exception.class.getCanonicalName()).isAssignableFrom(exception)) {
                return "J" + name;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return name;
    }

    private void setParameters(Parameter[] paramArr) {
        for (Parameter param : paramArr) {
            BindgenUtils.addImportedPackage(param.getType(), this.importedPackages);
            this.paramTypes.append(BindgenUtils.getAlias(param.getType(), this.env.getAliases()).toLowerCase(Locale.ENGLISH));
            JParameter parameter = new JParameter(param, this.parentClass, this.env);
            this.parameters.add(parameter);
            if (parameter.getIsPrimitiveArray().booleanValue()) {
                this.javaArraysModule = true;
                this.returnError = true;
                this.hasException = true;
            }
            if (!parameter.isObjArrayParam().booleanValue() && !parameter.getIsStringArray().booleanValue()) continue;
            this.javaArraysModule = true;
            this.returnError = true;
            this.hasException = true;
        }
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    String getParamTypes() {
        return this.paramTypes.toString();
    }

    public boolean getHasException() {
        return this.hasException;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    public boolean getHasReturn() {
        return this.hasReturn;
    }

    public String getMethodName() {
        return this.unescapedMethodName;
    }

    @Override
    public List<JParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public boolean isReturnError() {
        return this.returnError;
    }

    public Method getMethod() {
        return this.method;
    }

    boolean requireJavaArrays() {
        return this.javaArraysModule;
    }

    Set<String> getImportedPackages() {
        return this.importedPackages;
    }

    public boolean isArrayReturn() {
        return this.isArrayReturn;
    }

    public String getBalFunctionName() {
        return this.parentPrefix + "_" + this.unescapedMethodName;
    }

    public String getFunctionReturnType() {
        StringBuilder returnString = new StringBuilder();
        if (this.getHasReturn()) {
            returnString.append(this.returnType);
            if (this.getHasException()) {
                if (this.isHandleException()) {
                    returnString.append("|").append(this.getExceptionName());
                    if (this.isReturnError()) {
                        returnString.append("|error");
                    }
                } else {
                    returnString.append("|error");
                }
            }
        } else if (this.getHasException()) {
            if (this.isHandleException()) {
                returnString.append(this.getExceptionName()).append("?");
                if (this.isReturnError()) {
                    returnString.append("|error?");
                }
            } else {
                returnString.append("error?");
            }
        }
        return returnString.toString();
    }

    public String getReturnComponentType() {
        return this.returnComponentType;
    }

    public String getReturnTypeJava() {
        return this.returnTypeJava;
    }

    public String getExceptionConstName() {
        return this.exceptionConstName;
    }

    public boolean isObjectReturn() {
        return this.objectReturn;
    }

    public boolean isStringReturn() {
        return this.isStringReturn;
    }

    public boolean isStringArrayReturn() {
        return this.isStringArrayReturn;
    }
}

