/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.bindgen.utils.BindgenConstants;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JParameter {
    private final BindgenEnv env;
    private final String type;
    private final String externalType;
    private String shortTypeName;
    private String componentType;
    private String fieldName;
    private final Class<?> parentClass;
    private final Class<?> parameterClass;
    private Boolean isObj = false;
    private Boolean isString = false;
    private Boolean isObjArray = false;
    private Boolean isOptional = false;
    private final boolean modulesFlag;
    private Boolean isStringArray = false;
    private Boolean isPrimitiveArray = false;

    JParameter(Class<?> parameterClass, Class<?> parentClass, BindgenEnv env) {
        this.env = env;
        this.parameterClass = parameterClass;
        this.parentClass = parentClass;
        this.type = parameterClass.getName();
        this.shortTypeName = BindgenUtils.getBallerinaParamType(parameterClass, env);
        this.modulesFlag = env.getModulesFlag();
        try {
            if (this.getClass().getClassLoader().loadClass(Exception.class.getCanonicalName()).isAssignableFrom(parameterClass)) {
                this.shortTypeName = "J" + this.shortTypeName;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!parameterClass.isPrimitive()) {
            this.isObj = true;
        }
        if (env.isOptionalTypes() || env.isOptionalParamTypes()) {
            this.isOptional = true;
        }
        if (parameterClass.equals(String.class)) {
            this.isString = true;
            this.shortTypeName = this.isOptional.booleanValue() ? "string?" : "string";
        } else if (parameterClass.equals(String[].class)) {
            this.isStringArray = true;
            this.shortTypeName = this.isOptional != false ? "string?[]?" : "string[]";
            this.componentType = String.class.getName();
        } else if (!parameterClass.isPrimitive()) {
            if (parameterClass.isArray()) {
                this.setArrayAttributes(parameterClass);
            } else {
                if (this.modulesFlag) {
                    this.shortTypeName = this.getPackageAlias(this.shortTypeName, parameterClass);
                }
                String paramType = parameterClass.getName();
                if (!env.getAllJavaClasses().contains(paramType)) {
                    env.setClassListForLooping(paramType);
                }
            }
        }
        this.externalType = BindgenUtils.getBallerinaHandleType(env, parameterClass);
        this.fieldName = "arg";
    }

    JParameter(Parameter parameter, Class<?> parentClass, BindgenEnv env) {
        this(parameter.getType(), parentClass, env);
        List<String> reservedWords = Arrays.asList(BindgenConstants.BALLERINA_RESERVED_WORDS);
        this.fieldName = parameter.getName();
        if (reservedWords.contains(this.fieldName)) {
            this.fieldName = "'" + this.fieldName;
        }
    }

    private void setArrayAttributes(Class<?> parameterClass) {
        Class<?> component = parameterClass.getComponentType();
        this.componentType = component.getTypeName();
        if (!parameterClass.getComponentType().isPrimitive()) {
            this.isObjArray = true;
            this.isObj = false;
            if (this.modulesFlag) {
                this.shortTypeName = this.getPackageAlias(this.shortTypeName, component);
            }
            String componentClass = parameterClass.getComponentType().getName();
            if (!this.env.getAllJavaClasses().contains(componentClass)) {
                this.env.setClassListForLooping(componentClass);
            }
        } else {
            this.shortTypeName = BindgenUtils.getPrimitiveArrayType(this.type);
            this.isPrimitiveArray = true;
        }
    }

    private String getPackageAlias(String shortTypeName, Class<?> parameterClass) {
        if (parameterClass.getPackage() != this.parentClass.getPackage()) {
            return parameterClass.getPackageName().replace(".", "") + ":" + shortTypeName;
        }
        return shortTypeName;
    }

    Boolean isObjArrayParam() {
        return this.isObjArray;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Boolean getIsObj() {
        return this.isObj;
    }

    public Boolean getIsString() {
        return this.isString;
    }

    public Boolean isOptional() {
        return this.isOptional;
    }

    Boolean getIsPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public String getExternalType() {
        return this.externalType;
    }

    Boolean getIsStringArray() {
        return this.isStringArray;
    }

    public String getType() {
        return this.type;
    }

    public String getShortTypeName() {
        return this.shortTypeName;
    }

    public Boolean isArray() {
        return this.isObjArray != false || this.isStringArray != false || this.isPrimitiveArray != false;
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }
}

