/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.TomlDocument;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class BindgenEnv {
    private boolean modulesFlag = false;
    private boolean publicFlag = false;
    private boolean optionalTypesFlag = false;
    private boolean optionalParamTypesFlag = false;
    private boolean optionalReturnTypesFlag = false;
    private String outputPath;
    private String packageName;
    private Path projectRoot;
    private TomlDocument tomlDocument;
    private boolean directJavaClass = true;
    private final Set<String> classPaths = new HashSet<String>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Set<String> classListForLooping = new HashSet<String>();
    private final Set<String> allJavaClasses = new HashSet<String>();
    private final Set<JError> exceptionList = new HashSet<JError>();
    private final Map<String, String> failedClassGens = new HashMap<String, String>();
    private final List<String> failedMethodGens = new ArrayList<String>();
    private final Set<String> superClasses = new HashSet<String>();

    public void setModulesFlag(boolean modulesFlag) {
        this.modulesFlag = modulesFlag;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setProject(Project project) {
        this.projectRoot = project.sourceRoot();
        if (project.currentPackage() != null) {
            Package currentPackage = project.currentPackage();
            this.packageName = currentPackage.packageName().toString();
            if (currentPackage.ballerinaToml().isPresent()) {
                this.tomlDocument = ((BallerinaToml)currentPackage.ballerinaToml().get()).tomlDocument();
            }
        }
    }

    String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public TomlDocument getTomlDocument() {
        return this.tomlDocument;
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }

    public void setSuperClasses(Class<?> superClass) {
        for (Class<?> parent = superClass; parent != null && BindgenUtils.isPublicClass(parent); parent = parent.getSuperclass()) {
            this.superClasses.add(parent.getName());
        }
    }

    public Set<String> getSuperClasses() {
        return this.superClasses;
    }

    public boolean getModulesFlag() {
        return this.modulesFlag;
    }

    public boolean isDirectJavaClass() {
        return this.directJavaClass;
    }

    public void setDirectJavaClass(boolean directJavaClass) {
        this.directJavaClass = directJavaClass;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public Set<String> getClassPaths() {
        return this.classPaths;
    }

    public void addClasspath(String classpath) {
        this.classPaths.add(classpath);
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    String getAliasClassName(String alias) {
        return this.aliases.get(alias);
    }

    public void setAlias(String alias, String className) {
        this.aliases.put(alias, className);
    }

    String getAlias(String className) {
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            if (!className.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    String removeAlias(String alias) {
        return this.aliases.remove(alias);
    }

    boolean hasPublicFlag() {
        return this.publicFlag;
    }

    public void setPublicFlag(boolean publicFlag) {
        this.publicFlag = publicFlag;
    }

    public void setClassListForLooping(String classListForLooping) {
        if (!this.allJavaClasses.contains(classListForLooping)) {
            this.classListForLooping.add(classListForLooping);
        }
    }

    public Set<String> getClassListForLooping() {
        return this.classListForLooping;
    }

    public void clearClassListForLooping() {
        this.classListForLooping.clear();
    }

    public Set<String> getAllJavaClasses() {
        return this.allJavaClasses;
    }

    public void setAllJavaClasses(Set<String> newClasses) {
        this.allJavaClasses.addAll(newClasses);
    }

    public Set<JError> getExceptionList() {
        return this.exceptionList;
    }

    public void setExceptionList(JError jError) {
        this.exceptionList.add(jError);
    }

    public Map<String, String> getFailedClassGens() {
        return this.failedClassGens;
    }

    public void setFailedClassGens(String className, String errorDescription) {
        this.failedClassGens.put(className, errorDescription);
    }

    public List<String> getFailedMethodGens() {
        return this.failedMethodGens;
    }

    void setFailedMethodGens(String errorMsg) {
        this.failedMethodGens.add(errorMsg);
    }

    public boolean isOptionalTypes() {
        return this.optionalTypesFlag;
    }

    public void setOptionalTypesFlag(boolean value) {
        this.optionalTypesFlag = value;
    }

    public boolean isOptionalParamTypes() {
        return this.optionalParamTypesFlag;
    }

    public void setOptionalParamTypesFlag(boolean value) {
        this.optionalParamTypesFlag = value;
    }

    public boolean isOptionalReturnTypes() {
        return this.optionalReturnTypesFlag;
    }

    public void setOptionalReturnTypesFlag(boolean value) {
        this.optionalReturnTypesFlag = value;
    }
}

