/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.BFunction;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JConstructor;
import org.ballerinalang.bindgen.model.JField;
import org.ballerinalang.bindgen.model.JMethod;
import org.ballerinalang.bindgen.utils.BindgenConstants;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.bindgen.utils.BindgenNodeFactory;

public class BindgenTreeModifier {
    private final JClass jClass;
    public final BindgenEnv env;
    private static final String CLASS_DEF_ERROR = "error: unable to locate the class definition in the syntax tree";

    BindgenTreeModifier(JClass jClass, BindgenEnv env) {
        this.jClass = jClass;
        this.env = env;
    }

    ModulePartNode transform(ModulePartNode modulePartNode) throws BindgenException {
        NodeList<ImportDeclarationNode> imports = this.modifyImportDeclarationNodes((NodeList<ImportDeclarationNode>)modulePartNode.imports());
        NodeList<ModuleMemberDeclarationNode> members = this.modifyModuleMemberDeclarationNode((NodeList<ModuleMemberDeclarationNode>)modulePartNode.members());
        Token eofToken = modulePartNode.eofToken();
        return modulePartNode.modify(imports, members, eofToken);
    }

    private NodeList<ImportDeclarationNode> modifyImportDeclarationNodes(NodeList<ImportDeclarationNode> imports) {
        if (imports == null) {
            return AbstractNodeFactory.createNodeList((Node[])new ImportDeclarationNode[0]);
        }
        if (this.jClass.isImportJavaArraysModule()) {
            ImportDeclarationNode jArraysImport = BindgenNodeFactory.createImportDeclarationNode("ballerina", "jarrays", new LinkedList<String>(Arrays.asList("jballerina", ".", "java", ".", "arrays")));
            imports = imports.add((Node)jArraysImport);
        }
        if (this.env.getModulesFlag() && this.env.getPackageName() != null) {
            for (String packageName : this.jClass.getImportedPackages()) {
                ImportDeclarationNode packageImport = BindgenNodeFactory.createImportDeclarationNode(null, packageName.replace(".", ""), new LinkedList<CallSite>(Collections.singletonList(this.escapeName(this.env.getPackageName()) + "." + this.processModuleName(packageName))));
                imports = imports.add((Node)packageImport);
            }
        }
        return imports;
    }

    private NodeList<ModuleMemberDeclarationNode> modifyModuleMemberDeclarationNode(NodeList<ModuleMemberDeclarationNode> members) throws BindgenException {
        members = this.updateTypeReferences(members);
        members = this.updateInstanceMethods(members);
        members = this.updateInstanceFields(members);
        members = this.updateConstructors(members);
        members = this.updateStaticMethods(members);
        members = this.updateStaticFields(members);
        members = this.updateExternalMethods(members);
        return members;
    }

    private NodeList<ModuleMemberDeclarationNode> updateTypeReferences(NodeList<ModuleMemberDeclarationNode> members) throws BindgenException {
        LinkedList<TypeReferenceNode> typeReferences = new LinkedList<TypeReferenceNode>();
        AbstractMap.SimpleEntry<Integer, ClassDefinitionNode> classDefinitionDetails = this.retrieveClassDefinition(members);
        if (classDefinitionDetails == null) {
            throw new BindgenException(CLASS_DEF_ERROR);
        }
        NodeList classDefinitionMembers = classDefinitionDetails.getValue().members();
        for (Node node : classDefinitionMembers) {
            if (node.kind() != SyntaxKind.TYPE_REFERENCE) continue;
            typeReferences.add((TypeReferenceNode)node);
        }
        ClassDefinitionNode modifiedClassDefinition = classDefinitionDetails.getValue();
        NodeList memberList = modifiedClassDefinition.members();
        NodeList newMemberList = AbstractNodeFactory.createEmptyNodeList();
        LinkedList<TypeReferenceNode> newTypeReferences = new LinkedList<TypeReferenceNode>();
        for (Map.Entry<String, String> superClass : this.jClass.getSuperClassPackage().entrySet()) {
            TypeReferenceNode typeReferenceNode;
            Object completeSuperClassName = superClass.getKey();
            if (this.env.getModulesFlag() && !superClass.getValue().equals(this.jClass.getPackageName().replace(".", ""))) {
                completeSuperClassName = superClass.getValue() + ":" + superClass.getKey();
            }
            if (this.isFieldExists((String)completeSuperClassName, typeReferences) || (typeReferenceNode = this.generateTypeReference((String)completeSuperClassName)) == null) continue;
            newTypeReferences.add(typeReferenceNode);
        }
        for (Node node : memberList) {
            newMemberList = newMemberList.add(node);
            if (node.kind() != SyntaxKind.TYPE_REFERENCE) continue;
            newMemberList = newMemberList.addAll(newTypeReferences);
        }
        modifiedClassDefinition = modifiedClassDefinition.modify().withMembers(newMemberList).apply();
        return members.set(classDefinitionDetails.getKey().intValue(), (Node)modifiedClassDefinition);
    }

    private NodeList<ModuleMemberDeclarationNode> updateConstructors(NodeList<ModuleMemberDeclarationNode> members) {
        LinkedList<FunctionDefinitionNode> constructorFunctions = new LinkedList<FunctionDefinitionNode>();
        for (ModuleMemberDeclarationNode node : members) {
            if (node.kind() != SyntaxKind.FUNCTION_DEFINITION) continue;
            constructorFunctions.add((FunctionDefinitionNode)node);
        }
        NodeList memberList = members;
        for (JConstructor jConstructor : this.jClass.getConstructorList()) {
            FunctionDefinitionNode staticMethod;
            if (this.isFunctionExists(jConstructor.getFunctionName(), constructorFunctions) || (staticMethod = this.generateBalFunction(jConstructor, false)) == null) continue;
            memberList = memberList.add((Node)staticMethod);
        }
        return memberList;
    }

    private NodeList<ModuleMemberDeclarationNode> updateStaticMethods(NodeList<ModuleMemberDeclarationNode> members) {
        LinkedList<FunctionDefinitionNode> staticFunctions = new LinkedList<FunctionDefinitionNode>();
        for (ModuleMemberDeclarationNode node : members) {
            if (node.kind() != SyntaxKind.FUNCTION_DEFINITION) continue;
            staticFunctions.add((FunctionDefinitionNode)node);
        }
        NodeList memberList = members;
        for (JMethod jMethod : this.jClass.getMethodList()) {
            FunctionDefinitionNode staticMethod;
            if (!jMethod.isStatic() || this.isFunctionExists(jMethod.getBalFunctionName(), staticFunctions) || (staticMethod = this.generateBalFunction(jMethod, false)) == null) continue;
            memberList = memberList.add((Node)staticMethod);
        }
        return memberList;
    }

    private NodeList<ModuleMemberDeclarationNode> updateInstanceMethods(NodeList<ModuleMemberDeclarationNode> members) throws BindgenException {
        LinkedList<FunctionDefinitionNode> instanceFunctions = new LinkedList<FunctionDefinitionNode>();
        AbstractMap.SimpleEntry<Integer, ClassDefinitionNode> classDefinitionDetails = this.retrieveClassDefinition(members);
        if (classDefinitionDetails == null) {
            throw new BindgenException(CLASS_DEF_ERROR);
        }
        NodeList classDefinitionMembers = classDefinitionDetails.getValue().members();
        for (Node node : classDefinitionMembers) {
            if (node.kind() != SyntaxKind.FUNCTION_DEFINITION) continue;
            instanceFunctions.add((FunctionDefinitionNode)node);
        }
        ClassDefinitionNode modifiedClassDefinition = classDefinitionDetails.getValue();
        NodeList memberList = modifiedClassDefinition.members();
        for (JMethod jMethod : this.jClass.getMethodList()) {
            FunctionDefinitionNode instanceMethod;
            if (jMethod.isStatic() || this.isFunctionExists(jMethod.getBalFunctionName(), instanceFunctions) || (instanceMethod = this.generateBalFunction(jMethod, false)) == null) continue;
            memberList = memberList.add((Node)instanceMethod);
        }
        modifiedClassDefinition = modifiedClassDefinition.modify().withMembers(memberList).apply();
        return members.set(classDefinitionDetails.getKey().intValue(), (Node)modifiedClassDefinition);
    }

    private NodeList<ModuleMemberDeclarationNode> updateStaticFields(NodeList<ModuleMemberDeclarationNode> members) {
        LinkedList<FunctionDefinitionNode> staticFields = new LinkedList<FunctionDefinitionNode>();
        for (ModuleMemberDeclarationNode node : members) {
            if (node.kind() != SyntaxKind.FUNCTION_DEFINITION) continue;
            staticFields.add((FunctionDefinitionNode)node);
        }
        NodeList memberList = members;
        for (JField jField : this.jClass.getFieldList()) {
            FunctionDefinitionNode staticMethod;
            if (!jField.isStatic() || this.isFunctionExists(jField.getFunctionName(), staticFields) || (staticMethod = this.generateBalFunction(jField, false)) == null) continue;
            memberList = memberList.add((Node)staticMethod);
        }
        return memberList;
    }

    private NodeList<ModuleMemberDeclarationNode> updateInstanceFields(NodeList<ModuleMemberDeclarationNode> members) throws BindgenException {
        LinkedList<FunctionDefinitionNode> instanceFields = new LinkedList<FunctionDefinitionNode>();
        AbstractMap.SimpleEntry<Integer, ClassDefinitionNode> classDefinitionDetails = this.retrieveClassDefinition(members);
        if (classDefinitionDetails == null) {
            throw new BindgenException(CLASS_DEF_ERROR);
        }
        NodeList classDefinitionMembers = classDefinitionDetails.getValue().members();
        for (Node node : classDefinitionMembers) {
            if (node.kind() != SyntaxKind.FUNCTION_DEFINITION) continue;
            instanceFields.add((FunctionDefinitionNode)node);
        }
        ClassDefinitionNode modifiedClassDefinition = classDefinitionDetails.getValue();
        NodeList memberList = modifiedClassDefinition.members();
        for (JField jField : this.jClass.getFieldList()) {
            FunctionDefinitionNode instanceMethod;
            if (jField.isStatic() || this.isFunctionExists(jField.getFunctionName(), instanceFields) || (instanceMethod = this.generateBalFunction(jField, false)) == null) continue;
            memberList = memberList.add((Node)instanceMethod);
        }
        modifiedClassDefinition = modifiedClassDefinition.modify().withMembers(memberList).apply();
        return members.set(classDefinitionDetails.getKey().intValue(), (Node)modifiedClassDefinition);
    }

    private NodeList<ModuleMemberDeclarationNode> updateExternalMethods(NodeList<ModuleMemberDeclarationNode> members) {
        FunctionDefinitionNode generatedFunction;
        LinkedList<FunctionDefinitionNode> externalFunctions = new LinkedList<FunctionDefinitionNode>();
        for (ModuleMemberDeclarationNode node : members) {
            if (node.kind() != SyntaxKind.FUNCTION_DEFINITION) continue;
            externalFunctions.add((FunctionDefinitionNode)node);
        }
        NodeList memberList = members;
        for (JMethod jMethod : this.jClass.getMethodList()) {
            if (this.isFunctionExists(jMethod.getBalFunctionName(), externalFunctions) || (generatedFunction = this.generateBalFunction(jMethod, true)) == null) continue;
            memberList = memberList.add((Node)generatedFunction);
        }
        for (JField jField : this.jClass.getFieldList()) {
            if (this.isFunctionExists(jField.getFunctionName(), externalFunctions) || (generatedFunction = this.generateBalFunction(jField, true)) == null) continue;
            memberList = memberList.add((Node)generatedFunction);
        }
        for (JConstructor jConstructor : this.jClass.getConstructorList()) {
            if (this.isFunctionExists(jConstructor.getExternalFunctionName(), externalFunctions) || (generatedFunction = this.generateBalFunction(jConstructor, true)) == null) continue;
            memberList = memberList.add((Node)generatedFunction);
        }
        return memberList;
    }

    private AbstractMap.SimpleEntry<Integer, ClassDefinitionNode> retrieveClassDefinition(NodeList<ModuleMemberDeclarationNode> members) {
        AbstractMap.SimpleEntry<Integer, ClassDefinitionNode> entry = null;
        for (int i = 0; i < members.size(); ++i) {
            ClassDefinitionNode classDefinition;
            ModuleMemberDeclarationNode moduleMember = (ModuleMemberDeclarationNode)members.get(i);
            if (moduleMember.kind() != SyntaxKind.CLASS_DEFINITION || !(classDefinition = (ClassDefinitionNode)moduleMember).className().text().equals(this.jClass.getShortClassName())) continue;
            entry = new AbstractMap.SimpleEntry<Integer, ClassDefinitionNode>(i, classDefinition);
        }
        return entry;
    }

    private FunctionDefinitionNode generateBalFunction(BFunction bFunction, boolean isExternal) {
        try {
            return BindgenNodeFactory.createFunctionDefinitionNode(bFunction, isExternal);
        }
        catch (BindgenException e) {
            this.env.setFailedMethodGens("error: unable to generate the binding function '" + bFunction.getFunctionName() + "' of '" + bFunction.getDeclaringClass().getName() + "': " + e.getMessage());
            return null;
        }
    }

    private TypeReferenceNode generateTypeReference(String type) {
        return BindgenNodeFactory.createTypeReferenceNode(type);
    }

    private boolean isFieldExists(String fieldName, List<TypeReferenceNode> fieldList) {
        for (TypeReferenceNode memberNode : fieldList) {
            if (!memberNode.typeName().toString().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFunctionExists(String functionName, List<FunctionDefinitionNode> functionList) {
        for (FunctionDefinitionNode memberNode : functionList) {
            if (!memberNode.functionName().text().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private String processModuleName(String packageName) {
        String[] components;
        List<String> reservedWords = Arrays.asList(BindgenConstants.BALLERINA_RESERVED_WORDS);
        LinkedList<Object> moduleName = new LinkedList<Object>();
        for (String component : components = packageName.split("\\.")) {
            if (reservedWords.contains(component)) {
                moduleName.add("'" + component);
                continue;
            }
            moduleName.add(component);
        }
        return String.join((CharSequence)".", moduleName);
    }

    private String escapeName(String name) {
        List<String> reservedWords = Arrays.asList(BindgenConstants.BALLERINA_RESERVED_WORDS);
        if (reservedWords.contains(name)) {
            name = "'" + (String)name;
        }
        return name;
    }
}

