/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.AnyProto;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DurationProto;
import com.google.protobuf.EmptyProto;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StructProto;
import com.google.protobuf.TimestampProto;
import com.google.protobuf.WrappersProto;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.AnydataType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.MessageParser;
import io.ballerina.stdlib.grpc.MessageRegistry;
import io.ballerina.stdlib.grpc.ServicesBuilderUtils;
import io.ballerina.stdlib.grpc.StandardDescriptorBuilder;
import io.ballerina.stdlib.grpc.Status;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Message {
    private static final String GOOGLE_PROTOBUF_ANY = "google.protobuf.Any";
    private static final String GOOGLE_PROTOBUF_ANY_TYPE_URL = "google.protobuf.Any.type_url";
    private static final String GOOGLE_PROTOBUF_ANY_MESSAGE_NAME = "Any";
    private static final String GOOGLE_PROTOBUF_TIMESTAMP_SECONDS = "google.protobuf.Timestamp.seconds";
    private static final String GOOGLE_PROTOBUF_TIMESTAMP_NANOS = "google.protobuf.Timestamp.nanos";
    private static final String GOOGLE_PROTOBUF_DURATION_SECONDS = "google.protobuf.Duration.seconds";
    private static final String GOOGLE_PROTOBUF_DURATION_NANOS = "google.protobuf.Duration.nanos";
    private static final String GOOGLE_PROTOBUF_STRUCT = "google.protobuf.Struct";
    private static final String GOOGLE_PROTOBUF_STRUCT_FIELDS = "google.protobuf.Struct.fields";
    private static final String GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_KEY = "google.protobuf.Struct.FieldsEntry.key";
    private static final String GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_VALUE = "google.protobuf.Struct.FieldsEntry.value";
    private static final String GOOGLE_PROTOBUF_VALUE_LIST_VALUE = "google.protobuf.Value.list_value";
    private static final String GOOGLE_PROTOBUF_VALUE_STRUCT_VALUE = "google.protobuf.Value.struct_value";
    private static final String GOOGLE_PROTOBUF_LISTVALUE_VALUES = "google.protobuf.ListValue.values";
    private static final String GOOGLE_PROTOBUF_STRUCTVALUE_VALUES = "google.protobuf.StructValue.values";
    private static final String BALLERINA_ANY_VALUE_ENTRY = "value";
    private static final String BALLERINA_TYPE_URL_ENTRY = "typeUrl";
    private static final String PROTOBUF_DESC_ANNOTATION_VALUE = "value";
    private static final BigDecimal ANALOG_GIGA = new BigDecimal(1000000000);
    private String messageName;
    private String messageFullName;
    private int memoizedSize = -1;
    private HttpHeaders headers;
    private Object bMessage = null;
    private Descriptors.Descriptor descriptor = null;
    private static final ArrayType stringArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);
    private static final ArrayType booleanArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BOOLEAN);
    private static final ArrayType intArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_INT);
    private static final ArrayType uInt32ArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_INT_UNSIGNED_32);
    private static final ArrayType sint32ArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_INT_SIGNED_32);
    private static final ArrayType floatArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_FLOAT);
    private boolean isError = false;
    private Throwable error;

    public Message(String messageName, Object bMessage) {
        this.messageName = messageName;
        this.bMessage = bMessage;
        this.descriptor = this.getMessageDescriptorFromMessageRegistry(messageName);
    }

    public Message(Descriptors.Descriptor descriptor, Object bMessage) {
        this.descriptor = descriptor;
        this.bMessage = bMessage;
        this.messageName = descriptor.getName();
        this.messageFullName = descriptor.getFullName();
    }

    private Message(String messageName) {
        this.messageName = messageName;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public boolean isError() {
        return this.isError;
    }

    public Throwable getError() {
        return this.error;
    }

    public Object getbMessage() {
        return this.bMessage;
    }

    public Message(Throwable error) {
        this.error = error;
        this.isError = true;
    }

    public Message(String messageName, Type type, CodedInputStream input, Map<Integer, Descriptors.FieldDescriptor> fieldDescriptors) throws IOException {
        this(messageName);
        int typeUrlTag;
        boolean isAnyTypedMessage = false;
        boolean isTimestampMessage = false;
        String typeUrl = "";
        type = TypeUtils.getReferredType((Type)type);
        if (fieldDescriptors.size() == 0) {
            if (messageName.startsWith("google.protobuf")) {
                this.descriptor = this.getDescriptorForPredefinedTypes(messageName);
                fieldDescriptors = MessageParser.computeFieldTagValues(this.descriptor);
            } else if (type instanceof RecordType) {
                this.descriptor = this.getDescriptor((RecordType)type);
                fieldDescriptors = MessageParser.computeFieldTagValues(this.descriptor);
            }
        }
        if (type instanceof UnionType && !(type instanceof AnydataType) && type.isNilable()) {
            List memberTypes = ((UnionType)type).getMemberTypes();
            if (memberTypes.size() != 2) {
                throw Status.Code.INTERNAL.toStatus().withDescription("Error while decoding request message. Field type is not a valid optional field type : " + type.getName()).asRuntimeException();
            }
            for (Type memberType : memberTypes) {
                if (memberType.getTag() == 14) continue;
                type = memberType;
                break;
            }
        }
        BMap bBMap = null;
        BArray bArray = null;
        isAnyTypedMessage = GOOGLE_PROTOBUF_ANY.equals(messageName) && fieldDescriptors.values().stream().allMatch(fd -> fd.getFullName().contains(GOOGLE_PROTOBUF_ANY));
        boolean bl = isTimestampMessage = (type.getTag() == 34 || type.getTag() == 44) && messageName.equals("google.protobuf.Timestamp");
        if (type.getTag() == 24 && !isAnyTypedMessage) {
            bBMap = ValueCreator.createRecordValue((Module)type.getPackage(), (String)type.getName());
            this.bMessage = bBMap;
        } else if (isTimestampMessage) {
            tupleType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_DECIMAL));
            bArray = ValueCreator.createTupleValue((TupleType)tupleType);
            this.bMessage = bArray;
        } else if (type.getTag() == 4) {
            this.bMessage = ValueCreator.createDecimalValue((BigDecimal)new BigDecimal(0));
        } else if (type.getTag() == 27 && !isAnyTypedMessage) {
            bBMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA));
            this.bMessage = bBMap;
        } else if (type.getTag() == 44) {
            tupleType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_STRING, PredefinedTypes.TYPE_ANYDATA));
            bArray = ValueCreator.createTupleValue((TupleType)tupleType);
            this.bMessage = bArray;
        } else if (type.getTag() == 32) {
            bArray = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANYDATA));
            this.bMessage = bArray;
        } else if (isAnyTypedMessage && input != null && (typeUrlTag = input.readTag()) == 10) {
            typeUrl = input.readStringRequireUtf8();
            this.skipUnnecessaryAnyTypeTags(input);
            String s = Message.bytesToHex(this.codeInputStreamAnyTypeByteArray(input));
            this.bMessage = StringUtils.fromString((String)s);
            BMap anyMap = ValueCreator.createRecordValue((Module)type.getPackage(), (String)type.getName());
            anyMap.put((Object)StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY), (Object)StringUtils.fromString((String)typeUrl));
            anyMap.put((Object)StringUtils.fromString((String)"value"), this.bMessage);
            this.bMessage = anyMap;
            this.skipUnnecessaryAnyTypeTags(input);
            return;
        }
        if (input == null) {
            if (bBMap != null) {
                for (Map.Entry<Integer, Descriptors.FieldDescriptor> entry : fieldDescriptors.entrySet()) {
                    BString bFieldName = StringUtils.fromString((String)entry.getValue().getName());
                    if (entry.getValue().getType().toProto().getNumber() == 11 && !entry.getValue().isRepeated()) {
                        bBMap.put((Object)bFieldName, null);
                        continue;
                    }
                    if (entry.getValue().getType().toProto().getNumber() != 14) continue;
                    bBMap.put((Object)bFieldName, (Object)StringUtils.fromString((String)entry.getValue().getEnumType().findValueByNumber(0).toString()));
                }
            } else {
                block29: for (Map.Entry<Integer, Descriptors.FieldDescriptor> entry : fieldDescriptors.entrySet()) {
                    switch (entry.getValue().getType().toProto().getNumber()) {
                        case 1: 
                        case 2: {
                            this.bMessage = 0.0;
                            continue block29;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: {
                            this.bMessage = 0L;
                            continue block29;
                        }
                        case 9: {
                            this.bMessage = StringUtils.fromString((String)"");
                            continue block29;
                        }
                        case 8: {
                            this.bMessage = Boolean.FALSE;
                            continue block29;
                        }
                    }
                    throw Status.Code.INTERNAL.toStatus().withDescription("Error while decoding request message. Field type is not supported : " + String.valueOf(entry.getValue().getType())).asRuntimeException();
                }
            }
            return;
        }
        boolean done = false;
        block30: while (!done) {
            int tag;
            try {
                tag = input.readTag();
            }
            catch (InvalidProtocolBufferException e) {
                tag = input.getLastTag();
            }
            if (tag == 0) {
                done = true;
                continue;
            }
            if (fieldDescriptors.containsKey(tag)) {
                Descriptors.FieldDescriptor fieldDescriptor = fieldDescriptors.get(tag);
                BString bFieldName = StringUtils.fromString((String)fieldDescriptor.getName());
                switch (fieldDescriptor.getType().toProto().getNumber()) {
                    case 1: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray floatArray = ValueCreator.createArrayValue((ArrayType)floatArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int length = input.readRawVarint32();
                                    int limit = input.pushLimit(length);
                                    while (input.getBytesUntilLimit() > 0) {
                                        floatArray.add((long)floatArray.size(), input.readDouble());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)floatArray);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    floatArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)floatArray);
                                }
                                floatArray.add((long)floatArray.size(), input.readDouble());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readDouble());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readDouble());
                            break;
                        }
                        this.bMessage = input.readDouble();
                        break;
                    }
                    case 2: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray floatArray = ValueCreator.createArrayValue((ArrayType)floatArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        floatArray.add((long)floatArray.size(), (double)input.readFloat());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)floatArray);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    floatArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)floatArray);
                                }
                                floatArray.add((long)floatArray.size(), Double.parseDouble(String.valueOf(input.readFloat())));
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                double bValue = Double.parseDouble(String.valueOf(input.readFloat()));
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, bValue);
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)Double.parseDouble(String.valueOf(input.readFloat())));
                            break;
                        }
                        this.bMessage = Double.parseDouble(String.valueOf(input.readFloat()));
                        break;
                    }
                    case 3: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray intArray = ValueCreator.createArrayValue((ArrayType)intArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        intArray.add((long)intArray.size(), input.readInt64());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    intArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                }
                                intArray.add((long)intArray.size(), input.readInt64());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readInt64());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readInt64());
                            break;
                        }
                        if (bArray != null && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_TIMESTAMP_SECONDS)) {
                            bArray.add(0L, input.readInt64());
                            break;
                        }
                        if (this.bMessage instanceof BDecimal && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_DURATION_SECONDS)) {
                            this.bMessage = ValueCreator.createDecimalValue((BigDecimal)new BigDecimal(input.readInt64()));
                            break;
                        }
                        this.bMessage = input.readInt64();
                        break;
                    }
                    case 4: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray intArray = ValueCreator.createArrayValue((ArrayType)intArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        intArray.add((long)intArray.size(), input.readUInt64());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    intArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                }
                                intArray.add((long)intArray.size(), input.readUInt64());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readUInt64());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readUInt64());
                            break;
                        }
                        this.bMessage = input.readUInt64();
                        break;
                    }
                    case 5: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray int32Array = ValueCreator.createArrayValue((ArrayType)sint32ArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        int32Array.add((long)int32Array.size(), (long)input.readInt32());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)int32Array);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    int32Array = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)int32Array);
                                }
                                int32Array.add((long)int32Array.size(), (long)input.readInt32());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readInt32());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readInt32());
                            break;
                        }
                        if (bArray != null && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_TIMESTAMP_NANOS)) {
                            BigDecimal nanos = new BigDecimal(input.readInt32()).divide(ANALOG_GIGA, MathContext.DECIMAL128);
                            bArray.add(1L, (Object)ValueCreator.createDecimalValue((BigDecimal)nanos));
                            break;
                        }
                        if (this.bMessage instanceof BDecimal && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_DURATION_NANOS)) {
                            BigDecimal nanos = new BigDecimal(input.readInt32()).divide(ANALOG_GIGA, MathContext.DECIMAL128);
                            BigDecimal secondsValue = ((BDecimal)this.bMessage).value();
                            this.bMessage = ValueCreator.createDecimalValue((BigDecimal)secondsValue.add(nanos));
                            break;
                        }
                        this.bMessage = input.readInt32();
                        break;
                    }
                    case 13: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray intArray = ValueCreator.createArrayValue((ArrayType)uInt32ArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        intArray.add((long)intArray.size(), Integer.toUnsignedLong(input.readUInt32()));
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    intArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                }
                                intArray.add((long)intArray.size(), Integer.toUnsignedLong(input.readUInt32()));
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, Integer.toUnsignedLong(input.readUInt32()));
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)Integer.toUnsignedLong(input.readUInt32()));
                            break;
                        }
                        this.bMessage = Integer.toUnsignedLong(input.readUInt32());
                        break;
                    }
                    case 6: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray intArray = ValueCreator.createArrayValue((ArrayType)intArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        intArray.add((long)intArray.size(), input.readFixed64());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    intArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)intArray);
                                }
                                intArray.add((long)intArray.size(), input.readFixed64());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readFixed64());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readFixed64());
                            break;
                        }
                        this.bMessage = input.readFixed64();
                        break;
                    }
                    case 7: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray int32Array = ValueCreator.createArrayValue((ArrayType)sint32ArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        int32Array.add((long)int32Array.size(), (long)input.readFixed32());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)int32Array);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    int32Array = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)int32Array);
                                }
                                int32Array.add((long)int32Array.size(), (long)input.readFixed32());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readFixed32());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readFixed32());
                            break;
                        }
                        this.bMessage = input.readFixed32();
                        break;
                    }
                    case 18: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray sInt64Array = ValueCreator.createArrayValue((ArrayType)intArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        sInt64Array.add((long)sInt64Array.size(), input.readSInt64());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)sInt64Array);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    sInt64Array = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)sInt64Array);
                                }
                                sInt64Array.add((long)sInt64Array.size(), input.readSInt64());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readSInt64());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readSInt64());
                            break;
                        }
                        this.bMessage = input.readSInt64();
                        break;
                    }
                    case 17: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray sInt32Array = ValueCreator.createArrayValue((ArrayType)sint32ArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        sInt32Array.add((long)sInt32Array.size(), (long)input.readSInt32());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)sInt32Array);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    sInt32Array = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)sInt32Array);
                                }
                                sInt32Array.add((long)sInt32Array.size(), (long)input.readSInt32());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readSInt32());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readSInt32());
                            break;
                        }
                        this.bMessage = input.readSInt32();
                        break;
                    }
                    case 16: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray sFixed64Array = ValueCreator.createArrayValue((ArrayType)intArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        sFixed64Array.add((long)sFixed64Array.size(), input.readSFixed64());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)sFixed64Array);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    sFixed64Array = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)sFixed64Array);
                                }
                                sFixed64Array.add((long)sFixed64Array.size(), input.readSFixed64());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readSFixed64());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readSFixed64());
                            break;
                        }
                        this.bMessage = input.readSFixed64();
                        break;
                    }
                    case 15: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray sFixed32Array = ValueCreator.createArrayValue((ArrayType)sint32ArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        sFixed32Array.add((long)sFixed32Array.size(), (long)input.readSFixed32());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)sFixed32Array);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    sFixed32Array = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)sFixed32Array);
                                }
                                sFixed32Array.add((long)sFixed32Array.size(), (long)input.readSFixed32());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readSFixed32());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readSFixed32());
                            break;
                        }
                        this.bMessage = input.readSFixed32();
                        break;
                    }
                    case 8: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray booleanArray = ValueCreator.createArrayValue((ArrayType)booleanArrayType);
                                if (tag == this.getPackedTagValue(fieldDescriptor.getNumber())) {
                                    int limit = input.pushLimit(input.readRawVarint32());
                                    while (input.getBytesUntilLimit() > 0) {
                                        booleanArray.add((long)booleanArray.size(), input.readBool());
                                    }
                                    input.popLimit(limit);
                                    bBMap.put((Object)bFieldName, (Object)booleanArray);
                                    break;
                                }
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    booleanArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)booleanArray);
                                }
                                booleanArray.add((long)booleanArray.size(), input.readBool());
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, input.readBool());
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)input.readBool());
                            break;
                        }
                        this.bMessage = input.readBool();
                        break;
                    }
                    case 9: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray stringArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    stringArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)stringArray);
                                }
                                stringArray.add((long)stringArray.size(), StringUtils.fromString((String)input.readStringRequireUtf8()));
                                bBMap.put((Object)bFieldName, (Object)stringArray);
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, StringUtils.fromString((String)input.readStringRequireUtf8()));
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)StringUtils.fromString((String)input.readStringRequireUtf8()));
                            break;
                        }
                        if (bArray != null && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_KEY)) {
                            bArray.add(0L, StringUtils.fromString((String)input.readStringRequireUtf8()));
                            break;
                        }
                        if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_ANY_TYPE_URL)) continue block30;
                        this.bMessage = StringUtils.fromString((String)input.readStringRequireUtf8());
                        break;
                    }
                    case 14: {
                        if (bBMap != null) {
                            if (fieldDescriptor.isRepeated()) {
                                BArray stringArray = ValueCreator.createArrayValue((ArrayType)stringArrayType);
                                if (bBMap.containsKey((Object)bFieldName)) {
                                    stringArray = (BArray)bBMap.get((Object)bFieldName);
                                } else {
                                    bBMap.put((Object)bFieldName, (Object)stringArray);
                                }
                                stringArray.add((long)stringArray.size(), StringUtils.fromString((String)fieldDescriptor.getEnumType().findValueByNumber(input.readEnum()).toString()));
                                bBMap.put((Object)bFieldName, (Object)stringArray);
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                String bValue = fieldDescriptor.getEnumType().findValueByNumber(input.readEnum()).toString();
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, StringUtils.fromString((String)bValue));
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)StringUtils.fromString((String)fieldDescriptor.getEnumType().findValueByNumber(input.readEnum()).toString()));
                            break;
                        }
                        this.bMessage = StringUtils.fromString((String)fieldDescriptor.getEnumType().findValueByNumber(input.readEnum()).toString());
                        break;
                    }
                    case 12: {
                        if (bBMap != null) {
                            if (fieldDescriptor.getContainingOneof() != null) {
                                BArray bValue = ValueCreator.createArrayValue((byte[])input.readByteArray());
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, bValue);
                                break;
                            }
                            bBMap.put((Object)bFieldName, (Object)ValueCreator.createArrayValue((byte[])input.readByteArray()));
                            break;
                        }
                        this.bMessage = ValueCreator.createArrayValue((byte[])input.readByteArray());
                        break;
                    }
                    case 11: {
                        RecordType recordType;
                        if (type instanceof RecordType) {
                            recordType = (RecordType)type;
                        } else if (type instanceof MapType || type instanceof TupleType || type instanceof AnydataType || type.getTag() == TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANYDATA).getTag()) {
                            recordType = null;
                        } else {
                            throw Status.Code.INTERNAL.toStatus().withDescription("Error while decoding request message. record type is not supported : " + String.valueOf(fieldDescriptor.getType())).asRuntimeException();
                        }
                        if (bBMap != null) {
                            if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDS) || fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCTVALUE_VALUES)) {
                                BArray tupleval = (BArray)this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)TypeCreator.createTupleType(Arrays.asList(new Type[]{PredefinedTypes.TYPE_STRING, PredefinedTypes.TYPE_ANYDATA})), (CodedInputStream)input).bMessage;
                                bBMap.put((Object)tupleval.getBString(0L), tupleval.get(1L));
                                break;
                            }
                            if (fieldDescriptor.isRepeated()) {
                                BArray valueArray = bBMap.get((Object)bFieldName) != null ? (BArray)bBMap.get((Object)bFieldName) : null;
                                Type fieldType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
                                if (valueArray == null || valueArray.size() == 0) {
                                    valueArray = ValueCreator.createArrayValue((ArrayType)((ArrayType)fieldType));
                                    bBMap.put((Object)bFieldName, (Object)valueArray);
                                }
                                valueArray.add((long)valueArray.size(), this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)TypeUtils.getReferredType((Type)((ArrayType)fieldType).getElementType()), (CodedInputStream)input).bMessage);
                                break;
                            }
                            if (fieldDescriptor.getContainingOneof() != null) {
                                Type fieldType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
                                Object bValue = this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)fieldType, (CodedInputStream)input).bMessage;
                                this.updateBBMap((BMap<BString, Object>)bBMap, fieldDescriptor, bValue);
                                break;
                            }
                            if (fieldDescriptor.getMessageType().getFullName().equals(GOOGLE_PROTOBUF_STRUCT) && recordType instanceof RecordType) {
                                MapType fieldType = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA);
                                bBMap.put((Object)bFieldName, this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)fieldType, (CodedInputStream)input).bMessage);
                                break;
                            }
                            Type fieldType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
                            bBMap.put((Object)bFieldName, this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)fieldType, (CodedInputStream)input).bMessage);
                            break;
                        }
                        if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_VALUE)) {
                            bArray.add(1L, this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)PredefinedTypes.TYPE_ANYDATA, (CodedInputStream)input).bMessage);
                            break;
                        }
                        if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_VALUE_LIST_VALUE)) {
                            this.bMessage = this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANYDATA), (CodedInputStream)input).bMessage;
                            break;
                        }
                        if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_LISTVALUE_VALUES)) {
                            bArray.add((long)bArray.size(), this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)PredefinedTypes.TYPE_ANYDATA, (CodedInputStream)input).bMessage);
                            break;
                        }
                        if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_VALUE_STRUCT_VALUE)) {
                            this.bMessage = this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA), (CodedInputStream)input).bMessage;
                            break;
                        }
                        Type fieldType = TypeUtils.getReferredType((Type)((Field)recordType.getFields().get(bFieldName.getValue())).getFieldType());
                        this.bMessage = this.readMessage((Descriptors.FieldDescriptor)fieldDescriptor, (Type)fieldType, (CodedInputStream)input).bMessage;
                        break;
                    }
                    default: {
                        throw Status.Code.INTERNAL.toStatus().withDescription("Error while decoding request message. Field type is not supported : " + String.valueOf(fieldDescriptor.getType())).asRuntimeException();
                    }
                }
                continue;
            }
            input.skipField(tag);
        }
        if (isAnyTypedMessage) {
            BMap anyMap = ValueCreator.createRecordValue((Module)type.getPackage(), (String)type.getName());
            anyMap.put((Object)StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY), (Object)StringUtils.fromString((String)typeUrl));
            anyMap.put((Object)StringUtils.fromString((String)"value"), this.bMessage);
            this.bMessage = anyMap;
        }
        if (isTimestampMessage && this.bMessage instanceof BArray) {
            ((BArray)this.bMessage).freezeDirect();
        }
    }

    private int getPackedTagValue(int number) {
        return (number << 3) + 2;
    }

    private byte[] codeInputStreamAnyTypeByteArray(CodedInputStream input) throws IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (!input.isAtEnd()) {
            byteList.add(input.readRawByte());
        }
        byte[] byteArray = new byte[byteList.size()];
        for (int i = 0; i < byteList.size(); ++i) {
            byteArray[i] = (Byte)byteList.get(i);
        }
        return byteArray;
    }

    private void updateBBMap(BMap<BString, Object> bBMap, Descriptors.FieldDescriptor fieldDescriptor, Object bValue) {
        bBMap.put((Object)StringUtils.fromString((String)fieldDescriptor.getName()), bValue);
    }

    private Descriptors.Descriptor getDescriptor() throws InvalidProtocolBufferException {
        if (this.descriptor == null || this.descriptor.getFile().getFullName().endsWith(".placeholder.proto")) {
            if (this.descriptor != null && this.descriptor.getFile().getFullName().startsWith("google.protobuf")) {
                String messageName = this.descriptor.getFile().getFullName().replace(".placeholder.proto", "");
                return this.getDescriptorForPredefinedTypes(messageName);
            }
            if (this.bMessage != null && this.bMessage instanceof BMap) {
                BMap bMap = (BMap)this.bMessage;
                RecordType recordType = (RecordType)bMap.getType();
                return this.getDescriptorFromRecord(recordType);
            }
        } else if (this.descriptor != null) {
            return this.descriptor;
        }
        return this.getMessageDescriptorFromMessageRegistry(this.messageName);
    }

    private Descriptors.Descriptor getDescriptor(RecordType recordType) throws InvalidProtocolBufferException {
        if (this.descriptor == null || this.descriptor.getFile().getFullName().endsWith(".placeholder.proto")) {
            return this.getDescriptorFromRecord(recordType);
        }
        return this.descriptor;
    }

    private Descriptors.Descriptor getDescriptorForPredefinedTypes(String messageName) {
        Descriptors.FileDescriptor fileDescriptor = StandardDescriptorBuilder.getFileDescriptorFromMessageName(messageName);
        return fileDescriptor.findMessageTypeByName(this.extractMessageNameWithoutNamespace(messageName));
    }

    private String extractMessageNameWithoutNamespace(String messageName) {
        String[] messageEntries = messageName.split("\\.");
        return messageEntries[messageEntries.length - 1];
    }

    private Descriptors.Descriptor getDescriptorFromRecord(RecordType recordType) throws InvalidProtocolBufferException {
        return this.getDescriptorFromRecord(recordType, this.messageName);
    }

    private Descriptors.Descriptor getDescriptorFromRecord(RecordType recordType, String messageName) throws InvalidProtocolBufferException {
        if (this.isDescriptorAnnotationAvailable(recordType)) {
            return this.extractDescriptorFromAnnotation((BMap<BString, Object>)recordType.getAnnotations(), recordType.getName());
        }
        RecordType createdRecordType = (RecordType)ValueCreator.createRecordValue((Module)recordType.getPackage(), (String)messageName).getType();
        if (this.isDescriptorAnnotationAvailable(createdRecordType)) {
            return this.extractDescriptorFromAnnotation((BMap<BString, Object>)createdRecordType.getAnnotations(), this.messageName);
        }
        return this.getMessageDescriptorFromMessageRegistry(messageName);
    }

    private Descriptors.Descriptor extractDescriptorFromAnnotation(BMap<BString, Object> annotations, String msgName) throws InvalidProtocolBufferException {
        String annotation = this.filterDescAnnotation(annotations);
        byte[] annotationAsBytes = ServicesBuilderUtils.hexStringToByteArray(annotation);
        DescriptorProtos.FileDescriptorProto file = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])annotationAsBytes);
        try {
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)file, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0], (boolean)true);
            Descriptors.Descriptor desc = fileDescriptor.findMessageTypeByName(msgName);
            if (desc != null) {
                return desc;
            }
        }
        catch (Descriptors.DescriptorValidationException descriptorValidationException) {
            // empty catch block
        }
        return this.getMessageDescriptorFromMessageRegistry(this.messageName);
    }

    private String filterDescAnnotation(BMap<BString, Object> annotations) {
        for (BString annotationName : (BString[])annotations.getKeys()) {
            if (!this.isValidProtoAnnotation(annotationName.getValue())) continue;
            return annotations.getMapValue(annotationName).getStringValue(StringUtils.fromString((String)"value")).getValue();
        }
        return "";
    }

    private boolean isDescriptorAnnotationAvailable(RecordType recordType) {
        return Arrays.stream((BString[])recordType.getAnnotations().getKeys()).anyMatch(s -> this.isValidProtoAnnotation(s.getValue()));
    }

    private boolean isValidProtoAnnotation(String annotationName) {
        return annotationName.contains("ballerina") && annotationName.contains("protobuf") && annotationName.contains("Descriptor");
    }

    private Descriptors.Descriptor getMessageDescriptorFromMessageRegistry(String messageName) {
        Map<String, Descriptors.Descriptor> messageDescriptorMap = MessageRegistry.getInstance().getMessageDescriptorMap();
        if (messageDescriptorMap.containsKey(messageName)) {
            return messageDescriptorMap.get(messageName);
        }
        return messageDescriptorMap.get(this.messageFullName);
    }

    void writeTo(CodedOutputStream output) throws IOException {
        if (this.bMessage == null) {
            return;
        }
        Descriptors.Descriptor messageDescriptor = this.getDescriptor();
        if (messageDescriptor == null) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Error while processing the message, Couldn't find message descriptor for message name: " + this.messageName).asRuntimeException();
        }
        if (GOOGLE_PROTOBUF_ANY.equals(this.descriptor.getFullName())) {
            BMap anyTypedRecord = (BMap)this.bMessage;
            byte[] anyTypedContentArray = ServicesBuilderUtils.hexStringToByteArray(anyTypedRecord.getStringValue(StringUtils.fromString((String)"value")).getValue());
            String typeUrl = anyTypedRecord.getStringValue(StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY)).getValue();
            output.writeString(1, typeUrl);
            output.writeTag(2, 2);
            output.writeUInt32NoTag(anyTypedContentArray.length);
            for (byte b : anyTypedContentArray) {
                output.write(b);
            }
            return;
        }
        BMap bBMap = null;
        BArray bArray = null;
        if (this.bMessage instanceof BMap) {
            bBMap = (BMap)this.bMessage;
        } else if (this.bMessage instanceof BArray) {
            bArray = (BArray)this.bMessage;
        }
        block20: for (Descriptors.FieldDescriptor fieldDescriptor : messageDescriptor.getFields()) {
            BString bFieldName = StringUtils.fromString((String)fieldDescriptor.getName());
            switch (fieldDescriptor.getType().toProto().getNumber()) {
                case 1: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeDouble(fieldDescriptor.getNumber(), valueArray.getFloat((long)i));
                            }
                            continue block20;
                        }
                        output.writeDouble(fieldDescriptor.getNumber(), ((Double)bValue).doubleValue());
                        break;
                    }
                    if (this.bMessage instanceof Double) {
                        output.writeDouble(fieldDescriptor.getNumber(), ((Double)this.bMessage).doubleValue());
                        break;
                    }
                    if (this.bMessage instanceof Integer) {
                        output.writeDouble(fieldDescriptor.getNumber(), (double)((Integer)this.bMessage).intValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeDouble(fieldDescriptor.getNumber(), (double)((Long)this.bMessage).longValue());
                    break;
                }
                case 2: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeFloat(fieldDescriptor.getNumber(), Float.parseFloat(String.valueOf(valueArray.getFloat((long)i))));
                            }
                            continue block20;
                        }
                        output.writeFloat(fieldDescriptor.getNumber(), Float.parseFloat(String.valueOf(bValue)));
                        break;
                    }
                    if (!(this.bMessage instanceof Double)) continue block20;
                    output.writeFloat(fieldDescriptor.getNumber(), Float.parseFloat(String.valueOf(this.bMessage)));
                    break;
                }
                case 3: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeInt64(fieldDescriptor.getNumber(), valueArray.getInt((long)i));
                            }
                            continue block20;
                        }
                        output.writeInt64(fieldDescriptor.getNumber(), ((Long)bValue).longValue());
                        break;
                    }
                    if (this.bMessage instanceof BArray && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_TIMESTAMP_SECONDS)) {
                        output.writeInt64(fieldDescriptor.getNumber(), ((Long)bArray.get(0L)).longValue());
                        break;
                    }
                    if (this.bMessage instanceof BDecimal && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_DURATION_SECONDS)) {
                        output.writeInt64(fieldDescriptor.getNumber(), (long)((BDecimal)this.bMessage).value().intValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeInt64(fieldDescriptor.getNumber(), ((Long)this.bMessage).longValue());
                    break;
                }
                case 4: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeUInt64(fieldDescriptor.getNumber(), valueArray.getInt((long)i));
                            }
                            continue block20;
                        }
                        output.writeUInt64(fieldDescriptor.getNumber(), ((Long)bValue).longValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeUInt64(fieldDescriptor.getNumber(), ((Long)this.bMessage).longValue());
                    break;
                }
                case 5: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeInt32(fieldDescriptor.getNumber(), this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block20;
                        }
                        output.writeInt32(fieldDescriptor.getNumber(), this.getIntValue(bValue));
                        break;
                    }
                    if (this.bMessage instanceof BArray && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_TIMESTAMP_NANOS)) {
                        BigDecimal nanos = new BigDecimal(bArray.get(1L).toString()).multiply(ANALOG_GIGA);
                        output.writeInt32(fieldDescriptor.getNumber(), nanos.intValue());
                        break;
                    }
                    if (this.bMessage instanceof BDecimal && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_DURATION_NANOS)) {
                        int intVal = ((BDecimal)this.bMessage).value().intValue();
                        BigDecimal b = ((BDecimal)this.bMessage).value().subtract(new BigDecimal(intVal));
                        output.writeInt32(fieldDescriptor.getNumber(), b.multiply(ANALOG_GIGA).intValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeInt32(fieldDescriptor.getNumber(), this.getIntValue(this.bMessage));
                    break;
                }
                case 13: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeUInt32(fieldDescriptor.getNumber(), Integer.parseUnsignedInt(String.valueOf(valueArray.getInt((long)i))));
                            }
                            continue block20;
                        }
                        output.writeUInt32(fieldDescriptor.getNumber(), Integer.parseUnsignedInt(String.valueOf(bValue)));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeUInt32(fieldDescriptor.getNumber(), Integer.parseUnsignedInt(String.valueOf(this.bMessage)));
                    break;
                }
                case 6: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeFixed64(fieldDescriptor.getNumber(), valueArray.getInt((long)i));
                            }
                            continue block20;
                        }
                        output.writeFixed64(fieldDescriptor.getNumber(), ((Long)bValue).longValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeFixed64(fieldDescriptor.getNumber(), ((Long)this.bMessage).longValue());
                    break;
                }
                case 7: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeFixed32(fieldDescriptor.getNumber(), this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block20;
                        }
                        output.writeFixed32(fieldDescriptor.getNumber(), this.getIntValue(bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeFixed32(fieldDescriptor.getNumber(), this.getIntValue(this.bMessage));
                    break;
                }
                case 18: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeSInt64(fieldDescriptor.getNumber(), valueArray.getInt((long)i));
                            }
                            continue block20;
                        }
                        output.writeSInt64(fieldDescriptor.getNumber(), ((Long)bValue).longValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeSInt64(fieldDescriptor.getNumber(), ((Long)this.bMessage).longValue());
                    break;
                }
                case 17: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeSInt32(fieldDescriptor.getNumber(), this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block20;
                        }
                        output.writeSInt32(fieldDescriptor.getNumber(), this.getIntValue(bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeSInt32(fieldDescriptor.getNumber(), this.getIntValue(this.bMessage));
                    break;
                }
                case 16: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeSFixed64(fieldDescriptor.getNumber(), valueArray.getInt((long)i));
                            }
                            continue block20;
                        }
                        output.writeSFixed64(fieldDescriptor.getNumber(), ((Long)bValue).longValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeSFixed64(fieldDescriptor.getNumber(), ((Long)this.bMessage).longValue());
                    break;
                }
                case 15: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeSFixed32(fieldDescriptor.getNumber(), this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block20;
                        }
                        output.writeSFixed32(fieldDescriptor.getNumber(), this.getIntValue(bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block20;
                    output.writeSFixed32(fieldDescriptor.getNumber(), this.getIntValue(this.bMessage));
                    break;
                }
                case 8: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeBool(fieldDescriptor.getNumber(), valueArray.getBoolean((long)i));
                            }
                            continue block20;
                        }
                        output.writeBool(fieldDescriptor.getNumber(), ((Boolean)bValue).booleanValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Boolean)) continue block20;
                    output.writeBool(fieldDescriptor.getNumber(), ((Boolean)this.bMessage).booleanValue());
                    break;
                }
                case 9: {
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                output.writeString(fieldDescriptor.getNumber(), valueArray.getBString((long)i).getValue());
                            }
                            continue block20;
                        }
                        output.writeString(fieldDescriptor.getNumber(), ((BString)bValue).getValue());
                        break;
                    }
                    if (bArray != null && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_KEY)) {
                        output.writeString(fieldDescriptor.getNumber(), ((BString)bArray.get(0L)).getValue());
                        break;
                    }
                    if (this.bMessage instanceof BString && !fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_ANY_TYPE_URL)) {
                        output.writeString(fieldDescriptor.getNumber(), ((BString)this.bMessage).getValue());
                        break;
                    }
                    if (!GOOGLE_PROTOBUF_ANY_MESSAGE_NAME.equals(this.messageName)) continue block20;
                    output.writeString(fieldDescriptor.getNumber(), ((BMap)this.bMessage).getStringValue(StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY)).getValue());
                    break;
                }
                case 11: {
                    Message message;
                    Object value;
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (fieldDescriptor.isRepeated() && bValue instanceof BArray) {
                            valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                value = valueArray.getRefValue((long)i);
                                Message message2 = new Message(fieldDescriptor.getMessageType(), value);
                                output.writeTag(fieldDescriptor.getNumber(), 2);
                                output.writeUInt32NoTag(message2.getSerializedSize());
                                message2.writeTo(output);
                            }
                            continue block20;
                        }
                        message = new Message(fieldDescriptor.getMessageType(), bValue);
                        output.writeTag(fieldDescriptor.getNumber(), 2);
                        output.writeUInt32NoTag(message.getSerializedSize());
                        message.writeTo(output);
                        break;
                    }
                    if (bBMap != null && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDS)) {
                        for (Map.Entry entry : bBMap.entrySet()) {
                            BArray valueArray2 = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANY), (int)2);
                            valueArray2.add(0L, entry.getKey());
                            valueArray2.add(1L, entry.getValue());
                            Message message3 = new Message(fieldDescriptor.getMessageType(), (Object)valueArray2);
                            output.writeTag(fieldDescriptor.getNumber(), 2);
                            output.writeUInt32NoTag(message3.getSerializedSize());
                            message3.writeTo(output);
                        }
                        continue block20;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_VALUE) && bArray != null) {
                        Message message4 = new Message(fieldDescriptor.getMessageType(), bArray.get(1L));
                        output.writeTag(fieldDescriptor.getNumber(), 2);
                        output.writeUInt32NoTag(message4.getSerializedSize());
                        message4.writeTo(output);
                        break;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_VALUE_LIST_VALUE) && bArray != null) {
                        Message message5 = new Message(fieldDescriptor.getMessageType(), (Object)bArray);
                        output.writeTag(fieldDescriptor.getNumber(), 2);
                        output.writeUInt32NoTag(message5.getSerializedSize());
                        message5.writeTo(output);
                        break;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_VALUE_STRUCT_VALUE) && bBMap != null) {
                        Message message6 = new Message(fieldDescriptor.getMessageType(), (Object)bBMap);
                        output.writeTag(fieldDescriptor.getNumber(), 2);
                        output.writeUInt32NoTag(message6.getSerializedSize());
                        message6.writeTo(output);
                        break;
                    }
                    if (!fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_LISTVALUE_VALUES)) continue block20;
                    for (int i = 0; i < bArray.size(); ++i) {
                        message = new Message(fieldDescriptor.getMessageType(), bArray.get((long)i));
                        output.writeTag(fieldDescriptor.getNumber(), 2);
                        output.writeUInt32NoTag(message.getSerializedSize());
                        message.writeTo(output);
                    }
                    continue block20;
                }
                case 14: {
                    if (bBMap == null || !bBMap.containsKey((Object)bFieldName)) continue block20;
                    Object bValue = bBMap.get((Object)bFieldName);
                    output.writeEnum(fieldDescriptor.getNumber(), fieldDescriptor.getEnumType().findValueByName(((BString)bValue).getValue()).getNumber());
                    break;
                }
                case 12: {
                    Object value;
                    BArray valueArray;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray && !GOOGLE_PROTOBUF_ANY_MESSAGE_NAME.equals(this.messageName)) {
                            valueArray = (BArray)bValue;
                            output.writeByteArray(fieldDescriptor.getNumber(), valueArray.getBytes());
                            break;
                        }
                        if (!GOOGLE_PROTOBUF_ANY_MESSAGE_NAME.equals(this.messageName)) continue block20;
                        String typeUrl = ((BMap)this.bMessage).getStringValue(StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY)).getValue();
                        String typeName = this.anyMessageTypeNameFromTypeUrl(typeUrl);
                        value = ((BMap)this.bMessage).get((Object)StringUtils.fromString((String)"value"));
                        Descriptors.Descriptor descriptor = this.findFieldDescriptorFromTypeUrl(typeName, value);
                        Message message = new Message(descriptor, value);
                        output.writeTag(fieldDescriptor.getNumber(), 2);
                        output.writeUInt32NoTag(message.getSerializedSize());
                        message.writeTo(output);
                        break;
                    }
                    if (!(this.bMessage instanceof BArray)) continue block20;
                    BArray valueArray3 = (BArray)this.bMessage;
                    output.writeByteArray(fieldDescriptor.getNumber(), valueArray3.getBytes());
                    break;
                }
                default: {
                    throw Status.Code.INTERNAL.toStatus().withDescription("Error while writing output stream. Field type is not supported : " + String.valueOf(fieldDescriptor.getType())).asRuntimeException();
                }
            }
        }
    }

    public int getSerializedSize() throws InvalidProtocolBufferException {
        if (this.descriptor != null && GOOGLE_PROTOBUF_ANY.equals(this.descriptor.getFullName())) {
            BMap anyTypedRecord = (BMap)this.bMessage;
            String typeUrl = anyTypedRecord.getStringValue(StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY)).getValue();
            byte[] anyTypedContentArray = ServicesBuilderUtils.hexStringToByteArray(anyTypedRecord.getStringValue(StringUtils.fromString((String)"value")).getValue());
            return CodedOutputStream.computeStringSize((int)2, (String)typeUrl) + CodedOutputStream.computeTagSize((int)2) + CodedOutputStream.computeUInt32SizeNoTag((int)anyTypedContentArray.length) + anyTypedContentArray.length;
        }
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.bMessage == null) {
            this.memoizedSize = size;
            return size;
        }
        Descriptors.Descriptor messageDescriptor = this.getDescriptor();
        if (messageDescriptor == null) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Error while processing the message, Couldn't find message descriptor for message name: " + this.messageName).asRuntimeException();
        }
        BMap bBMap = null;
        if (this.bMessage instanceof BMap) {
            bBMap = (BMap)this.bMessage;
        }
        block19: for (Descriptors.FieldDescriptor fieldDescriptor : messageDescriptor.getFields()) {
            BString bFieldName = StringUtils.fromString((String)fieldDescriptor.getName());
            switch (fieldDescriptor.getType().toProto().getNumber()) {
                case 1: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeDoubleSize((int)fieldDescriptor.getNumber(), (double)valueArray.getFloat((long)i));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeDoubleSize((int)fieldDescriptor.getNumber(), (double)((Double)bValue));
                        break;
                    }
                    if (this.bMessage instanceof Integer) {
                        size += CodedOutputStream.computeDoubleSize((int)fieldDescriptor.getNumber(), (double)((Integer)this.bMessage).intValue());
                        break;
                    }
                    if (this.bMessage instanceof Long) {
                        size += CodedOutputStream.computeDoubleSize((int)fieldDescriptor.getNumber(), (double)((Long)this.bMessage).longValue());
                        break;
                    }
                    if (!(this.bMessage instanceof Double)) continue block19;
                    size += CodedOutputStream.computeDoubleSize((int)fieldDescriptor.getNumber(), (double)((Double)this.bMessage));
                    break;
                }
                case 2: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeFloatSize((int)fieldDescriptor.getNumber(), (float)Float.parseFloat(String.valueOf(valueArray.getFloat((long)i))));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeFloatSize((int)fieldDescriptor.getNumber(), (float)Float.parseFloat(String.valueOf(bValue)));
                        break;
                    }
                    if (!(this.bMessage instanceof Double)) continue block19;
                    size += CodedOutputStream.computeFloatSize((int)fieldDescriptor.getNumber(), (float)Float.parseFloat(String.valueOf(this.bMessage)));
                    break;
                }
                case 3: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeInt64Size((int)fieldDescriptor.getNumber(), (long)valueArray.getInt((long)i));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeInt64Size((int)fieldDescriptor.getNumber(), (long)((Long)bValue));
                        break;
                    }
                    if (this.bMessage instanceof Long) {
                        size += CodedOutputStream.computeInt64Size((int)fieldDescriptor.getNumber(), (long)((Long)this.bMessage));
                        break;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_TIMESTAMP_SECONDS) && this.bMessage instanceof BArray) {
                        BArray array = (BArray)this.bMessage;
                        size += CodedOutputStream.computeInt64Size((int)fieldDescriptor.getNumber(), (long)array.getInt(0L));
                        break;
                    }
                    if (!(this.bMessage instanceof BDecimal) || !fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_DURATION_SECONDS)) continue block19;
                    size += CodedOutputStream.computeInt64Size((int)fieldDescriptor.getNumber(), (long)((BDecimal)this.bMessage).value().intValue());
                    break;
                }
                case 4: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeUInt64Size((int)fieldDescriptor.getNumber(), (long)valueArray.getInt((long)i));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeUInt64Size((int)fieldDescriptor.getNumber(), (long)((Long)bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeUInt64Size((int)fieldDescriptor.getNumber(), (long)((Long)this.bMessage));
                    break;
                }
                case 5: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeInt32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeInt32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(bValue));
                        break;
                    }
                    if (this.bMessage instanceof Long) {
                        size += CodedOutputStream.computeInt32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(this.bMessage));
                        break;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_TIMESTAMP_NANOS) && this.bMessage instanceof BArray) {
                        BArray array = (BArray)this.bMessage;
                        BigDecimal nanos = new BigDecimal(array.get(1L).toString()).multiply(ANALOG_GIGA, MathContext.DECIMAL128);
                        size += CodedOutputStream.computeInt32Size((int)fieldDescriptor.getNumber(), (int)nanos.intValue());
                        break;
                    }
                    if (!(this.bMessage instanceof BDecimal) || !fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_DURATION_NANOS)) continue block19;
                    int intVal = ((BDecimal)this.bMessage).value().intValue();
                    BigDecimal b = ((BDecimal)this.bMessage).value().subtract(new BigDecimal(intVal)).multiply(ANALOG_GIGA, MathContext.DECIMAL128);
                    size += CodedOutputStream.computeInt32Size((int)fieldDescriptor.getNumber(), (int)b.intValue());
                    break;
                }
                case 13: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeUInt32Size((int)fieldDescriptor.getNumber(), (int)Integer.parseUnsignedInt(String.valueOf(valueArray.getInt((long)i))));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeUInt32Size((int)fieldDescriptor.getNumber(), (int)Integer.parseUnsignedInt(String.valueOf(bValue)));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeUInt32Size((int)fieldDescriptor.getNumber(), (int)Integer.parseUnsignedInt(String.valueOf(this.bMessage)));
                    break;
                }
                case 6: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeFixed64Size((int)fieldDescriptor.getNumber(), (long)valueArray.getInt((long)i));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeFixed64Size((int)fieldDescriptor.getNumber(), (long)((Long)bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeFixed64Size((int)fieldDescriptor.getNumber(), (long)((Long)this.bMessage));
                    break;
                }
                case 7: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeFixed32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeFixed32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeFixed32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(this.bMessage));
                    break;
                }
                case 18: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeSInt64Size((int)fieldDescriptor.getNumber(), (long)valueArray.getInt((long)i));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeSInt64Size((int)fieldDescriptor.getNumber(), (long)((Long)bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeSInt64Size((int)fieldDescriptor.getNumber(), (long)((Long)this.bMessage));
                    break;
                }
                case 17: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeSInt32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeSInt32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeSInt32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(this.bMessage));
                    break;
                }
                case 16: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeSFixed64Size((int)fieldDescriptor.getNumber(), (long)valueArray.getInt((long)i));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeSFixed64Size((int)fieldDescriptor.getNumber(), (long)((Long)bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeSFixed64Size((int)fieldDescriptor.getNumber(), (long)((Long)this.bMessage));
                    break;
                }
                case 15: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeSFixed32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(valueArray.getInt((long)i)));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeSFixed32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Long)) continue block19;
                    size += CodedOutputStream.computeSFixed32Size((int)fieldDescriptor.getNumber(), (int)this.getIntValue(this.bMessage));
                    break;
                }
                case 8: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeBoolSize((int)fieldDescriptor.getNumber(), (boolean)valueArray.getBoolean((long)i));
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeBoolSize((int)fieldDescriptor.getNumber(), (boolean)((Boolean)bValue));
                        break;
                    }
                    if (!(this.bMessage instanceof Boolean)) continue block19;
                    size += CodedOutputStream.computeBoolSize((int)fieldDescriptor.getNumber(), (boolean)((Boolean)this.bMessage));
                    break;
                }
                case 9: {
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                size += CodedOutputStream.computeStringSize((int)fieldDescriptor.getNumber(), (String)valueArray.getBString((long)i).getValue());
                            }
                            continue block19;
                        }
                        size += CodedOutputStream.computeStringSize((int)fieldDescriptor.getNumber(), (String)((BString)bValue).getValue());
                        break;
                    }
                    if (this.bMessage instanceof BArray && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_KEY)) {
                        size += CodedOutputStream.computeStringSize((int)fieldDescriptor.getNumber(), (String)((BArray)this.bMessage).getBString(0L).getValue());
                        break;
                    }
                    if (this.bMessage instanceof BString) {
                        size += CodedOutputStream.computeStringSize((int)fieldDescriptor.getNumber(), (String)((BString)this.bMessage).getValue());
                        break;
                    }
                    if (!GOOGLE_PROTOBUF_ANY_MESSAGE_NAME.equals(this.messageName)) continue block19;
                    size += CodedOutputStream.computeStringSize((int)fieldDescriptor.getNumber(), (String)((BMap)this.bMessage).getStringValue(StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY)).getValue());
                    break;
                }
                case 11: {
                    Object value;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (fieldDescriptor.isRepeated() && bValue instanceof BArray) {
                            BArray valueArray = (BArray)bValue;
                            for (int i = 0; i < valueArray.size(); ++i) {
                                value = valueArray.getRefValue((long)i);
                                Message message = new Message(fieldDescriptor.getMessageType(), value);
                                size += this.computeMessageSize(fieldDescriptor, message);
                            }
                            continue block19;
                        }
                        Message message = new Message(fieldDescriptor.getMessageType(), bValue);
                        size += this.computeMessageSize(fieldDescriptor, message);
                        break;
                    }
                    if (bBMap != null && fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDS)) {
                        for (Map.Entry entry : bBMap.entrySet()) {
                            BArray valueArray = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANY), (int)2);
                            valueArray.add(0L, entry.getKey());
                            valueArray.add(1L, entry.getValue());
                            Message message = new Message(fieldDescriptor.getMessageType(), (Object)valueArray);
                            size += this.computeMessageSize(fieldDescriptor, message);
                        }
                        continue block19;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_STRUCT_FIELDSENTRY_VALUE)) {
                        Message message = new Message(fieldDescriptor.getMessageType(), ((BArray)this.bMessage).get(1L));
                        size += this.computeMessageSize(fieldDescriptor, message);
                        break;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_VALUE_LIST_VALUE) && this.bMessage instanceof BArray) {
                        Message message = new Message(fieldDescriptor.getMessageType(), this.bMessage);
                        size += this.computeMessageSize(fieldDescriptor, message);
                        break;
                    }
                    if (fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_VALUE_STRUCT_VALUE) && this.bMessage instanceof BMap) {
                        Message message = new Message(fieldDescriptor.getMessageType(), (Object)bBMap);
                        size += this.computeMessageSize(fieldDescriptor, message);
                        break;
                    }
                    if (!fieldDescriptor.getFullName().equals(GOOGLE_PROTOBUF_LISTVALUE_VALUES) || !(this.bMessage instanceof BArray)) continue block19;
                    BArray bArray = (BArray)this.bMessage;
                    for (int i = 0; i < bArray.size(); ++i) {
                        Message message = new Message(fieldDescriptor.getMessageType(), bArray.get((long)i));
                        size += this.computeMessageSize(fieldDescriptor, message);
                    }
                    continue block19;
                }
                case 14: {
                    if (bBMap == null || !bBMap.containsKey((Object)bFieldName)) continue block19;
                    Object bValue = bBMap.get((Object)bFieldName);
                    size += CodedOutputStream.computeEnumSize((int)fieldDescriptor.getNumber(), (int)fieldDescriptor.getEnumType().findValueByName(((BString)bValue).getValue()).getNumber());
                    break;
                }
                case 12: {
                    Object value;
                    if (bBMap != null && bBMap.containsKey((Object)bFieldName)) {
                        Object bValue = bBMap.get((Object)bFieldName);
                        if (bValue instanceof BArray && !GOOGLE_PROTOBUF_ANY_MESSAGE_NAME.equals(this.messageName)) {
                            BArray valueArray = (BArray)bValue;
                            size += CodedOutputStream.computeByteArraySize((int)fieldDescriptor.getNumber(), (byte[])valueArray.getBytes());
                            break;
                        }
                        if (!GOOGLE_PROTOBUF_ANY_MESSAGE_NAME.equals(this.messageName)) continue block19;
                        String typeUrl = ((BMap)this.bMessage).getStringValue(StringUtils.fromString((String)BALLERINA_TYPE_URL_ENTRY)).getValue();
                        String typeName = this.anyMessageTypeNameFromTypeUrl(typeUrl);
                        value = ((BMap)this.bMessage).get((Object)StringUtils.fromString((String)"value"));
                        Descriptors.Descriptor descriptor = this.findFieldDescriptorFromTypeUrl(typeName, value);
                        Message message = new Message(descriptor, value);
                        size += this.computeMessageSize(fieldDescriptor, message);
                        break;
                    }
                    if (!(this.bMessage instanceof BArray)) continue block19;
                    BArray valueArray = (BArray)this.bMessage;
                    size += CodedOutputStream.computeByteArraySize((int)fieldDescriptor.getNumber(), (byte[])valueArray.getBytes());
                    break;
                }
                default: {
                    throw Status.Code.INTERNAL.toStatus().withDescription("Error while calculating the serialized type. Field type is not supported : " + String.valueOf(fieldDescriptor.getType())).asRuntimeException();
                }
            }
        }
        this.memoizedSize = size;
        return size;
    }

    private int computeMessageSize(Descriptors.FieldDescriptor fieldDescriptor, Message message) throws InvalidProtocolBufferException {
        return CodedOutputStream.computeTagSize((int)fieldDescriptor.getNumber()) + CodedOutputStream.computeUInt32SizeNoTag((int)message.getSerializedSize()) + message.getSerializedSize();
    }

    private String anyMessageTypeNameFromTypeUrl(String typeUrl) {
        String[] types = typeUrl.split("/");
        return types[types.length - 1].trim();
    }

    private Descriptors.Descriptor findFieldDescriptorFromTypeUrl(String messageName, Object value) {
        BMap bMap;
        RecordType recordType;
        if (messageName.startsWith("google.protobuf")) {
            return this.findGoogleDescriptorFromName(messageName);
        }
        if (value instanceof BMap && (this.isDescriptorAnnotationAvailable(recordType = (RecordType)(bMap = (BMap)value).getType()) || this.isDescriptorAnnotationAvailable((RecordType)ValueCreator.createRecordValue((Module)recordType.getPackage(), (String)messageName).getType()))) {
            try {
                return this.getDescriptorFromRecord(recordType, messageName);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return MessageRegistry.getInstance().getFileDescriptor().findMessageTypeByName(messageName);
    }

    private Descriptors.Descriptor findGoogleDescriptorFromName(String typeName) {
        String messageName = typeName.replace("google.protobuf.", "");
        switch (typeName) {
            case "google.protobuf.DoubleValue": 
            case "google.protobuf.FloatValue": 
            case "google.protobuf.Int64Value": 
            case "google.protobuf.UInt64Value": 
            case "google.protobuf.Int32Value": 
            case "google.protobuf.UInt32Value": 
            case "google.protobuf.BoolValue": 
            case "google.protobuf.StringValue": 
            case "google.protobuf.BytesValue": {
                return WrappersProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Any": {
                return AnyProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Empty": {
                return EmptyProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Timestamp": {
                return TimestampProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Duration": {
                return DurationProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Struct": {
                return StructProto.getDescriptor().findMessageTypeByName(messageName);
            }
        }
        return null;
    }

    public void skipUnnecessaryAnyTypeTags(CodedInputStream input) throws IOException {
        try {
            input.readTag();
            input.readTag();
        }
        catch (InvalidProtocolBufferException e) {
            input.getLastTag();
        }
    }

    public byte[] toByteArray() {
        try {
            byte[] result = new byte[this.getSerializedSize()];
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])result);
            this.writeTo(output);
            output.checkNoSpaceLeft();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing " + this.messageName + " to a byte array threw an IOException (should never happen).", e);
        }
    }

    private Message readMessage(Descriptors.FieldDescriptor fieldDescriptor, Type type, CodedInputStream in) throws IOException {
        int length = in.readRawVarint32();
        int oldLimit = in.pushLimit(length);
        Message result = new MessageParser(fieldDescriptor.getMessageType(), type).parseFrom(in);
        in.popLimit(oldLimit);
        return result;
    }

    private int getIntValue(Object value) {
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return (Integer)value;
    }

    public String toString() {
        StringBuilder payload = new StringBuilder("Message : ");
        if (this.bMessage != null) {
            payload.append("{ ").append(StringUtils.getJsonString((Object)this.bMessage)).append(" }");
        } else {
            payload.append("null");
        }
        return payload.toString();
    }

    private static String bytesToHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = "0123456789ABCDEF".toCharArray()[v >>> 4];
            hexChars[j * 2 + 1] = "0123456789ABCDEF".toCharArray()[v & 0xF];
        }
        return new String(hexChars);
    }
}

