/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.grpc.Codec;
import io.ballerina.stdlib.grpc.CompositeContent;
import io.ballerina.stdlib.grpc.Decompressor;
import io.ballerina.stdlib.grpc.KnownLength;
import io.ballerina.stdlib.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpContent;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class MessageDeframer
implements Closeable {
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 254;
    private Listener listener;
    private long maxInboundMessageSize;
    private Decompressor decompressor;
    private State state = State.HEADER;
    private int requiredLength = 5;
    private boolean compressedFlag;
    private CompositeContent nextFrame;
    private CompositeContent unprocessed = new CompositeContent();
    private volatile boolean inDelivery = false;
    private boolean closeWhenComplete = false;

    MessageDeframer(Listener listener, Decompressor decompressor, long maxMessageSize) {
        this.listener = listener;
        this.decompressor = decompressor;
        this.maxInboundMessageSize = maxMessageSize;
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setDecompressor(Decompressor decompressor) {
        this.decompressor = decompressor;
    }

    public void deframe(HttpContent data) {
        if (data == null) {
            throw new RuntimeException("Data buffer is null");
        }
        boolean needToCloseData = true;
        try {
            if (!this.isClosedOrScheduledToClose()) {
                this.unprocessed.addBuffer(data.content());
                needToCloseData = false;
                this.deliver();
            }
        }
        finally {
            if (needToCloseData && data.refCnt() != 0) {
                data.release();
            }
        }
    }

    public void closeWhenComplete() {
        if (this.isStalled()) {
            this.close();
        } else if (!this.isClosed()) {
            this.closeWhenComplete = true;
        }
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        boolean hasPartialMessage = this.nextFrame != null && this.nextFrame.readableBytes() > 0;
        try {
            if (this.unprocessed != null) {
                this.unprocessed.close();
            }
            if (this.nextFrame != null) {
                this.nextFrame.close();
            }
        }
        finally {
            this.unprocessed = null;
            this.nextFrame = null;
        }
        this.listener.deframerClosed(hasPartialMessage);
    }

    public boolean isClosed() {
        return this.unprocessed == null;
    }

    private boolean isClosedOrScheduledToClose() {
        return this.isClosed() || this.closeWhenComplete;
    }

    private boolean isStalled() {
        return this.unprocessed == null || this.unprocessed.readableBytes() == 0;
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        this.inDelivery = true;
        try {
            block7: while (this.readRequiredBytes()) {
                switch (this.state.ordinal()) {
                    case 0: {
                        this.processHeader();
                        continue block7;
                    }
                    case 1: {
                        this.processBody();
                        continue block7;
                    }
                }
                throw new IllegalStateException("Invalid state: " + String.valueOf((Object)this.state));
            }
            if (this.closeWhenComplete && this.isStalled()) {
                this.close();
            }
        }
        finally {
            this.inDelivery = false;
        }
    }

    private boolean readRequiredBytes() {
        int missingBytes;
        if (this.nextFrame == null) {
            this.nextFrame = new CompositeContent();
        }
        while ((missingBytes = this.requiredLength - this.nextFrame.readableBytes()) > 0) {
            ByteBuf buffer;
            if (this.unprocessed.readableBytes() == 0) {
                return false;
            }
            for (int toRead = Math.min(missingBytes, this.unprocessed.readableBytes()); toRead > 0; toRead -= buffer.readableBytes()) {
                buffer = this.unprocessed.readBuffer(toRead);
                this.nextFrame.addBuffer(buffer);
            }
        }
        return true;
    }

    private void processHeader() {
        int type = this.nextFrame.readUnsignedByte();
        if ((type & 0xFE) != 0) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Frame header malformed: reserved bits not zero").asRuntimeException();
        }
        this.compressedFlag = (type & 1) != 0;
        this.requiredLength = this.nextFrame.readInt();
        if (this.requiredLength < 0 || (long)this.requiredLength > this.maxInboundMessageSize) {
            throw Status.Code.RESOURCE_EXHAUSTED.toStatus().withDescription(String.format("Frame size %d exceeds maximum: %d.", this.requiredLength, this.maxInboundMessageSize)).asRuntimeException();
        }
        this.state = State.BODY;
    }

    private void processBody() {
        InputStream stream = this.compressedFlag ? this.getCompressedBody() : this.getUncompressedBody();
        this.listener.messagesAvailable(stream);
        this.state = State.HEADER;
        this.requiredLength = 5;
        this.nextFrame.close();
        this.nextFrame = null;
    }

    private InputStream getUncompressedBody() {
        return new BufferInputStream(this.nextFrame);
    }

    private InputStream getCompressedBody() {
        if (this.decompressor == Codec.Identity.NONE) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Can't decode compressed frame as compression not configured.").asRuntimeException();
        }
        try {
            return this.decompressor.decompress(new BufferInputStream(this.nextFrame));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum State {
        HEADER,
        BODY;

    }

    public static interface Listener {
        public void messagesAvailable(InputStream var1);

        public void deframerClosed(boolean var1);

        public void deframeFailed(Throwable var1);
    }

    private static final class BufferInputStream
    extends InputStream
    implements KnownLength {
        final CompositeContent buffer;

        BufferInputStream(CompositeContent buffer) {
            this.buffer = buffer;
        }

        @Override
        public int available() {
            return this.buffer.readableBytes();
        }

        @Override
        public int read() {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            return this.buffer.readUnsignedByte();
        }

        @Override
        public int read(byte[] dest, int destOffset, int length) throws IOException {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            length = Math.min(this.buffer.readableBytes(), length);
            this.buffer.readBytes(dest, destOffset, length);
            return length;
        }
    }
}

