/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.GrpcUtil;
import io.ballerina.stdlib.grpc.MessageRegistry;
import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.ServicesBuilderUtils;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.StreamObserver;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class MessageUtils {
    private static final String UNKNOWN_ERROR_DETAIL = "Unknown error occurred";
    private static final int MAX_BUFFER_LENGTH = 16384;
    private static final String GOOGLE_PROTOBUF_EMPTY = "google.protobuf.Empty";
    private static final int INVALID_WIRE_TYPE = -1;
    private static final int MESSAGE_WIRE_TYPE = 2;
    private static final Type HEADER_MAP_TYPE = TypeCreator.createMapType((Type)TypeCreator.createUnionType(Arrays.asList(PredefinedTypes.TYPE_STRING, TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING))));

    static boolean headersRequired(MethodType functionType, Type rpcInputType) {
        if (functionType == null || functionType.getParameters() == null) {
            throw new RuntimeException("Invalid resource input arguments");
        }
        boolean headersRequired = false;
        for (Type paramType : ServicesBuilderUtils.getParameterTypesFromParameters(functionType.getParameters())) {
            if (paramType != null && MessageUtils.getContextTypeName(rpcInputType).equals(paramType.getName())) {
                headersRequired = true;
                break;
            }
            if (paramType == null || !MessageUtils.getContextStreamTypeName(rpcInputType).equals(paramType.getName())) continue;
            headersRequired = true;
            break;
        }
        return headersRequired;
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[16384];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static StreamObserver getResponseObserver(BObject refType) {
        if (refType instanceof StreamObserver) {
            return (StreamObserver)refType;
        }
        Object observerObject = refType.getNativeData("RESPONSE_OBSERVER");
        if (observerObject instanceof StreamObserver) {
            return (StreamObserver)observerObject;
        }
        return null;
    }

    public static BError getConnectorError(Throwable error) {
        String message;
        String errorIdName;
        if (error instanceof StatusRuntimeException) {
            String causeMessage;
            StatusRuntimeException statusException = (StatusRuntimeException)error;
            errorIdName = statusException.getStatus().getReason();
            String errorDescription = statusException.getStatus().getDescription();
            message = errorDescription != null ? statusException.getStatus().getDescription() : (statusException.getStatus().getCause() != null ? ((causeMessage = statusException.getStatus().getCause().getMessage()) == null ? UNKNOWN_ERROR_DETAIL : causeMessage) : UNKNOWN_ERROR_DETAIL);
        } else if (error.getMessage() == null) {
            errorIdName = "UnKnownError";
            message = UNKNOWN_ERROR_DETAIL;
        } else {
            errorIdName = "InternalError";
            message = error.getMessage();
        }
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorIdName, (BString)StringUtils.fromString((String)message), null, null);
    }

    static int getFieldWireType(Descriptors.FieldDescriptor.Type fieldType) {
        if (fieldType == null) {
            return -1;
        }
        Integer wireType = GrpcConstants.WIRE_TYPE_MAP.get(fieldType.toProto());
        return Objects.requireNonNullElse(wireType, 2);
    }

    static void setNestedMessages(Descriptors.Descriptor resMessage, MessageRegistry messageRegistry) {
        for (Descriptors.Descriptor nestedType : resMessage.getNestedTypes()) {
            messageRegistry.addMessageDescriptor(nestedType.getFullName(), nestedType);
        }
        for (Descriptors.FieldDescriptor msgField : resMessage.getFields()) {
            if (!Descriptors.FieldDescriptor.Type.MESSAGE.equals((Object)msgField.getType())) continue;
            Descriptors.Descriptor msgType = msgField.getMessageType();
            messageRegistry.addMessageDescriptor(msgType.getFullName(), msgType);
        }
    }

    public static MethodDescriptor.MethodType getMethodType(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
        if (methodDescriptorProto.getClientStreaming() && methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.BIDI_STREAMING;
        }
        if (!methodDescriptorProto.getClientStreaming() && !methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        return MethodDescriptor.MethodType.CLIENT_STREAMING;
    }

    public static boolean isEmptyResponse(Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            return false;
        }
        return GOOGLE_PROTOBUF_EMPTY.equals(messageDescriptor.getFullName());
    }

    static void closeQuietly(InputStream message) {
        try {
            message.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static boolean isGrpcContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        if ("application/grpc".length() > contentType.length()) {
            return false;
        }
        if (!(contentType = contentType.toLowerCase(Locale.ENGLISH)).startsWith("application/grpc")) {
            return false;
        }
        if (contentType.length() == "application/grpc".length()) {
            return true;
        }
        char nextChar = contentType.charAt("application/grpc".length());
        return nextChar == '+' || nextChar == ';';
    }

    public static HttpCarbonMessage createHttpCarbonMessage(boolean isRequest) {
        HttpCarbonMessage httpCarbonMessage = isRequest ? new HttpCarbonMessage((HttpMessage)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "")) : new HttpCarbonMessage((HttpMessage)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
        return httpCarbonMessage;
    }

    static Status httpStatusToGrpcStatus(int httpStatusCode) {
        return MessageUtils.httpStatusToGrpcCode(httpStatusCode).toStatus().withDescription("HTTP status code " + httpStatusCode);
    }

    static Status.Code httpStatusToGrpcCode(int httpStatusCode) {
        if (httpStatusCode >= 100 && httpStatusCode < 200) {
            return Status.Code.INTERNAL;
        }
        switch (httpStatusCode) {
            case 400: 
            case 431: {
                return Status.Code.INTERNAL;
            }
            case 401: {
                return Status.Code.UNAUTHENTICATED;
            }
            case 403: {
                return Status.Code.PERMISSION_DENIED;
            }
            case 404: {
                return Status.Code.UNIMPLEMENTED;
            }
            case 429: 
            case 502: 
            case 503: 
            case 504: {
                return Status.Code.UNAVAILABLE;
            }
        }
        return Status.Code.UNKNOWN;
    }

    static int statusCodeToHttpCode(Status.Code code) {
        switch (code) {
            case CANCELLED: {
                return 499;
            }
            case INVALID_ARGUMENT: 
            case FAILED_PRECONDITION: 
            case OUT_OF_RANGE: {
                return 400;
            }
            case DEADLINE_EXCEEDED: {
                return 504;
            }
            case NOT_FOUND: {
                return 404;
            }
            case ALREADY_EXISTS: 
            case ABORTED: {
                return 409;
            }
            case PERMISSION_DENIED: {
                return 403;
            }
            case UNAUTHENTICATED: {
                return 401;
            }
            case UNIMPLEMENTED: {
                return 501;
            }
            case UNAVAILABLE: {
                return 503;
            }
        }
        return 500;
    }

    public static int getMappingHttpStatusCode(int code) {
        switch (code) {
            case 0: {
                return HttpResponseStatus.OK.code();
            }
            case 1: {
                return 499;
            }
            case 3: 
            case 9: 
            case 11: {
                return HttpResponseStatus.BAD_REQUEST.code();
            }
            case 4: {
                return HttpResponseStatus.GATEWAY_TIMEOUT.code();
            }
            case 5: {
                return HttpResponseStatus.NOT_FOUND.code();
            }
            case 6: 
            case 10: {
                return HttpResponseStatus.CONFLICT.code();
            }
            case 7: {
                return HttpResponseStatus.FORBIDDEN.code();
            }
            case 8: {
                return HttpResponseStatus.TOO_MANY_REQUESTS.code();
            }
            case 12: {
                return HttpResponseStatus.NOT_IMPLEMENTED.code();
            }
            case 14: {
                return HttpResponseStatus.SERVICE_UNAVAILABLE.code();
            }
            case 15: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
            }
            case 16: {
                return HttpResponseStatus.UNAUTHORIZED.code();
            }
        }
        return HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
    }

    private static byte[] readArray(HttpContent httpContent) {
        if (httpContent == null || httpContent.content() == null) {
            throw new RuntimeException("Http content is null");
        }
        int length = httpContent.content().readableBytes();
        byte[] bytes = new byte[length];
        httpContent.content().readBytes(bytes, 0, length);
        return bytes;
    }

    static String readAsString(HttpContent httpContent, Charset charset) {
        if (charset == null) {
            throw new RuntimeException("Charset cannot be null");
        }
        byte[] bytes = MessageUtils.readArray(httpContent);
        return new String(bytes, charset);
    }

    static Status statusFromTrailers(HttpHeaders trailers) {
        String statusString = trailers.get("grpc-status");
        Status status = null;
        if (statusString != null) {
            status = Status.CODE_MARSHALLER.parseAsciiString(statusString.getBytes(Charset.forName("US-ASCII")));
        }
        if (status != null) {
            return status.withDescription(trailers.get("grpc-message"));
        }
        return Status.Code.UNKNOWN.toStatus().withDescription("missing GRPC status in response");
    }

    public static String getCallerTypeName(String serviceName, String returnType) {
        if (returnType != null) {
            if (returnType.equals("time:Utc")) {
                returnType = "Timestamp";
            }
            if (returnType.equals("time:Seconds")) {
                returnType = "Duration";
            }
            if (returnType.equals("map<anydata>")) {
                returnType = "Struct";
            }
            if (returnType.equals("'any:Any")) {
                returnType = "Any";
            }
            returnType = returnType.replaceAll("[^a-zA-Z0-9]", "");
            return serviceName.substring(0, 1).toUpperCase() + serviceName.substring(1) + returnType.substring(0, 1).toUpperCase() + returnType.substring(1) + "Caller";
        }
        return serviceName.substring(0, 1).toUpperCase() + serviceName.substring(1) + "NilCaller";
    }

    public static String getContextTypeName(Type inputType) {
        String sInputType;
        inputType = inputType instanceof ArrayType ? TypeUtils.getReferredType((Type)((ArrayType)inputType).getElementType()) : inputType;
        String string = sInputType = inputType != PredefinedTypes.TYPE_NULL ? GrpcUtil.getTypeName(inputType) : null;
        if (sInputType != null) {
            sInputType = sInputType.replaceAll("[^a-zA-Z0-9]", "");
            return "Context" + sInputType.substring(0, 1).toUpperCase() + sInputType.substring(1);
        }
        return "ContextNil";
    }

    public static String getContextStreamTypeName(Type inputType) {
        String sInputType;
        inputType = inputType instanceof ArrayType ? TypeUtils.getReferredType((Type)((ArrayType)inputType).getElementType()) : inputType;
        String string = sInputType = inputType != PredefinedTypes.TYPE_NULL ? GrpcUtil.getTypeName(inputType) : null;
        if (sInputType != null) {
            sInputType = sInputType.replaceAll("[^a-zA-Z0-9]", "");
            return "Context" + sInputType.substring(0, 1).toUpperCase() + sInputType.substring(1) + "Stream";
        }
        return "ContextNil";
    }

    public static boolean isContextRecordByValue(Object value) {
        return value instanceof BMap && ((BMap)value).getType().getName().startsWith("Context") && ((BMap)value).size() == 2;
    }

    public static boolean isRecordMapValue(Object value) {
        return value instanceof BMap && ((BMap)value).getType().getTag() == 24;
    }

    public static boolean isContextRecordByType(Type type) {
        return type instanceof RecordType && type.getName().startsWith("Context") && ((RecordType)type).getFields().size() == 2 && ((RecordType)type).getFields().containsKey("content") && ((RecordType)type).getFields().containsKey("headers");
    }

    public static BMap createHeaderMap(HttpHeaders httpHeaders) {
        BMap headerMap = ValueCreator.createMapValue((Type)HEADER_MAP_TYPE);
        for (String key : httpHeaders.names()) {
            String[] values = (String[])Arrays.stream(httpHeaders.getAll(key).toArray(new String[0])).distinct().toArray(String[]::new);
            if (values.length == 1) {
                headerMap.put((Object)StringUtils.fromString((String)key.toLowerCase(Locale.getDefault())), (Object)StringUtils.fromString((String)values[0]));
                continue;
            }
            headerMap.put((Object)StringUtils.fromString((String)key.toLowerCase(Locale.getDefault())), (Object)StringUtils.fromStringArray((String[])values));
        }
        return headerMap;
    }

    public static HttpHeaders convertToHttpHeaders(BMap headerValues) {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        if (headerValues != null) {
            for (Object key : headerValues.getKeys()) {
                Object headerValue = headerValues.get(key);
                if (headerValue instanceof BString) {
                    headers.set(key.toString(), (Object)headerValue.toString());
                    continue;
                }
                if (!(headerValue instanceof BArray)) continue;
                for (String value : ((BArray)headerValue).getStringArray()) {
                    headers.add(key.toString(), (Object)value);
                }
            }
        }
        return headers;
    }

    private MessageUtils() {
    }
}

