/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.Descriptors;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.exception.GrpcServerException;
import java.io.InputStream;

public final class MethodDescriptor {
    private final MethodType type;
    private final String fullMethodName;
    private final Marshaller requestMarshaller;
    private final Marshaller responseMarshaller;
    private final Descriptors.MethodDescriptor schemaDescriptor;

    private MethodDescriptor(MethodType type, String fullMethodName, Marshaller requestMarshaller, Marshaller responseMarshaller, Descriptors.MethodDescriptor schemaDescriptor) {
        this.type = type;
        this.fullMethodName = fullMethodName;
        this.requestMarshaller = requestMarshaller;
        this.responseMarshaller = responseMarshaller;
        this.schemaDescriptor = schemaDescriptor;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public Message parseResponse(InputStream input, long maxInboundMessageSize) {
        return this.responseMarshaller.parse(input, maxInboundMessageSize);
    }

    public InputStream streamRequest(Message requestMessage) {
        return this.requestMarshaller.stream(requestMessage);
    }

    public Message parseRequest(InputStream input, long maxInboundMessageSize) {
        return this.requestMarshaller.parse(input, maxInboundMessageSize);
    }

    public InputStream streamResponse(Message response) {
        return this.responseMarshaller.stream(response);
    }

    public Descriptors.MethodDescriptor getSchemaDescriptor() {
        return this.schemaDescriptor;
    }

    static String generateFullMethodName(String fullServiceName, String methodName) {
        if (fullServiceName == null) {
            throw new RuntimeException("Full service name cannot be null");
        }
        return fullServiceName + "/" + methodName;
    }

    public static String extractFullServiceName(String fullMethodName) throws GrpcServerException {
        if (fullMethodName == null) {
            throw new GrpcServerException("Full method name cannot be null");
        }
        int index = fullMethodName.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return fullMethodName.substring(0, index);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum MethodType {
        UNARY,
        CLIENT_STREAMING,
        SERVER_STREAMING,
        BIDI_STREAMING,
        UNKNOWN;


        public final boolean clientSendsOneMessage() {
            return this == UNARY || this == SERVER_STREAMING;
        }

        public final boolean serverSendsOneMessage() {
            return this == UNARY || this == CLIENT_STREAMING;
        }
    }

    public static interface Marshaller {
        public InputStream stream(Message var1);

        public Message parse(InputStream var1, long var2);
    }

    public static final class Builder {
        private Marshaller requestMarshaller;
        private Marshaller responseMarshaller;
        private MethodType type;
        private String fullMethodName;
        private Descriptors.MethodDescriptor schemaDescriptor;

        private Builder() {
        }

        public Builder setRequestMarshaller(Marshaller requestMarshaller) {
            this.requestMarshaller = requestMarshaller;
            return this;
        }

        public Builder setResponseMarshaller(Marshaller responseMarshaller) {
            this.responseMarshaller = responseMarshaller;
            return this;
        }

        public Builder setType(MethodType type) {
            this.type = type;
            return this;
        }

        public Builder setFullMethodName(String fullMethodName) {
            this.fullMethodName = fullMethodName;
            return this;
        }

        public Builder setSchemaDescriptor(Descriptors.MethodDescriptor schemaDescriptor) {
            this.schemaDescriptor = schemaDescriptor;
            return this;
        }

        public MethodDescriptor build() {
            return new MethodDescriptor(this.type, this.fullMethodName, this.requestMarshaller, this.responseMarshaller, this.schemaDescriptor);
        }
    }
}

