/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.ClientCall;
import io.ballerina.stdlib.grpc.ClientConnectorListener;
import io.ballerina.stdlib.grpc.DataContext;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.transport.contract.exceptions.ClientConnectorException;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;

public class ObservableClientConnectorListener
extends ClientConnectorListener {
    private final DataContext context;

    public ObservableClientConnectorListener(ClientCall.ClientStreamListener streamListener, DataContext context, Long maxInboundMsgSize) {
        super(streamListener, maxInboundMsgSize);
        this.context = context;
    }

    @Override
    public void onMessage(HttpCarbonMessage httpCarbonMessage) {
        Integer statusCode = (Integer)httpCarbonMessage.getProperty(HttpConstants.RESPONSE_STATUS_CODE_FIELD.getValue());
        this.addHttpStatusCode(statusCode == null ? 0 : statusCode);
        super.onMessage(httpCarbonMessage);
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof ClientConnectorException) {
            ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
            this.addHttpStatusCode(clientConnectorException.getHttpStatusCode());
            ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)this.context.getEnvironment());
            if (observerContext != null) {
                observerContext.addTag("error", "true");
            }
        }
        super.onError(throwable);
    }

    private void addHttpStatusCode(int statusCode) {
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)this.context.getEnvironment());
        if (observerContext != null) {
            observerContext.addProperty("_http_status_code_", (Object)statusCode);
        }
    }
}

