/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.Codec;
import io.ballerina.stdlib.grpc.Compressor;
import io.ballerina.stdlib.grpc.CompressorRegistry;
import io.ballerina.stdlib.grpc.DecompressorRegistry;
import io.ballerina.stdlib.grpc.InboundMessage;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.OutboundMessage;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.StreamListener;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.grpc.listener.ServerCallHandler;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.Map;

public final class ServerCall {
    private static final String MESSAGE_ACCEPT_ENCODING = "grpc-accept-encoding";
    private static final String TOO_MANY_RESPONSES = "Too many responses";
    private static final String MISSING_RESPONSE = "Completed without a response";
    private final InboundMessage inboundMessage;
    private final OutboundMessage outboundMessage;
    private final MethodDescriptor method;
    private volatile boolean cancelled;
    private boolean sendHeadersCalled;
    private boolean closeCalled;
    private boolean messageSent;
    private Compressor compressor;
    private final String messageAcceptEncoding;
    private ObserverContext context = null;
    private Map<String, Long> messageSizeMap;
    private DecompressorRegistry decompressorRegistry;
    private CompressorRegistry compressorRegistry;

    ServerCall(InboundMessage inboundMessage, OutboundMessage outboundMessage, MethodDescriptor method, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, Map<String, Long> messageSizeMap) {
        this.inboundMessage = inboundMessage;
        this.outboundMessage = outboundMessage;
        this.method = method;
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        this.messageAcceptEncoding = inboundMessage.getHeader(MESSAGE_ACCEPT_ENCODING);
        this.messageSizeMap = messageSizeMap;
    }

    public void sendHeaders(HttpHeaders headers) {
        if (this.sendHeadersCalled) {
            throw new IllegalStateException("sendHeaders has already been called");
        }
        if (this.closeCalled) {
            throw new IllegalStateException("call is closed");
        }
        this.outboundMessage.removeHeader("grpc-encoding");
        if (headers != null && headers.contains("grpc-encoding")) {
            this.compressor = this.compressorRegistry.lookupCompressor(headers.get("grpc-encoding"));
            if (this.compressor == null) {
                this.compressor = Codec.Identity.NONE;
            }
        } else {
            this.compressor = Codec.Identity.NONE;
        }
        this.outboundMessage.setHeader("grpc-encoding", this.compressor.getMessageEncoding());
        this.outboundMessage.framer().setCompressor(this.compressor);
        this.outboundMessage.removeHeader(MESSAGE_ACCEPT_ENCODING);
        String advertisedEncodings = String.join((CharSequence)",", this.decompressorRegistry.getAdvertisedMessageEncodings());
        this.outboundMessage.setHeader(MESSAGE_ACCEPT_ENCODING, advertisedEncodings);
        if (headers != null) {
            this.outboundMessage.addHeaders(headers);
        }
        try {
            this.inboundMessage.respond(this.outboundMessage.getResponseMessage());
        }
        catch (ServerConnectorException e) {
            throw Status.Code.CANCELLED.toStatus().withCause(e).withDescription("Failed to send response headers. " + e.getMessage()).asRuntimeException();
        }
        this.sendHeadersCalled = true;
    }

    public void sendMessage(Message message) {
        if (!this.sendHeadersCalled) {
            throw Status.Code.CANCELLED.toStatus().withDescription("Response headers has not been sent properly.").asRuntimeException();
        }
        if (this.closeCalled) {
            throw Status.Code.CANCELLED.toStatus().withDescription("Call already closed.").asRuntimeException();
        }
        if (this.method.getType().serverSendsOneMessage() && this.messageSent) {
            this.outboundMessage.complete(Status.Code.INTERNAL.toStatus().withDescription(TOO_MANY_RESPONSES), (HttpHeaders)new DefaultHttpHeaders());
            return;
        }
        try {
            InputStream resp = this.method.streamResponse(message);
            this.outboundMessage.sendMessage(resp);
            this.messageSent = true;
        }
        catch (StatusRuntimeException ex) {
            this.close(ex.getStatus(), (HttpHeaders)new DefaultHttpHeaders());
        }
        catch (Exception e) {
            this.close(Status.fromThrowable(e), (HttpHeaders)new DefaultHttpHeaders());
        }
    }

    void setObserverContext(ObserverContext context) {
        this.context = context;
    }

    public ObserverContext getObserverContext() {
        return this.context;
    }

    public void setMessageCompression(boolean enable) {
        this.outboundMessage.setMessageCompression(enable);
    }

    public boolean isReady() {
        return this.outboundMessage.isReady();
    }

    public void close(Status status, HttpHeaders trailers) {
        if (this.closeCalled) {
            throw Status.Code.CANCELLED.toStatus().withDescription("Call already closed.").asRuntimeException();
        }
        this.closeCalled = true;
        if (status.isOk() && this.method.getType().serverSendsOneMessage() && !this.messageSent) {
            this.outboundMessage.complete(Status.Code.INTERNAL.toStatus().withDescription(MISSING_RESPONSE), (HttpHeaders)new DefaultHttpHeaders());
            return;
        }
        this.outboundMessage.complete(status, trailers);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    ServerStreamListener newServerStreamListener(ServerCallHandler.Listener listener) {
        return new ServerStreamListener(this, listener, this.messageSizeMap);
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.method;
    }

    public HttpHeaders getHeaders() {
        return this.inboundMessage.getHeaders();
    }

    public static final class ServerStreamListener
    implements StreamListener {
        private final ServerCall call;
        private final ServerCallHandler.Listener listener;
        private Map<String, Long> messageSizeMap;

        ServerStreamListener(ServerCall call, ServerCallHandler.Listener listener, Map<String, Long> messageSizeMap) {
            this.call = call;
            this.listener = listener;
            this.messageSizeMap = messageSizeMap;
        }

        @Override
        public void messagesAvailable(InputStream message) {
            if (this.call.cancelled) {
                MessageUtils.closeQuietly(message);
                return;
            }
            try {
                Message request = this.call.method.parseRequest(message, this.messageSizeMap.get("maxInboundMessageSize"));
                request.setHeaders(this.call.inboundMessage.getHeaders());
                this.listener.onMessage(request);
            }
            catch (StatusRuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to dispatch inbound message. " + ex.getMessage()).asRuntimeException();
            }
            finally {
                MessageUtils.closeQuietly(message);
            }
        }

        public void halfClosed() {
            if (this.call.cancelled) {
                return;
            }
            this.listener.onHalfClose();
        }

        public void closed(Status status) {
            if (status.isOk()) {
                this.listener.onComplete();
            } else {
                this.call.cancelled = true;
                this.listener.onCancel(new Message(status.asRuntimeException()));
            }
        }
    }
}

