/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.http.transport.contract.PortBindingEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectorPortBindingListener
implements PortBindingEventListener {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectorPortBindingListener.class);

    public void onOpen(String serverConnectorId, boolean isHttps) {
        if (log.isDebugEnabled()) {
            String message = isHttps ? "[ballerina/grpc] started HTTPS/WSS listener " : "[ballerina/grpc] started HTTP/WS listener ";
            log.debug(message + serverConnectorId);
        }
    }

    public void onClose(String serverConnectorId, boolean isHttps) {
        if (log.isDebugEnabled()) {
            String message = isHttps ? "[ballerina/grpc] stopped HTTPS/WSS listener " : "[ballerina/grpc] stopped HTTP/WS listener ";
            log.debug(message + serverConnectorId);
        }
    }

    public void onError(Throwable throwable) {
        log.error("Error in http endpoint", throwable);
    }
}

