/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.NullType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.MessageParser;
import io.ballerina.stdlib.grpc.MessageRegistry;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.ProtoUtils;
import io.ballerina.stdlib.grpc.ServerServiceDefinition;
import io.ballerina.stdlib.grpc.ServiceResource;
import io.ballerina.stdlib.grpc.StandardDescriptorBuilder;
import io.ballerina.stdlib.grpc.exception.GrpcServerException;
import io.ballerina.stdlib.grpc.listener.ServerCallHandler;
import io.ballerina.stdlib.grpc.listener.StreamingServerCallHandler;
import io.ballerina.stdlib.grpc.listener.UnaryServerCallHandler;
import io.ballerina.stdlib.protobuf.nativeimpl.ProtoTypesUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;

public class ServicesBuilderUtils {
    public static HashMap<String, Descriptors.FileDescriptor> fileDescriptorHashMapBySymbol = new HashMap();
    public static HashMap<String, Descriptors.FileDescriptor> fileDescriptorHashMapByFilename = new HashMap();

    public static ServerServiceDefinition getServiceDefinition(Runtime runtime, BObject service, Object servicePath, Object annotationData) throws GrpcServerException {
        Descriptors.FileDescriptor fileDescriptor = ServicesBuilderUtils.getDescriptor(annotationData);
        MessageRegistry.getInstance().setFileDescriptor(fileDescriptor);
        if (fileDescriptor == null) {
            fileDescriptor = ServicesBuilderUtils.getDescriptorFromService(service);
        }
        if (fileDescriptor == null) {
            throw new GrpcServerException("Couldn't find the service descriptor.");
        }
        String serviceName = ServicesBuilderUtils.getServiceName(servicePath);
        Descriptors.ServiceDescriptor serviceDescriptor = fileDescriptor.findServiceByName(serviceName);
        if (serviceDescriptor == null) {
            throw new GrpcServerException("Couldn't find the service descriptor for the service: " + serviceName);
        }
        return ServicesBuilderUtils.getServiceDefinition(runtime, service, serviceDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getServiceName(Object servicePath) throws GrpcServerException {
        if (servicePath == null) {
            throw new GrpcServerException("Invalid service path. Service path cannot be nil");
        }
        if (servicePath instanceof BArray) {
            BArray servicePathArray = (BArray)servicePath;
            if (servicePathArray.getLength() != 1L) throw new GrpcServerException("Invalid service path. Service path should not be hierarchical path");
            return ((BString)servicePathArray.get(0L)).getValue();
        }
        if (!(servicePath instanceof BString)) throw new GrpcServerException("Invalid service path. Couldn't derive the service path");
        return ((BString)servicePath).getValue();
    }

    private static ServerServiceDefinition getServiceDefinition(Runtime runtime, BObject service, Descriptors.ServiceDescriptor serviceDescriptor) throws GrpcServerException {
        String serviceName = serviceDescriptor.getFullName();
        fileDescriptorHashMapBySymbol.put(serviceName, serviceDescriptor.getFile());
        ServerServiceDefinition.Builder serviceDefBuilder = ServerServiceDefinition.builder(serviceName);
        for (Descriptors.MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
            Object annotation;
            ServerCallHandler serverCallHandler;
            MethodDescriptor.MethodType methodType;
            fileDescriptorHashMapBySymbol.put(methodDescriptor.getFullName(), serviceDescriptor.getFile());
            String methodName = serviceName + "/" + methodDescriptor.getName();
            Descriptors.Descriptor requestDescriptor = methodDescriptor.getInputType();
            Descriptors.Descriptor responseDescriptor = methodDescriptor.getOutputType();
            MessageRegistry messageRegistry = MessageRegistry.getInstance();
            messageRegistry.addMessageDescriptor(requestDescriptor.getFullName(), requestDescriptor);
            MessageUtils.setNestedMessages(requestDescriptor, messageRegistry);
            messageRegistry.addMessageDescriptor(responseDescriptor.getFullName(), responseDescriptor);
            MessageUtils.setNestedMessages(responseDescriptor, messageRegistry);
            MethodDescriptor.Marshaller reqMarshaller = null;
            ServiceResource mappedResource = null;
            Module inputParameterPackage = TypeUtils.getType((Object)service).getPackage();
            ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
            for (MethodType function : serviceType.getMethods()) {
                Object annotation2;
                if (!methodDescriptor.getName().equals(function.getName())) continue;
                Type inputParameterType = ServicesBuilderUtils.getRemoteInputParameterType(function);
                if (inputParameterType instanceof RecordType && (annotation2 = ((RecordType)inputParameterType).getAnnotation(GrpcConstants.ANN_PROTOBUF_DESCRIPTOR)) != null) {
                    Descriptors.FileDescriptor fileDescriptor = ServicesBuilderUtils.getDescriptor(annotation2);
                    fileDescriptorHashMapByFilename.put(fileDescriptor.getFullName(), fileDescriptor);
                    fileDescriptorHashMapBySymbol.put(fileDescriptor.findMessageTypeByName(inputParameterType.getName()).getFullName(), fileDescriptor);
                }
                mappedResource = new ServiceResource(runtime, service, serviceDescriptor.getName(), function, methodDescriptor);
                reqMarshaller = ProtoUtils.marshaller(new MessageParser(requestDescriptor.getFullName(), inputParameterType));
                inputParameterPackage = inputParameterType.getPackage();
                break;
            }
            if (methodDescriptor.toProto().getServerStreaming() && methodDescriptor.toProto().getClientStreaming()) {
                methodType = MethodDescriptor.MethodType.BIDI_STREAMING;
                serverCallHandler = new StreamingServerCallHandler(methodDescriptor, mappedResource, ServicesBuilderUtils.getBallerinaValueType(inputParameterPackage, requestDescriptor.getName()));
            } else if (methodDescriptor.toProto().getClientStreaming()) {
                methodType = MethodDescriptor.MethodType.CLIENT_STREAMING;
                serverCallHandler = new StreamingServerCallHandler(methodDescriptor, mappedResource, ServicesBuilderUtils.getBallerinaValueType(inputParameterPackage, requestDescriptor.getName()));
            } else if (methodDescriptor.toProto().getServerStreaming()) {
                methodType = MethodDescriptor.MethodType.SERVER_STREAMING;
                serverCallHandler = new UnaryServerCallHandler(methodDescriptor, mappedResource);
            } else {
                methodType = MethodDescriptor.MethodType.UNARY;
                serverCallHandler = new UnaryServerCallHandler(methodDescriptor, mappedResource);
            }
            if (reqMarshaller == null) {
                reqMarshaller = ProtoUtils.marshaller(new MessageParser(requestDescriptor.getFullName(), ServicesBuilderUtils.getBallerinaValueType(TypeUtils.getType((Object)service).getPackage(), requestDescriptor.getName())));
            }
            MethodDescriptor.Marshaller resMarshaller = ProtoUtils.marshaller(new MessageParser(responseDescriptor.getFullName(), ServicesBuilderUtils.getBallerinaValueType(ServicesBuilderUtils.getOutputPackage(service, methodDescriptor.getName()), responseDescriptor.getName())));
            Type valueType = ServicesBuilderUtils.getBallerinaValueType(ServicesBuilderUtils.getOutputPackage(service, methodDescriptor.getName()), responseDescriptor.getName());
            if (valueType instanceof RecordType && (annotation = ((RecordType)valueType).getAnnotation(GrpcConstants.ANN_PROTOBUF_DESCRIPTOR)) != null) {
                Descriptors.FileDescriptor fileDescriptor = ServicesBuilderUtils.getDescriptor(annotation);
                fileDescriptorHashMapByFilename.put(fileDescriptor.getFullName(), fileDescriptor);
                fileDescriptorHashMapBySymbol.put(fileDescriptor.findMessageTypeByName(valueType.getName()).getFullName(), fileDescriptor);
            }
            MethodDescriptor.Builder methodBuilder = MethodDescriptor.newBuilder();
            MethodDescriptor grpcMethodDescriptor = methodBuilder.setType(methodType).setFullMethodName(methodName).setRequestMarshaller(reqMarshaller).setResponseMarshaller(resMarshaller).setSchemaDescriptor(methodDescriptor).build();
            serviceDefBuilder.addMethod(grpcMethodDescriptor, serverCallHandler);
        }
        return serviceDefBuilder.build();
    }

    private ServicesBuilderUtils() {
    }

    private static Descriptors.FileDescriptor getDescriptor(Object annotationData) throws GrpcServerException {
        if (annotationData == null) {
            return null;
        }
        try {
            BMap annotationMap = (BMap)annotationData;
            BString descriptorData = annotationMap.getStringValue(StringUtils.fromString((String)"value"));
            if (descriptorData == null) {
                descriptorData = annotationMap.getStringValue(StringUtils.fromString((String)"descriptor"));
            }
            BMap descMap = annotationMap.getMapValue(StringUtils.fromString((String)"descMap"));
            return ServicesBuilderUtils.getFileDescriptor(descriptorData, (BMap<BString, Object>)descMap);
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new GrpcServerException("Error while reading the service proto descriptor. check the service implementation. ", e);
        }
    }

    private static Descriptors.FileDescriptor getDescriptorFromService(BObject service) throws GrpcServerException {
        try {
            BString descriptorData = null;
            ObjectType type = (ObjectType)TypeUtils.getReferredType((Type)service.getType());
            if (type.getFields().containsKey("descriptor")) {
                descriptorData = service.getStringValue(StringUtils.fromString((String)"descriptor"));
            } else if (type.getFields().containsKey("value")) {
                descriptorData = service.getStringValue(StringUtils.fromString((String)"value"));
            }
            BMap descMap = null;
            if (type.getFields().containsKey("descMap")) {
                descMap = service.getMapValue(StringUtils.fromString((String)"descMap"));
            }
            if (descriptorData == null || descMap == null) {
                return null;
            }
            return ServicesBuilderUtils.getFileDescriptor(descriptorData, (BMap<BString, Object>)descMap);
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new GrpcServerException("Error while reading the service proto descriptor. check the service implementation. ", e);
        }
    }

    private static Descriptors.FileDescriptor getFileDescriptor(BString descriptorData, BMap<BString, Object> descMap) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException, GrpcServerException {
        byte[] descriptor = ServicesBuilderUtils.hexStringToByteArray(descriptorData.getValue());
        if (descriptor.length == 0) {
            throw new GrpcServerException("Error while reading the service proto descriptor. input descriptor string is null.");
        }
        DescriptorProtos.FileDescriptorProto descriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])descriptor);
        if (descriptorProto == null) {
            throw new GrpcServerException("Error while reading the service proto descriptor. File proto descriptor is null.");
        }
        ArrayList<Descriptors.FileDescriptor> fileDescriptors = new ArrayList<Descriptors.FileDescriptor>();
        for (ByteString dependency : descriptorProto.getDependencyList().asByteStringList()) {
            String dependencyKey = dependency.toStringUtf8();
            if (descMap == null || descMap.isEmpty()) {
                Descriptors.FileDescriptor dependentDescriptor = StandardDescriptorBuilder.getFileDescriptor(dependencyKey);
                if (dependentDescriptor == null) continue;
                fileDescriptors.add(dependentDescriptor);
                continue;
            }
            if (!descMap.containsKey((Object)StringUtils.fromString((String)dependencyKey))) continue;
            fileDescriptors.add(ServicesBuilderUtils.getFileDescriptor((BString)descMap.get((Object)StringUtils.fromString((String)dependencyKey)), descMap));
        }
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)descriptorProto, (Descriptors.FileDescriptor[])((Descriptors.FileDescriptor[])fileDescriptors.toArray(Descriptors.FileDescriptor[]::new)), (boolean)true);
    }

    static byte[] hexStringToByteArray(String sDescriptor) {
        if (sDescriptor == null) {
            return new byte[0];
        }
        int len = sDescriptor.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(sDescriptor.charAt(i), 16) << 4) + Character.digit(sDescriptor.charAt(i + 1), 16));
        }
        return data;
    }

    static Module getInputPackage(BObject service, String remoteFunctionName) {
        Parameter[] parameters;
        int noOfParams;
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        Optional<MethodType> remoteCallType = Arrays.stream(serviceType.getMethods()).filter(methodType -> methodType.getName().equals(remoteFunctionName)).findFirst();
        if (remoteCallType.isPresent() && (noOfParams = (parameters = remoteCallType.get().getParameters()).length) > 0) {
            Type inputType = TypeUtils.getReferredType((Type)parameters[noOfParams - 1].type);
            if (inputType instanceof StreamType) {
                return ((StreamType)inputType).getConstrainedType().getPackage();
            }
            return inputType.getPackage();
        }
        return serviceType.getPackage();
    }

    static Module getOutputPackage(BObject service, String remoteFunctionName) {
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        Optional<MethodType> remoteCallType = Arrays.stream(serviceType.getMethods()).filter(methodType -> methodType.getName().equals(remoteFunctionName)).findFirst();
        if (remoteCallType.isPresent()) {
            Type returnType = remoteCallType.get().getType().getReturnType();
            if (returnType instanceof UnionType) {
                UnionType returnTypeAsUnion = (UnionType)returnType;
                Optional<Type> returnDataType = returnTypeAsUnion.getOriginalMemberTypes().stream().filter(type -> ServicesBuilderUtils.isStreamOrRecordType(type)).findFirst();
                if (returnDataType.isPresent()) {
                    Type outputType = TypeUtils.getReferredType((Type)returnDataType.get());
                    if (outputType instanceof StreamType) {
                        return ((StreamType)outputType).getConstrainedType().getPackage();
                    }
                    return outputType.getPackage();
                }
            } else if (returnType != null && !(returnType instanceof NullType) && returnType.getPackage() != null) {
                return returnType.getPackage();
            }
        }
        return serviceType.getPackage();
    }

    private static boolean isStreamOrRecordType(Type type) {
        Type referredType = TypeUtils.getReferredType((Type)type);
        return referredType instanceof RecordType || referredType instanceof StreamType;
    }

    static Type getBallerinaValueType(Module module, String protoType) {
        if (protoType.equalsIgnoreCase("DoubleValue") || protoType.equalsIgnoreCase("FloatValue")) {
            return PredefinedTypes.TYPE_FLOAT;
        }
        if (protoType.equalsIgnoreCase("Int32Value") || protoType.equalsIgnoreCase("Int64Value") || protoType.equalsIgnoreCase("UInt32Value") || protoType.equalsIgnoreCase("UInt64Value")) {
            return PredefinedTypes.TYPE_INT;
        }
        if (protoType.equalsIgnoreCase("BoolValue")) {
            return PredefinedTypes.TYPE_BOOLEAN;
        }
        if (protoType.equalsIgnoreCase("StringValue")) {
            return PredefinedTypes.TYPE_STRING;
        }
        if (protoType.equalsIgnoreCase("Empty")) {
            return PredefinedTypes.TYPE_NULL;
        }
        if (protoType.equalsIgnoreCase("BytesValue")) {
            return TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BYTE);
        }
        if (protoType.equals("Timestamp")) {
            TupleType tupleType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_DECIMAL));
            return tupleType;
        }
        if (protoType.equals("Duration")) {
            return PredefinedTypes.TYPE_DECIMAL;
        }
        if (protoType.equals("Struct")) {
            return PredefinedTypes.TYPE_MAP;
        }
        if (protoType.equals("Any")) {
            return ValueCreator.createRecordValue((Module)ProtoTypesUtils.getProtoTypesAnyModule(), (String)"Any").getType();
        }
        return ValueCreator.createRecordValue((Module)module, (String)protoType).getType();
    }

    private static Type getRemoteInputParameterType(MethodType attachedFunction) {
        Type inputType;
        Type[] inputParams = ServicesBuilderUtils.getParameterTypesFromParameters(attachedFunction.getType().getParameters());
        if (inputParams.length == 1) {
            inputType = inputParams[0];
        } else if (inputParams.length >= 2) {
            inputType = inputParams[1];
        } else {
            return PredefinedTypes.TYPE_NULL;
        }
        if (inputType != null && "Headers".equals(inputType.getName()) && inputType.getPackage() != null && "grpc".equals(inputType.getPackage().getName())) {
            return PredefinedTypes.TYPE_NULL;
        }
        if (inputType instanceof StreamType) {
            return ((StreamType)inputType).getConstrainedType();
        }
        if (inputType instanceof RecordType && inputType.getName().startsWith("Context") && ((RecordType)inputType).getFields().size() == 2) {
            Type contentType = TypeUtils.getReferredType((Type)((Field)((RecordType)inputType).getFields().get("content")).getFieldType());
            if (contentType instanceof StreamType) {
                return ((StreamType)contentType).getConstrainedType();
            }
            return contentType;
        }
        return inputType;
    }

    static Type[] getParameterTypesFromParameters(Parameter[] parameters) {
        Type[] paramTypes = new Type[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            paramTypes[i] = TypeUtils.getReferredType((Type)parameters[i].type);
        }
        return paramTypes;
    }
}

