/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.listener;

import com.google.protobuf.Descriptors;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.ServerCall;
import io.ballerina.stdlib.grpc.ServiceResource;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.exception.GrpcServerException;
import io.ballerina.stdlib.grpc.listener.ServerCallHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;

public class UnaryServerCallHandler
extends ServerCallHandler {
    private ServiceResource resource;

    public UnaryServerCallHandler(Descriptors.MethodDescriptor methodDescriptor, ServiceResource resource) throws GrpcServerException {
        super(methodDescriptor);
        if (resource == null) {
            String serviceType = "Simple";
            if (methodDescriptor.isServerStreaming()) {
                serviceType = "Server streaming";
            }
            throw new GrpcServerException(serviceType + " remote function '" + methodDescriptor.getFullName() + "' does not exist.");
        }
        this.resource = resource;
    }

    @Override
    public ServerCallHandler.Listener startCall(ServerCall call) {
        if (!call.getMethodDescriptor().getType().clientSendsOneMessage()) {
            throw new RuntimeException("asyncUnaryRequestCall is only for clientSendsOneMessage methods");
        }
        ServerCallHandler.ServerCallStreamObserver responseObserver = new ServerCallHandler.ServerCallStreamObserver(call);
        return new UnaryServerCallListener(responseObserver, call);
    }

    private final class UnaryServerCallListener
    implements ServerCallHandler.Listener {
        private final ServerCall call;
        private final ServerCallHandler.ServerCallStreamObserver responseObserver;
        private boolean canInvoke = true;
        private Message request;

        UnaryServerCallListener(ServerCallHandler.ServerCallStreamObserver responseObserver, ServerCall call) {
            this.call = call;
            this.responseObserver = responseObserver;
        }

        @Override
        public void onMessage(Message request) {
            if (this.request != null) {
                this.call.close(Status.Code.INTERNAL.toStatus().withDescription("Too many requests"), (HttpHeaders)new DefaultHttpHeaders());
                this.canInvoke = false;
                return;
            }
            this.request = request;
        }

        @Override
        public void onHalfClose() {
            if (!this.canInvoke) {
                return;
            }
            if (this.request == null) {
                this.call.close(Status.Code.INTERNAL.toStatus().withDescription("Half-closed without a request"), (HttpHeaders)new DefaultHttpHeaders());
                return;
            }
            UnaryServerCallHandler.this.onMessageInvoke(UnaryServerCallHandler.this.resource, this.request, this.responseObserver, this.call.getObserverContext());
        }

        @Override
        public void onCancel(Message message) {
        }

        @Override
        public void onComplete() {
        }
    }
}

