/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.nativeimpl.serviceendpoint;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.GrpcUtil;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.ServerConnectorListener;
import io.ballerina.stdlib.grpc.ServerConnectorPortBindingListener;
import io.ballerina.stdlib.grpc.ServerServiceDefinition;
import io.ballerina.stdlib.grpc.ServicesBuilderUtils;
import io.ballerina.stdlib.grpc.ServicesRegistry;
import io.ballerina.stdlib.grpc.StandardDescriptorBuilder;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.exception.GrpcServerException;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.grpc.nativeimpl.AbstractGrpcNativeFunction;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.api.HttpConnectionManager;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.contract.PortBindingEventListener;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionUtils
extends AbstractGrpcNativeFunction {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionUtils.class);

    private FunctionUtils() {
    }

    public static Object externInitEndpoint(BObject listenerObject) {
        BMap serviceEndpointConfig = listenerObject.getMapValue(StringUtils.fromString((String)"config"));
        long port = listenerObject.getIntValue(HttpConstants.ENDPOINT_CONFIG_PORT);
        try {
            ListenerConfiguration configuration = GrpcUtil.getListenerConfig(port, serviceEndpointConfig);
            ServerConnector httpServerConnector = HttpConnectionManager.getInstance().createHttpServerConnector(configuration);
            ServicesRegistry.Builder servicesRegistryBuilder = new ServicesRegistry.Builder();
            listenerObject.addNativeData("SERVER_CONNECTOR", (Object)httpServerConnector);
            listenerObject.addNativeData("SERVICE_REGISTRY_BUILDER", (Object)servicesRegistryBuilder);
            return null;
        }
        catch (BError ex) {
            return ex;
        }
        catch (Exception e) {
            LOG.error("Error while initializing service listener.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
    }

    public static Object externRegister(Environment env, BObject listenerObject, BObject service, Object servicePath) {
        ServicesRegistry.Builder servicesRegistryBuilder = FunctionUtils.getServiceRegistryBuilder(listenerObject);
        try {
            if (servicesRegistryBuilder == null) {
                return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error when initializing service register builder.")));
            }
            ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
            servicesRegistryBuilder.addService(ServicesBuilderUtils.getServiceDefinition(env.getRuntime(), service, servicePath, FunctionUtils.getDescriptorAnnotation(serviceType)));
            return null;
        }
        catch (GrpcServerException e) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while registering the service. " + e.getLocalizedMessage())));
        }
    }

    private static Object startServerConnector(BObject listener, ServicesRegistry servicesRegistry) {
        HashMap<String, Long> messageSizeMap = new HashMap<String, Long>();
        messageSizeMap.put("maxInboundMessageSize", (Long)listener.getMapValue(GrpcConstants.CONFIG).get((Object)StringUtils.fromString((String)"maxInboundMessageSize")));
        ServerConnector serverConnector = FunctionUtils.getServerConnector(listener);
        ServerConnectorFuture serverConnectorFuture = serverConnector.start();
        serverConnectorFuture.setHttpConnectorListener((HttpConnectorListener)new ServerConnectorListener(servicesRegistry, messageSizeMap));
        serverConnectorFuture.setPortBindingEventListener((PortBindingEventListener)new ServerConnectorPortBindingListener());
        try {
            serverConnectorFuture.sync();
        }
        catch (Exception ex) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Failed to start server connector '" + serverConnector.getConnectorID() + "'. " + ex.getMessage())));
        }
        listener.addNativeData("CONNECTOR_STARTED", (Object)true);
        return null;
    }

    public static Object externStart(BObject listener) {
        ServicesRegistry.Builder servicesRegistryBuilder = FunctionUtils.getServiceRegistryBuilder(listener);
        if (servicesRegistryBuilder.getServices().isEmpty()) {
            long port = listener.getIntValue(StringUtils.fromString((String)"port"));
            LOG.warn("The listener start is terminated because no attached services found in the listener with port {}", (Object)port);
            return null;
        }
        if (!FunctionUtils.isConnectorStarted(listener)) {
            return FunctionUtils.startServerConnector(listener, servicesRegistryBuilder.build());
        }
        return null;
    }

    public static Object gracefulStop(BObject serverEndpoint) {
        FunctionUtils.getServerConnector(serverEndpoint).stop();
        serverEndpoint.addNativeData("CONNECTOR_STARTED", (Object)false);
        return null;
    }

    public static Object immediateStop(BObject serverEndpoint) {
        FunctionUtils.getServerConnector(serverEndpoint).immediateStop();
        serverEndpoint.addNativeData("CONNECTOR_STARTED", (Object)false);
        return null;
    }

    public static Object nextResult(Environment env, BObject streamIterator) {
        return env.yieldAndRun(() -> {
            BlockingQueue messageQueue = (BlockingQueue)streamIterator.getNativeData("messageQueue");
            try {
                Message nextMessage = (Message)messageQueue.take();
                if (nextMessage.getHeaders() != null) {
                    streamIterator.addNativeData("Headers", (Object)MessageUtils.createHeaderMap(nextMessage.getHeaders()));
                }
                if (nextMessage.isError()) {
                    return MessageUtils.getConnectorError(nextMessage.getError());
                }
                return nextMessage.getbMessage();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                String message = "Internal error occurred. The current thread got interrupted";
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription(message)));
            }
        });
    }

    public static Object closeStream(Environment env, BObject streamIterator) {
        BError returnError;
        BlockingQueue messageQueue = (BlockingQueue)streamIterator.getNativeData("messageQueue");
        BObject clientEndpoint = (BObject)streamIterator.getNativeData("ResponseObserver");
        Object errorVal = streamIterator.getNativeData("errorMessage");
        if (errorVal instanceof BError) {
            returnError = (BError)((Object)errorVal);
        } else {
            if (clientEndpoint != null) {
                io.ballerina.stdlib.grpc.nativeimpl.caller.FunctionUtils.externComplete(env, clientEndpoint);
            }
            returnError = null;
        }
        messageQueue.clear();
        return returnError;
    }

    public static Object externGetServices(BObject listener) {
        BMap listServiceResponse = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"ListServiceResponse");
        BArray serviceResponses = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)TypeCreator.createRecordType((String)"ServiceResponse", (Module)ModuleUtils.getModule(), (long)0L, (boolean)false, (int)0)));
        ServicesRegistry.Builder servicesRegistryBuilder = (ServicesRegistry.Builder)listener.getNativeData("SERVICE_REGISTRY_BUILDER");
        HashMap<String, ServerServiceDefinition> services = servicesRegistryBuilder.getServices();
        int i = 0;
        for (ServerServiceDefinition serviceDefinition : services.values()) {
            BMap serviceResponse = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"ServiceResponse");
            serviceResponse.put((Object)StringUtils.fromString((String)"name"), (Object)StringUtils.fromString((String)serviceDefinition.getServiceDescriptor().getName()));
            serviceResponses.add((long)i, (Object)serviceResponse);
            ++i;
        }
        listServiceResponse.put((Object)StringUtils.fromString((String)"service"), (Object)serviceResponses);
        return listServiceResponse;
    }

    public static Object externGetFileDescBySymbol(BObject listener, BString symbol) {
        if (ServicesBuilderUtils.fileDescriptorHashMapBySymbol.containsKey(symbol.getValue())) {
            return FunctionUtils.createFileDescriptorResponse("file_descriptor_proto", ValueCreator.createArrayValue((byte[])ServicesBuilderUtils.fileDescriptorHashMapBySymbol.get(symbol.getValue()).toProto().toByteArray()));
        }
        return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.NOT_FOUND.toStatus().getCode()).withDescription(symbol.getValue() + " symbol not found")));
    }

    public static Object externGetFileDescByFilename(BString filename) {
        Descriptors.FileDescriptor fd;
        if (StandardDescriptorBuilder.getFileDescriptor(filename.getValue()) != null) {
            fd = StandardDescriptorBuilder.getFileDescriptor(filename.getValue());
        } else if (ServicesBuilderUtils.fileDescriptorHashMapByFilename.containsKey(filename.getValue())) {
            fd = ServicesBuilderUtils.fileDescriptorHashMapByFilename.get(filename.getValue());
        } else {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.NOT_FOUND.toStatus().getCode()).withDescription(filename.getValue() + " not found")));
        }
        return FunctionUtils.createFileDescriptorResponse("file_descriptor_proto", ValueCreator.createArrayValue((byte[])fd.toProto().toByteArray()));
    }

    public static Object externGetFileContainingExtension(BString containingType, int extensionNumber) {
        for (Descriptors.FileDescriptor fd : StandardDescriptorBuilder.getDescriptorMapForPackageKey().values()) {
            for (Descriptors.FieldDescriptor fieldDescriptor : fd.getExtensions()) {
                if (!fieldDescriptor.getContainingType().getFullName().equals(containingType.getValue()) || fieldDescriptor.getNumber() != extensionNumber) continue;
                return FunctionUtils.createFileDescriptorResponse("file_descriptor_proto", ValueCreator.createArrayValue((byte[])fd.toProto().toByteArray()));
            }
        }
        for (Descriptors.FileDescriptor fd : ServicesBuilderUtils.fileDescriptorHashMapByFilename.values()) {
            for (Descriptors.FieldDescriptor fieldDescriptor : fd.getExtensions()) {
                if (!fieldDescriptor.getContainingType().getFullName().equals(containingType.getValue()) || fieldDescriptor.getNumber() != extensionNumber) continue;
                return FunctionUtils.createFileDescriptorResponse("file_descriptor_proto", ValueCreator.createArrayValue((byte[])fd.toProto().toByteArray()));
            }
        }
        return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.NOT_FOUND.toStatus().getCode()).withDescription("File descriptor containing type " + containingType.getValue() + " and extension " + extensionNumber + " not found")));
    }

    public static Object externGetAllExtensionNumbersOfType(BString messageType) {
        BArray extensionArray = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_INT));
        int i = 0;
        for (Descriptors.FileDescriptor fileDescriptor : StandardDescriptorBuilder.getDescriptorMapForPackageKey().values()) {
            for (Descriptors.FieldDescriptor fieldDescriptor : fileDescriptor.getExtensions()) {
                if (!fieldDescriptor.getContainingType().getFullName().equals(messageType.getValue())) continue;
                extensionArray.add((long)i, (long)fieldDescriptor.getNumber());
                ++i;
            }
        }
        for (Descriptors.FileDescriptor fileDescriptor : ServicesBuilderUtils.fileDescriptorHashMapByFilename.values()) {
            for (Descriptors.FieldDescriptor fieldDescriptor : fileDescriptor.getExtensions()) {
                if (!fieldDescriptor.getContainingType().getFullName().equals(messageType.getValue())) continue;
                extensionArray.add((long)i, (long)fieldDescriptor.getNumber());
                ++i;
            }
        }
        if (extensionArray.size() == 0) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.NOT_FOUND.toStatus().getCode()).withDescription("Message type " + messageType.getValue() + " not found")));
        }
        BMap fileDescriptorResponse = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"ExtensionNumberResponse");
        fileDescriptorResponse.put((Object)StringUtils.fromString((String)"base_type_name"), (Object)messageType);
        fileDescriptorResponse.put((Object)StringUtils.fromString((String)"extension_number"), (Object)extensionArray);
        return fileDescriptorResponse;
    }

    private static Object createFileDescriptorResponse(String key, Object value) {
        BMap fileDescriptorResponse = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"FileDescriptorResponse");
        fileDescriptorResponse.put((Object)StringUtils.fromString((String)key), value);
        return fileDescriptorResponse;
    }

    private static Object getDescriptorAnnotation(ObjectType type) {
        if (type.getAnnotation(GrpcConstants.ANN_SERVICE_DESCRIPTOR_FQN) != null) {
            return type.getAnnotation(GrpcConstants.ANN_SERVICE_DESCRIPTOR_FQN);
        }
        return type.getAnnotation(GrpcConstants.ANN_DESCRIPTOR_FQN);
    }
}

