/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.nativeimpl.streamingclient;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.StreamObserver;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionUtils.class);
    private static final String CONTENT = "content";

    private FunctionUtils() {
    }

    public static Object streamSend(BObject streamConnection, Object responseValue) {
        StreamObserver requestSender = (StreamObserver)streamConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the message. endpoint does not exist")));
        }
        Descriptors.Descriptor inputType = (Descriptors.Descriptor)streamConnection.getNativeData("REQUEST_DEFINITION");
        try {
            Object content;
            BMap headerValues = null;
            if (MessageUtils.isContextRecordByValue(responseValue)) {
                content = ((BMap)responseValue).get((Object)StringUtils.fromString((String)CONTENT));
                headerValues = ((BMap)responseValue).getMapValue(StringUtils.fromString((String)"headers"));
            } else {
                content = responseValue;
            }
            Message requestMessage = new Message(inputType, content);
            HttpHeaders headers = MessageUtils.convertToHttpHeaders(headerValues);
            requestMessage.setHeaders(headers);
            requestSender.onNext(requestMessage);
        }
        catch (Exception e) {
            LOG.error("Error while sending request message to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object streamSendError(Environment env, BObject streamingConnection, BError errorValue) {
        StreamObserver requestSender = (StreamObserver)streamingConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the error. endpoint does not exist")));
        }
        try {
            Integer statusCode = GrpcConstants.getKeyByValue(GrpcConstants.STATUS_ERROR_MAP, errorValue.getType().getName());
            if (statusCode == null) {
                statusCode = Status.Code.INTERNAL.value();
            }
            requestSender.onError(new Message(new StatusRuntimeException(Status.fromCodeValue(statusCode).withDescription(errorValue.getErrorMessage().getValue()))));
            streamingConnection.addNativeData("isStreamCancelled", (Object)true);
            if (ObserveUtils.isObservabilityEnabled()) {
                ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)env);
                observerContext.addTag("grpc.error_message", MessageUtils.getMappingHttpStatusCode(statusCode) + " : " + errorValue.getErrorMessage().getValue());
            }
        }
        catch (Exception e) {
            LOG.error("Error while sending error to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object streamComplete(BObject streamingConnection) {
        StreamObserver requestSender = (StreamObserver)streamingConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while completing the message. endpoint does not exist")));
        }
        try {
            requestSender.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Error while sending complete message to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object externIsBidirectional(BObject streamingConnection) {
        return (boolean)((Boolean)streamingConnection.getNativeData("isBidiStreaming"));
    }

    public static Object externReceive(Environment env, BObject streamingConnection) {
        Boolean isStreamCancelled = (Boolean)streamingConnection.getNativeData("isStreamCancelled");
        if (isStreamCancelled != null && isStreamCancelled.booleanValue()) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Client call was already cancelled.")));
        }
        BlockingQueue messageQueue = (BlockingQueue)streamingConnection.getNativeData("messageQueue");
        boolean isBidiStream = (Boolean)streamingConnection.getNativeData("isBidiStreaming");
        if (messageQueue == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the message. endpoint does not exist")));
        }
        try {
            if (isBidiStream) {
                BObject streamIterator = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"StreamIterator", (Object[])new Object[1]);
                streamIterator.addNativeData("messageQueue", (Object)messageQueue);
                streamingConnection.addNativeData("streamIterator", (Object)streamIterator);
                return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)PredefinedTypes.TYPE_ANYDATA), (BObject)streamIterator);
            }
            return env.yieldAndRun(() -> {
                try {
                    Message nextMessage = (Message)messageQueue.take();
                    streamingConnection.addNativeData("Headers", (Object)MessageUtils.createHeaderMap(nextMessage.getHeaders()));
                    if (nextMessage.isError()) {
                        return MessageUtils.getConnectorError(nextMessage.getError());
                    }
                    return nextMessage.getbMessage();
                }
                catch (Exception e) {
                    LOG.error("Error while sending request message to server.", (Throwable)e);
                    return MessageUtils.getConnectorError(e);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error while sending request message to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
    }

    public static Object externGetHeaderMap(BObject streamingConnection, boolean isBidirectional) {
        if (isBidirectional) {
            BObject streamingIterator = (BObject)streamingConnection.getNativeData("streamIterator");
            return streamingIterator.getNativeData("Headers");
        }
        return streamingConnection.getNativeData("Headers");
    }
}

