/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.openapi.service.mapper.model.OpenAPIInfo;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public final class InfoMapper {
    static OASResult getOASResultWithInfo(ServiceNode serviceNode, SemanticModel semanticModel, String openapiFileName, Path ballerinaFilePath) {
        Optional<MetadataNode> metadata = serviceNode.metadata();
        ArrayList<OpenAPIMapperDiagnostic> diagnostics = new ArrayList<OpenAPIMapperDiagnostic>();
        OpenAPI openAPI = new OpenAPI();
        String currentServiceName = serviceNode.absoluteResourcePath();
        String version = InfoMapper.getContractVersion(serviceNode, semanticModel);
        if (metadata.isPresent() && !metadata.get().annotations().isEmpty()) {
            MetadataNode metadataNode = metadata.get();
            NodeList annotations = metadataNode.annotations();
            for (AnnotationNode annotation : annotations) {
                if (annotation.annotReference().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                    QualifiedNameReferenceNode ref = (QualifiedNameReferenceNode)annotation.annotReference();
                    String annotationName = ref.modulePrefix().text() + ":" + ref.identifier().text();
                    if (annotationName.equals("openapi:ServiceInfo")) {
                        OASResult oasResult = InfoMapper.parseServiceInfoAnnotationAttachmentDetails(diagnostics, annotation, ballerinaFilePath);
                        return InfoMapper.normalizeInfoSection(openapiFileName, currentServiceName, version, oasResult);
                    }
                    InfoMapper.setInfoDetailsIfServiceNameAbsent(openapiFileName, openAPI, currentServiceName, version);
                    continue;
                }
                InfoMapper.setInfoDetailsIfServiceNameAbsent(openapiFileName, openAPI, currentServiceName, version);
            }
        } else {
            InfoMapper.setInfoDetailsIfServiceNameAbsent(openapiFileName, openAPI, currentServiceName, version);
        }
        return new OASResult(openAPI, diagnostics);
    }

    private static void setInfoDetailsIfServiceNameAbsent(String openapiFileName, OpenAPI openAPI, String currentServiceName, String version) {
        if (currentServiceName.equals("/") || currentServiceName.isBlank()) {
            openAPI.setInfo(new Info().version(version).title(InfoMapper.normalizeTitle(openapiFileName)));
        } else {
            openAPI.setInfo(new Info().version(version).title(InfoMapper.normalizeTitle(currentServiceName)));
        }
    }

    private static OASResult normalizeInfoSection(String openapiFileName, String currentServiceName, String version, OASResult oasResult) {
        if (oasResult.getOpenAPI().isPresent()) {
            OpenAPI openAPI = oasResult.getOpenAPI().get();
            if (openAPI.getInfo() == null) {
                String title = InfoMapper.normalizeTitle(currentServiceName);
                if (currentServiceName.equals("/")) {
                    title = InfoMapper.normalizeTitle(openapiFileName);
                }
                openAPI.setInfo(new Info().title(title).version(version));
            } else {
                if (openAPI.getInfo().getTitle() == null) {
                    openAPI.getInfo().setTitle(InfoMapper.normalizeTitle(currentServiceName));
                } else if (openAPI.getInfo().getTitle() != null && openAPI.getInfo().getTitle().equals("/")) {
                    openAPI.getInfo().setTitle(InfoMapper.normalizeTitle(openapiFileName));
                } else if (openAPI.getInfo().getTitle().isBlank()) {
                    openAPI.getInfo().setTitle(InfoMapper.normalizeTitle(currentServiceName));
                } else if (openAPI.getInfo().getTitle() == null && currentServiceName.equals("/")) {
                    openAPI.getInfo().setTitle(InfoMapper.normalizeTitle(openapiFileName));
                }
                if (openAPI.getInfo().getVersion() == null || openAPI.getInfo().getVersion().isBlank()) {
                    openAPI.getInfo().setVersion(version);
                }
            }
            return new OASResult(openAPI, oasResult.getDiagnostics());
        }
        return oasResult;
    }

    private static String getContractVersion(ServiceNode serviceDefinition, SemanticModel semanticModel) {
        Symbol serviceSymbol;
        Optional module;
        Optional<Symbol> symbol = serviceDefinition.getSymbol(semanticModel);
        String version = "1.0.0";
        if (symbol.isPresent() && (module = (serviceSymbol = symbol.get()).getModule()).isPresent()) {
            version = ((ModuleSymbol)module.get()).id().version();
        }
        return version;
    }

    private static String normalizeTitle(String title) {
        if (title != null) {
            String[] splits = title.replaceFirst("/", "").split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])");
            StringBuilder stringBuilder = new StringBuilder();
            if (splits.length > 1) {
                for (String piece : splits) {
                    if (piece.isBlank()) continue;
                    stringBuilder.append(piece.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(piece.substring(1));
                    stringBuilder.append(" ");
                }
                title = stringBuilder.toString().trim();
            } else if (splits.length == 1 && !splits[0].isBlank()) {
                stringBuilder.append(splits[0].substring(0, 1).toUpperCase(Locale.ENGLISH)).append(splits[0].substring(1));
                title = stringBuilder.toString().trim();
            }
            return title;
        }
        return null;
    }

    private static OASResult parseServiceInfoAnnotationAttachmentDetails(List<OpenAPIMapperDiagnostic> diagnostics, AnnotationNode annotation, Path ballerinaFilePath) {
        NodeLocation location = annotation.location();
        OpenAPI openAPI = new OpenAPI();
        Optional svcInfoAnnotationValue = annotation.annotValue();
        if (svcInfoAnnotationValue.isEmpty()) {
            return new OASResult(openAPI, diagnostics);
        }
        SeparatedNodeList fields = ((MappingConstructorExpressionNode)svcInfoAnnotationValue.get()).fields();
        if (fields.isEmpty()) {
            return new OASResult(openAPI, diagnostics);
        }
        OpenAPIInfo openAPIInfo = InfoMapper.updateOpenAPIInfoModel((SeparatedNodeList<MappingFieldNode>)fields);
        if (openAPIInfo.getContractPath().isPresent() && ballerinaFilePath != null) {
            return InfoMapper.updateExistingContractOpenAPI(diagnostics, (Location)location, openAPIInfo, ballerinaFilePath);
        }
        InfoMapper.populateOASInfo(openAPI, openAPIInfo);
        return new OASResult(openAPI, diagnostics);
    }

    private static void populateOASInfo(OpenAPI openAPI, OpenAPIInfo openAPIInfo) {
        Info info = openAPI.getInfo() == null ? new Info() : openAPI.getInfo();
        openAPIInfo.getTitle().ifPresent(title -> info.setTitle(InfoMapper.normalizeTitle(title)));
        openAPIInfo.getVersion().ifPresent(arg_0 -> ((Info)info).setVersion(arg_0));
        openAPIInfo.getEmail().ifPresent(email -> {
            Contact contact = info.getContact() != null ? info.getContact() : new Contact();
            contact.setEmail(email);
            info.setContact(contact);
        });
        openAPIInfo.getContactName().ifPresent(name -> {
            Contact contact = info.getContact() != null ? info.getContact() : new Contact();
            contact.setName(name);
            info.setContact(contact);
        });
        openAPIInfo.getContactURL().ifPresent(url -> {
            Contact contact = info.getContact() != null ? info.getContact() : new Contact();
            contact.setUrl(url);
            info.setContact(contact);
        });
        openAPIInfo.getLicenseURL().ifPresent(url -> {
            License license = info.getLicense() != null ? info.getLicense() : new License();
            license.setUrl(url);
            info.setLicense(license);
        });
        openAPIInfo.getLicenseName().ifPresent(name -> {
            License license = info.getLicense() != null ? info.getLicense() : new License();
            license.setName(name);
            info.setLicense(license);
        });
        openAPIInfo.getTermsOfService().ifPresent(arg_0 -> ((Info)info).setTermsOfService(arg_0));
        openAPIInfo.getDescription().ifPresent(arg_0 -> ((Info)info).setDescription(arg_0));
        openAPI.setInfo(info);
    }

    private static OASResult updateExistingContractOpenAPI(List<OpenAPIMapperDiagnostic> diagnostics, Location location, OpenAPIInfo openAPIInfo, Path ballerinaFilePath) {
        OASResult oasResult = InfoMapper.resolveContractPath(diagnostics, location, openAPIInfo, ballerinaFilePath);
        Optional<OpenAPI> contract = oasResult.getOpenAPI();
        if (contract.isEmpty()) {
            return oasResult;
        }
        OpenAPI openAPI = contract.get();
        diagnostics.addAll(oasResult.getDiagnostics());
        InfoMapper.populateOASInfo(openAPI, openAPIInfo);
        return new OASResult(openAPI, diagnostics);
    }

    private static OpenAPIInfo updateOpenAPIInfoModel(SeparatedNodeList<MappingFieldNode> fields) {
        OpenAPIInfo.OpenAPIInfoBuilder infoBuilder = new OpenAPIInfo.OpenAPIInfoBuilder();
        for (MappingFieldNode field : fields) {
            String fieldValue;
            ExpressionNode expressionNode;
            String fieldName = ((SpecificFieldNode)field).fieldName().toString().trim();
            Optional value = ((SpecificFieldNode)field).valueExpr();
            if (!value.isPresent() || (expressionNode = (ExpressionNode)value.get()).toString().trim().isBlank() || (fieldValue = expressionNode.toString().trim().replaceAll("\"", "")).isBlank()) continue;
            switch (fieldName) {
                case "contract": {
                    infoBuilder.contractPath(fieldValue);
                    break;
                }
                case "title": {
                    infoBuilder.title(fieldValue);
                    break;
                }
                case "version": {
                    infoBuilder.version(fieldValue);
                    break;
                }
                case "email": {
                    infoBuilder.email(fieldValue);
                    break;
                }
                case "description": {
                    infoBuilder.description(fieldValue);
                    break;
                }
                case "contactName": {
                    infoBuilder.contactName(fieldValue);
                    break;
                }
                case "contactURL": {
                    infoBuilder.contactURL(fieldValue);
                    break;
                }
                case "termsOfService": {
                    infoBuilder.termsOfService(fieldValue);
                    break;
                }
                case "licenseName": {
                    infoBuilder.licenseName(fieldValue);
                    break;
                }
                case "licenseURL": {
                    infoBuilder.licenseURL(fieldValue);
                    break;
                }
            }
        }
        return infoBuilder.build();
    }

    private static OASResult resolveContractPath(List<OpenAPIMapperDiagnostic> diagnostics, Location location, OpenAPIInfo openAPIInfo, Path ballerinaFilePath) {
        OpenAPI openAPI = null;
        Path openapiPath = Paths.get(openAPIInfo.getContractPath().get().replaceAll("\"", "").trim(), new String[0]);
        Path relativePath = null;
        if (openapiPath.toString().isBlank()) {
            ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_110, location, new String[0]);
            diagnostics.add(diagnostic);
        } else {
            Path path = Paths.get(openapiPath.toString(), new String[0]);
            if (path.isAbsolute()) {
                relativePath = path;
            } else {
                File file = new File(ballerinaFilePath.toString());
                File parentFolder = new File(file.getParent());
                File openapiContract = new File(parentFolder, openapiPath.toString());
                try {
                    relativePath = Paths.get(openapiContract.getCanonicalPath(), new String[0]);
                }
                catch (IOException e) {
                    ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_108, location, e.toString());
                    diagnostics.add(diagnostic);
                }
            }
        }
        if (relativePath != null && Files.exists(relativePath, new LinkOption[0])) {
            OASResult oasResult = MapperCommonUtils.parseOpenAPIFile(relativePath.toString());
            if (oasResult.getOpenAPI().isPresent()) {
                openAPI = oasResult.getOpenAPI().get();
            }
            diagnostics.addAll(oasResult.getDiagnostics());
        }
        return new OASResult(openAPI, diagnostics);
    }
}

