/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.diagnostic;

import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ExceptionDiagnostic
implements OpenAPIMapperDiagnostic {
    private final String code;
    private final String message;
    private final DiagnosticSeverity diagnosticSeverity;
    private final Location location;

    public ExceptionDiagnostic(DiagnosticMessages diagnostic, Location location, String ... args) {
        this.code = diagnostic.getCode();
        this.message = String.format(diagnostic.getDescription(), args);
        this.diagnosticSeverity = diagnostic.getSeverity();
        this.location = location;
    }

    public ExceptionDiagnostic(DiagnosticMessages diagnostic, String ... args) {
        this(diagnostic, (Location)null, args);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public DiagnosticSeverity getDiagnosticSeverity() {
        return this.diagnosticSeverity;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }
}

