/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.example;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.ExampleAnnotationMapper;
import io.ballerina.openapi.service.mapper.example.ExamplesAnnotationMapper;
import io.ballerina.openapi.service.mapper.example.OpenAPIExampleMapper;
import io.ballerina.openapi.service.mapper.example.field.RecordFieldExampleMapper;
import io.ballerina.openapi.service.mapper.example.parameter.DefaultParamExampleMapper;
import io.ballerina.openapi.service.mapper.example.parameter.PathExampleMapper;
import io.ballerina.openapi.service.mapper.example.parameter.RequestExampleMapper;
import io.ballerina.openapi.service.mapper.example.type.TypeExampleMapper;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.type.extension.BallerinaPackage;
import io.ballerina.openapi.service.mapper.type.extension.BallerinaTypeExtensioner;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OpenAPIExampleMapperImpl
implements OpenAPIExampleMapper {
    private final OpenAPI openAPI;
    private final List<OpenAPIMapperDiagnostic> diagnostics;
    private final ServiceNode serviceDeclarationNode;
    private final SemanticModel semanticModel;
    private final ModuleMemberVisitor moduleMemberVisitor;

    public OpenAPIExampleMapperImpl(OpenAPI openAPI, ServiceNode serviceNode, AdditionalData additionalData) {
        this.openAPI = openAPI;
        this.diagnostics = additionalData.diagnostics();
        this.serviceDeclarationNode = serviceNode;
        this.semanticModel = additionalData.semanticModel();
        this.moduleMemberVisitor = additionalData.moduleMemberVisitor();
    }

    @Override
    public void setExamples() {
        Components components = this.openAPI.getComponents();
        if (Objects.isNull(components)) {
            return;
        }
        Map schemas = components.getSchemas();
        schemas.forEach(this::setExamplesForTypes);
        this.serviceDeclarationNode.members().forEach(member -> {
            Optional<ResourceFunction> resourceFunctionOpt = MapperCommonUtils.getResourceFunction(member);
            if (resourceFunctionOpt.isPresent()) {
                ResourceFunction resourceFunction = resourceFunctionOpt.get();
                this.openAPI.getPaths().forEach((path, pathItem) -> pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
                    if (MapperCommonUtils.getOperationId(resourceFunction).equals(operation.getOperationId())) {
                        this.setExamplesForResource(resourceFunction, (Operation)operation);
                    }
                }));
            }
        });
    }

    private void setExamplesForTypes(String name, Schema schema) {
        Optional<TypeDefinitionSymbol> ballerinaType = this.getTypeDefinitionNode(name, schema);
        if (ballerinaType.isEmpty()) {
            return;
        }
        TypeDefinitionSymbol typeDefSymbol = ballerinaType.get();
        TypeExampleMapper typeExampleMapper = new TypeExampleMapper(typeDefSymbol, schema, this.semanticModel, this.diagnostics);
        ((ExampleAnnotationMapper)typeExampleMapper).setExample();
        TypeSymbol typeSymbol = typeDefSymbol.typeDescriptor();
        if (typeSymbol instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
            if (schema instanceof ObjectSchema) {
                ObjectSchema objectSchema = (ObjectSchema)schema;
                RecordFieldExampleMapper recordFieldExampleMapper = new RecordFieldExampleMapper(name, recordTypeSymbol, objectSchema, this.semanticModel, this.diagnostics);
                ((ExampleAnnotationMapper)recordFieldExampleMapper).setExample();
            }
        }
    }

    private Optional<TypeDefinitionSymbol> getTypeDefinitionNode(String name, Schema schema) {
        Object t;
        Optional ballerinaType;
        Optional<BallerinaPackage> ballerinaExt = BallerinaTypeExtensioner.getExtension(schema);
        if (ballerinaExt.isPresent()) {
            BallerinaPackage ballerinaPkg = ballerinaExt.get();
            String typeName = Objects.isNull(ballerinaPkg.name()) ? name : ballerinaPkg.name();
            ballerinaType = this.semanticModel.types().getTypeByName(ballerinaPkg.orgName(), ballerinaPkg.moduleName(), ballerinaPkg.version(), typeName);
        } else {
            Optional<TypeDefinitionNode> typeDefinitionNode = this.moduleMemberVisitor.getTypeDefinitionNode(name);
            if (typeDefinitionNode.isEmpty()) {
                return Optional.empty();
            }
            ballerinaType = this.semanticModel.symbol((Node)typeDefinitionNode.get());
        }
        if (ballerinaType.isEmpty() || !((t = ballerinaType.get()) instanceof TypeDefinitionSymbol)) {
            return Optional.empty();
        }
        TypeDefinitionSymbol typeDefSymbol = (TypeDefinitionSymbol)t;
        return Optional.of(typeDefSymbol);
    }

    private void setExamplesForResource(ResourceFunction resourceFunction, Operation operation) {
        SeparatedNodeList parameters = resourceFunction.functionSignature().parameters();
        parameters.forEach(parameter -> this.setExamplesForResourceSignatureParam((ParameterNode)parameter, operation));
        List<ResourcePathParameterNode> pathParameters = resourceFunction.relativeResourcePath().stream().filter(param -> param instanceof ResourcePathParameterNode).map(param -> (ResourcePathParameterNode)param).toList();
        pathParameters.forEach(pathParam -> this.setExamplesForResourcePathParam((ResourcePathParameterNode)pathParam, operation));
    }

    private void setExamplesForResourceSignatureParam(ParameterNode parameterNode, Operation operation) {
        Object t;
        Optional parameterSymbolOpt = this.semanticModel.symbol((Node)parameterNode);
        if (parameterSymbolOpt.isEmpty() || !((t = parameterSymbolOpt.get()) instanceof ParameterSymbol)) {
            return;
        }
        ParameterSymbol parameterSymbol = (ParameterSymbol)t;
        ParameterType parameterType = OpenAPIExampleMapperImpl.getParameterType(parameterSymbol, this.semanticModel);
        switch (parameterType.ordinal()) {
            case 0: {
                RequestBody requestBody = operation.getRequestBody();
                RequestExampleMapper reqExampleMapper = new RequestExampleMapper(parameterSymbol, requestBody, this.semanticModel, this.diagnostics);
                ((ExampleAnnotationMapper)reqExampleMapper).setExample();
                ((ExamplesAnnotationMapper)reqExampleMapper).setExamples();
                break;
            }
            case 1: {
                Optional<Parameter> queryParam = operation.getParameters().stream().filter(param -> param.getIn().equals("query") && param.getName().equals(MapperCommonUtils.unescapeIdentifier((String)parameterSymbol.getName().get()))).findFirst();
                if (queryParam.isEmpty()) {
                    return;
                }
                DefaultParamExampleMapper queryExampleMapper = new DefaultParamExampleMapper("query", parameterSymbol, queryParam.get(), this.semanticModel, this.diagnostics);
                ((ExampleAnnotationMapper)queryExampleMapper).setExample();
                ((ExamplesAnnotationMapper)queryExampleMapper).setExamples();
                break;
            }
            case 2: {
                Optional<Parameter> headerParam = operation.getParameters().stream().filter(param -> param.getIn().equals("header") && param.getName().equals(MapperCommonUtils.getHeaderName(parameterNode, MapperCommonUtils.unescapeIdentifier((String)parameterSymbol.getName().get())))).findFirst();
                if (headerParam.isEmpty()) {
                    return;
                }
                DefaultParamExampleMapper headerExampleMapper = new DefaultParamExampleMapper("header", parameterSymbol, headerParam.get(), this.semanticModel, this.diagnostics);
                ((ExampleAnnotationMapper)headerExampleMapper).setExample();
                ((ExamplesAnnotationMapper)headerExampleMapper).setExamples();
                break;
            }
        }
    }

    private void setExamplesForResourcePathParam(ResourcePathParameterNode parameterNode, Operation operation) {
        Object t;
        Optional parameterSymbolOpt = this.semanticModel.symbol((Node)parameterNode);
        if (parameterSymbolOpt.isEmpty() || !((t = parameterSymbolOpt.get()) instanceof PathParameterSymbol)) {
            return;
        }
        PathParameterSymbol parameterSymbol = (PathParameterSymbol)t;
        Optional<Parameter> pathParam = operation.getParameters().stream().filter(parameter -> parameter.getIn().equals("path") && parameter.getName().equals(MapperCommonUtils.unescapeIdentifier((String)parameterSymbol.getName().get()))).findFirst();
        if (pathParam.isEmpty()) {
            return;
        }
        PathExampleMapper pathExampleMapper = new PathExampleMapper(parameterSymbol, pathParam.get(), this.semanticModel, this.diagnostics);
        ((ExampleAnnotationMapper)pathExampleMapper).setExample();
        ((ExamplesAnnotationMapper)pathExampleMapper).setExamples();
    }

    private static ParameterType getParameterType(ParameterSymbol parameterSymbol, SemanticModel semanticModel) {
        TypeSymbol parameterTypeSymbol = parameterSymbol.typeDescriptor();
        if (!parameterTypeSymbol.subtypeOf(semanticModel.types().ANYDATA)) {
            return ParameterType.OTHER;
        }
        List<AnnotationSymbol> httpAnnotations = parameterSymbol.annotations().stream().filter(annotation -> annotation.typeDescriptor().isPresent() && OpenAPIExampleMapperImpl.isHttpPackageAnnotationTypeDesc((TypeSymbol)annotation.typeDescriptor().get())).toList();
        if (httpAnnotations.isEmpty()) {
            return ParameterType.QUERY;
        }
        for (AnnotationSymbol annotation2 : httpAnnotations) {
            TypeSymbol annotationType = (TypeSymbol)annotation2.typeDescriptor().get();
            if (OpenAPIExampleMapperImpl.isSubTypeOfHttpType(annotationType, "HttpPayload", semanticModel)) {
                return ParameterType.PAYLOAD;
            }
            if (OpenAPIExampleMapperImpl.isSubTypeOfHttpType(annotationType, "HttpHeader", semanticModel)) {
                return ParameterType.HEADER;
            }
            if (!OpenAPIExampleMapperImpl.isSubTypeOfHttpType(annotationType, "HttpQuery", semanticModel)) continue;
            return ParameterType.QUERY;
        }
        return ParameterType.QUERY;
    }

    private static boolean isHttpPackageAnnotationTypeDesc(TypeSymbol typeSymbol) {
        Optional module = typeSymbol.getModule();
        if (module.isEmpty()) {
            return false;
        }
        ModuleID id = ((ModuleSymbol)module.get()).id();
        return id.orgName().equals("ballerina") && id.moduleName().startsWith("http");
    }

    private static boolean isSubTypeOfHttpType(TypeSymbol typeSymbol, String httpTypeName, SemanticModel semanticModel) {
        Object t;
        Optional httpType = semanticModel.types().getTypeByName("ballerina", "http", "", httpTypeName);
        if (httpType.isEmpty() || !((t = httpType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol httpTypeDef = (TypeDefinitionSymbol)t;
        return typeSymbol.subtypeOf(httpTypeDef.typeDescriptor());
    }

    private static enum ParameterType {
        PAYLOAD,
        QUERY,
        HEADER,
        OTHER;

    }
}

