/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.resource;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.SingletonTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.util.ArrayList;
import java.util.List;

public abstract class PathSegmentNode {
    private PathSegmentNode next;

    public abstract Type getType();

    public abstract boolean matches(PathSegmentNode var1, SemanticModel var2);

    public PathSegmentNode next() {
        return this.next;
    }

    public void setNext(PathSegmentNode next) {
        this.next = next;
    }

    protected static String getRegex(TypeSymbol pathParamType, SemanticModel semanticModel) {
        if (semanticModel.types().INT.subtypeOf(pathParamType)) {
            return "\\d+";
        }
        if (semanticModel.types().FLOAT.subtypeOf(pathParamType) || semanticModel.types().DECIMAL.subtypeOf(pathParamType)) {
            return "\\d+\\.\\d+";
        }
        if (semanticModel.types().BOOLEAN.subtypeOf(pathParamType)) {
            return "true|false";
        }
        ArrayList<SingletonTypeSymbol> singletons = new ArrayList<SingletonTypeSymbol>();
        if (!PathSegmentNode.extractSingletonTypeSymbols(pathParamType, singletons) || singletons.isEmpty()) {
            return "[^/]+";
        }
        return singletons.stream().map(PathSegmentNode::getSignature).reduce((s, s2) -> s + "|" + s2).orElse("[^/]+");
    }

    private static String getSignature(SingletonTypeSymbol singletonTypeSymbol) {
        String signature = singletonTypeSymbol.signature();
        if (singletonTypeSymbol.originalType().typeKind().equals((Object)TypeDescKind.STRING)) {
            signature = signature.substring(1, signature.length() - 1);
        }
        return signature;
    }

    private static boolean extractSingletonTypeSymbols(TypeSymbol typeSymbol, List<SingletonTypeSymbol> singletons) {
        if (typeSymbol instanceof SingletonTypeSymbol) {
            SingletonTypeSymbol singleton = (SingletonTypeSymbol)typeSymbol;
            singletons.add(singleton);
        } else if (typeSymbol instanceof UnionTypeSymbol) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
            List memberTypes = unionTypeSymbol.memberTypeDescriptors();
            for (TypeSymbol memberType : memberTypes) {
                if (PathSegmentNode.extractSingletonTypeSymbols(memberType, singletons)) continue;
                return false;
            }
        } else {
            if (typeSymbol instanceof TypeReferenceTypeSymbol) {
                return PathSegmentNode.extractSingletonTypeSymbols(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), singletons);
            }
            return false;
        }
        return true;
    }

    public static enum Type {
        DOT_SEGMENT,
        NAMED_SEGMENT,
        PARAMETER_SEGMENT;

    }
}

