/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.metainfo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.metainfo.MetaInfoMapper;
import io.ballerina.openapi.service.mapper.metainfo.ResourceMetaInfoAnnotation;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDeclaration;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDefinition;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaInfoMapperImpl
implements MetaInfoMapper {
    static List<OpenAPIMapperDiagnostic> diagnostics = new ArrayList<OpenAPIMapperDiagnostic>();

    @Override
    public List<OpenAPIMapperDiagnostic> getDiagnostics() {
        return diagnostics;
    }

    @Override
    public void setResourceMetaData(OpenAPI openAPI, ServiceNode serviceNode, Path ballerinaFilePath) {
        NodeList<Node> functions = serviceNode.members();
        HashMap<String, ResourceMetaInfoAnnotation> resourceMetaData = new HashMap<String, ResourceMetaInfoAnnotation>();
        for (Node function : functions) {
            Optional<MetadataNode> optMetadata;
            Optional<ResourceFunction> resourceFunction = MetaInfoMapperImpl.getResourceFunction(function);
            if (!resourceFunction.isPresent() || (optMetadata = resourceFunction.get().metadata()).isEmpty()) continue;
            String operationId = MapperCommonUtils.getOperationId(resourceFunction.get());
            ResourceMetaInfoAnnotation.Builder resMetaInfoBuilder = new ResourceMetaInfoAnnotation.Builder();
            MetadataNode metadataNode = optMetadata.get();
            NodeList annotations = metadataNode.annotations();
            for (AnnotationNode annotation : annotations) {
                Optional optExpressionNode;
                QualifiedNameReferenceNode ref;
                String annotationName;
                if (annotation.annotReference().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !(annotationName = (ref = (QualifiedNameReferenceNode)annotation.annotReference()).modulePrefix().text() + ":" + ref.identifier().text()).equals("openapi:ResourceInfo") || (optExpressionNode = annotation.annotValue()).isEmpty()) continue;
                MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)optExpressionNode.get();
                SeparatedNodeList fields = mappingConstructorExpressionNode.fields();
                block14: for (MappingFieldNode field : fields) {
                    ExpressionNode expressionNode;
                    String fieldName = ((SpecificFieldNode)field).fieldName().toString().trim();
                    Optional value = ((SpecificFieldNode)field).valueExpr();
                    if (value.isEmpty() || (expressionNode = (ExpressionNode)value.get()).toString().trim().isBlank()) continue;
                    String fieldValue = expressionNode.toString().trim().replaceAll("\"", "");
                    switch (fieldName) {
                        case "operationId": {
                            resMetaInfoBuilder.operationId(fieldValue);
                            break;
                        }
                        case "summary": {
                            resMetaInfoBuilder.summary(fieldValue);
                            break;
                        }
                        case "tags": {
                            if (!(expressionNode instanceof ListConstructorExpressionNode)) continue block14;
                            ListConstructorExpressionNode listNode = (ListConstructorExpressionNode)expressionNode;
                            List<String> values = MetaInfoMapperImpl.extractListItems(listNode);
                            resMetaInfoBuilder.tags(values);
                            break;
                        }
                        case "examples": {
                            MetaInfoMapperImpl.handleExamples(resMetaInfoBuilder, expressionNode, ballerinaFilePath);
                            break;
                        }
                    }
                }
            }
            resourceMetaData.put(operationId, resMetaInfoBuilder.build());
        }
        Paths paths = openAPI.getPaths();
        MetaInfoMapperImpl.updateOASWithMetaData(resourceMetaData, paths);
    }

    private static Optional<ResourceFunction> getResourceFunction(Node node) {
        if (node.kind().equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION)) {
            return Optional.of(new ResourceFunctionDefinition((FunctionDefinitionNode)node));
        }
        if (node.kind().equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DECLARATION)) {
            return Optional.of(new ResourceFunctionDeclaration((MethodDeclarationNode)node));
        }
        return Optional.empty();
    }

    private static void handleExamples(ResourceMetaInfoAnnotation.Builder resMetaInfoBuilder, ExpressionNode expressionNode, Path ballerinFilePath) {
        if (expressionNode instanceof MappingConstructorExpressionNode) {
            MappingConstructorExpressionNode mapNode = (MappingConstructorExpressionNode)expressionNode;
            SeparatedNodeList fields = mapNode.fields();
            for (MappingFieldNode resultField : fields) {
                ExceptionDiagnostic diagnostic;
                DiagnosticMessages messages;
                Map objectMap;
                ObjectMapper objectMapper;
                ExpressionNode expressValue;
                Optional optExamplesValue;
                SpecificFieldNode resultField1 = (SpecificFieldNode)resultField;
                String fName = resultField1.fieldName().toSourceCode().trim().replaceAll("\"", "");
                if (fName.equals("response")) {
                    optExamplesValue = resultField1.valueExpr();
                    if (optExamplesValue.isEmpty()) continue;
                    expressValue = (ExpressionNode)optExamplesValue.get();
                    String sourceCode = MetaInfoMapperImpl.removeCommentLines(expressValue.toSourceCode());
                    objectMapper = new ObjectMapper();
                    try {
                        objectMap = (Map)objectMapper.readValue(sourceCode, Map.class);
                        MetaInfoMapperImpl.setResponseExamples(resMetaInfoBuilder, objectMap, ballerinFilePath, (Location)expressValue.location());
                    }
                    catch (JsonProcessingException e) {
                        messages = DiagnosticMessages.OAS_CONVERTOR_130;
                        diagnostic = new ExceptionDiagnostic(messages, (Location)mapNode.location(), new String[0]);
                        diagnostics.add(diagnostic);
                    }
                    continue;
                }
                if (!fName.equals("requestBody") || (optExamplesValue = resultField1.valueExpr()).isEmpty()) continue;
                expressValue = (ExpressionNode)optExamplesValue.get();
                String mediaType = MetaInfoMapperImpl.removeCommentLines(expressValue.toSourceCode());
                objectMapper = new ObjectMapper();
                try {
                    objectMap = (Map)objectMapper.readValue(mediaType, Map.class);
                    MetaInfoMapperImpl.setRequestExamples(resMetaInfoBuilder, objectMap, ballerinFilePath, (Location)expressValue.location());
                }
                catch (JsonProcessingException e) {
                    messages = DiagnosticMessages.OAS_CONVERTOR_130;
                    diagnostic = new ExceptionDiagnostic(messages, (Location)mapNode.location(), new String[0]);
                    diagnostics.add(diagnostic);
                }
            }
        }
    }

    private static void setResponseExamples(ResourceMetaInfoAnnotation.Builder resMetaInfoBuilder, Map<?, ?> objectMap, Path ballerinaFilePath, Location location) {
        if (objectMap instanceof LinkedHashMap) {
            LinkedHashMap responseSet = (LinkedHashMap)objectMap;
            HashMap<String, Map<String, Map<String, Object>>> responseExamples = new HashMap<String, Map<String, Map<String, Object>>>();
            for (Map.Entry statusCodeValuePair : responseSet.entrySet()) {
                Object key = statusCodeValuePair.getKey();
                if (!(key instanceof String)) continue;
                String statusCode = key.toString().trim();
                Object valuePairForMediaType = statusCodeValuePair.getValue();
                if (!(valuePairForMediaType instanceof LinkedHashMap)) continue;
                LinkedHashMap responseMap = (LinkedHashMap)valuePairForMediaType;
                Set mediaTypeExampleEntries = responseMap.entrySet();
                for (Map.Entry entry : mediaTypeExampleEntries) {
                    if (!entry.getKey().equals("examples")) continue;
                    Map<String, Map<String, Object>> mediaTypeExampleMap = MetaInfoMapperImpl.extractExamples(entry.getValue(), ballerinaFilePath, location);
                    responseExamples.put(statusCode, mediaTypeExampleMap);
                }
            }
            resMetaInfoBuilder.responseExamples(responseExamples);
        }
    }

    private static void setRequestExamples(ResourceMetaInfoAnnotation.Builder resMetaInfoBuilder, Map<?, ?> objectMap, Path ballerinaFilePath, Location location) {
        Map<String, Map<String, Object>> mediaTypeExampleMap = MetaInfoMapperImpl.extractExamples(objectMap, ballerinaFilePath, location);
        resMetaInfoBuilder.requestExamples(mediaTypeExampleMap);
    }

    private static Map<String, Map<String, Object>> extractExamples(Object exampleValues, Path ballerinaFilePath, Location location) {
        HashMap<String, Map<String, Object>> mediaTypeExampleMap = new HashMap<String, Map<String, Object>>();
        if (exampleValues instanceof LinkedHashMap) {
            LinkedHashMap exampleValueMap = (LinkedHashMap)exampleValues;
            Set exampleSets = exampleValueMap.entrySet();
            for (Map.Entry valuePair : exampleSets) {
                String mediaType = valuePair.getKey().toString().trim();
                Object resExamples = valuePair.getValue();
                if (!(resExamples instanceof LinkedHashMap)) continue;
                LinkedHashMap resExampleMaps = (LinkedHashMap)resExamples;
                HashMap modifiedExample = new HashMap();
                for (Map.Entry example : resExampleMaps.entrySet()) {
                    String stringNode;
                    String jsonFilePath;
                    Path relativePath;
                    String exampleName = (String)example.getKey();
                    Object v = example.getValue();
                    if (!(v instanceof LinkedHashMap)) continue;
                    LinkedHashMap exampleValue = (LinkedHashMap)v;
                    if (!exampleValue.containsKey("value") && !exampleValue.containsKey("filePath")) break;
                    Object value = exampleValue.get("value");
                    if (value == null) {
                        value = exampleValue.get("filePath");
                    }
                    if (value instanceof LinkedHashMap) {
                        modifiedExample.put(exampleName, example.getValue());
                        continue;
                    }
                    if (!(value instanceof String) || (relativePath = MetaInfoMapperImpl.resolveExampleFilePath(ballerinaFilePath, jsonFilePath = (stringNode = (String)value).replaceAll("\"", "").trim(), location, exampleName)) == null) continue;
                    if (!Files.exists(relativePath, new LinkOption[0])) {
                        DiagnosticMessages messages = DiagnosticMessages.OAS_CONVERTOR_128;
                        ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(messages, location, jsonFilePath, exampleName);
                        diagnostics.add(diagnostic);
                        continue;
                    }
                    try {
                        String content = Files.readString(relativePath);
                        ObjectMapper objectMapper = new ObjectMapper();
                        Map objectMap = (Map)objectMapper.readValue(content, Map.class);
                        HashMap valueMap = new HashMap(objectMap);
                        modifiedExample.put(exampleName, valueMap);
                    }
                    catch (IOException e) {
                        DiagnosticMessages messages = DiagnosticMessages.OAS_CONVERTOR_130;
                        ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(messages, location, new String[0]);
                        diagnostics.add(diagnostic);
                    }
                }
                mediaTypeExampleMap.put(mediaType, modifiedExample);
            }
        }
        return mediaTypeExampleMap;
    }

    private static Path resolveExampleFilePath(Path ballerinaFilePath, String jsonFilePath, Location location, String exampleName) {
        if (jsonFilePath.isBlank()) {
            DiagnosticMessages messages = DiagnosticMessages.OAS_CONVERTOR_131;
            ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(messages, location, exampleName);
            diagnostics.add(diagnostic);
            return null;
        }
        if (!jsonFilePath.endsWith(".json")) {
            DiagnosticMessages messages = DiagnosticMessages.OAS_CONVERTOR_129;
            ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(messages, location, jsonFilePath, exampleName);
            diagnostics.add(diagnostic);
            return null;
        }
        Path path = java.nio.file.Paths.get(jsonFilePath, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        File file = new File(ballerinaFilePath.toString());
        File parentFolder = new File(file.getParent());
        File jsonFile = new File(parentFolder, jsonFilePath);
        try {
            return java.nio.file.Paths.get(jsonFile.getCanonicalPath(), new String[0]);
        }
        catch (IOException e) {
            DiagnosticMessages messages = DiagnosticMessages.OAS_CONVERTOR_128;
            ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(messages, location, jsonFilePath, exampleName);
            diagnostics.add(diagnostic);
            return null;
        }
    }

    private static void updateOASWithMetaData(Map<String, ResourceMetaInfoAnnotation> resourceMetaData, Paths paths) {
        if (paths != null) {
            paths.forEach((path, pathItem) -> {
                Operation operation;
                if (pathItem.getGet() != null) {
                    operation = pathItem.getGet();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setGet(operation);
                }
                if (pathItem.getPost() != null) {
                    operation = pathItem.getPost();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setPost(operation);
                }
                if (pathItem.getPut() != null) {
                    operation = pathItem.getPut();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setPut(operation);
                }
                if (pathItem.getDelete() != null) {
                    operation = pathItem.getDelete();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setDelete(operation);
                }
                if (pathItem.getPatch() != null) {
                    operation = pathItem.getPatch();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setPatch(operation);
                }
                if (pathItem.getOptions() != null) {
                    operation = pathItem.getOptions();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setOptions(operation);
                }
                if (pathItem.getHead() != null) {
                    operation = pathItem.getHead();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setHead(operation);
                }
                if (pathItem.getTrace() != null) {
                    operation = pathItem.getTrace();
                    MetaInfoMapperImpl.updateOASOperationWithMetaData(resourceMetaData, operation);
                    pathItem.setTrace(operation);
                }
            });
        }
    }

    private static void updateOASOperationWithMetaData(Map<String, ResourceMetaInfoAnnotation> resourceMetaData, Operation operation) {
        String operationId = operation.getOperationId();
        if (!resourceMetaData.isEmpty() && resourceMetaData.containsKey(operationId)) {
            ResourceMetaInfoAnnotation resourceMetaInfo = resourceMetaData.get(operationId);
            String userProvideOperationId = resourceMetaInfo.getOperationId();
            if (userProvideOperationId != null && !userProvideOperationId.isBlank()) {
                operation.setOperationId(userProvideOperationId);
            }
            if (resourceMetaInfo.getTags() != null && !resourceMetaInfo.getTags().isEmpty()) {
                operation.setTags(resourceMetaInfo.getTags());
            }
            if (resourceMetaInfo.getSummary() != null && !resourceMetaInfo.getSummary().isBlank()) {
                operation.setSummary(resourceMetaInfo.getSummary());
            }
            ApiResponses responses = operation.getResponses();
            Map<String, Map<String, Map<String, Object>>> responseExamples = resourceMetaInfo.getResponseExamples();
            for (Map.Entry response : responses.entrySet()) {
                String statusCode = (String)response.getKey();
                Map<String, Map<String, Object>> mediaTypeExampleMap = responseExamples.get(statusCode);
                if (mediaTypeExampleMap == null) continue;
                ApiResponse oasApiResponse = (ApiResponse)response.getValue();
                Content oasContent = oasApiResponse.getContent();
                for (Map.Entry<String, Map<String, Object>> entry : mediaTypeExampleMap.entrySet()) {
                    String mediaTypeKey = entry.getKey();
                    MediaType oasMediaType = (MediaType)oasContent.get((Object)mediaTypeKey);
                    if (oasMediaType == null) continue;
                    HashMap<String, Example> exampleMap = new HashMap<String, Example>();
                    Map<String, Object> examples = entry.getValue();
                    for (Map.Entry<String, Object> example : examples.entrySet()) {
                        Object value = example.getValue();
                        if (value instanceof LinkedHashMap) {
                            LinkedHashMap exampleValue = (LinkedHashMap)value;
                            value = exampleValue.get("value");
                        }
                        Example oasExample = new Example();
                        oasExample.setValue(value);
                        exampleMap.put(example.getKey(), oasExample);
                    }
                    oasMediaType.setExamples(exampleMap);
                    oasContent.put((Object)mediaTypeKey, (Object)oasMediaType);
                }
                oasApiResponse.setContent(oasContent);
                responses.put((Object)((String)response.getKey()), (Object)oasApiResponse);
            }
            operation.setResponses(responses);
            RequestBody requestBody = operation.getRequestBody();
            if (requestBody != null) {
                MetaInfoMapperImpl.updateRequestBodyExample(resourceMetaInfo, requestBody);
                operation.setRequestBody(requestBody);
            }
        }
    }

    private static void updateRequestBodyExample(ResourceMetaInfoAnnotation resourceMetaInfo, RequestBody requestBody) {
        Content requestBodyContent = requestBody.getContent();
        Map<String, Map<String, Object>> requestExamples = resourceMetaInfo.getRequestExamples();
        for (Map.Entry<String, Map<String, Object>> example : requestExamples.entrySet()) {
            MediaType oasMediaType = (MediaType)requestBodyContent.get((Object)example.getKey());
            if (oasMediaType == null) continue;
            HashMap<String, Example> exampleMap = new HashMap<String, Example>();
            for (Map.Entry<String, Object> exampleValuePair : example.getValue().entrySet()) {
                Object value = exampleValuePair.getValue();
                if (value instanceof LinkedHashMap) {
                    LinkedHashMap exampleValue = (LinkedHashMap)value;
                    value = exampleValue.get("value");
                }
                Example oasExample = new Example();
                oasExample.setValue(value);
                exampleMap.put(exampleValuePair.getKey(), oasExample);
            }
            oasMediaType.setExamples(exampleMap);
            requestBodyContent.put((Object)example.getKey().trim(), (Object)oasMediaType);
        }
        requestBody.setContent(requestBodyContent);
    }

    private static List<String> extractListItems(ListConstructorExpressionNode list) {
        SeparatedNodeList expressions = list.expressions();
        Iterator iterator = expressions.iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (iterator.hasNext()) {
            Node item = (Node)iterator.next();
            if (item.kind() != SyntaxKind.STRING_LITERAL || item.toString().isBlank()) continue;
            Token stringItem = ((BasicLiteralNode)item).literalToken();
            String text = stringItem.text();
            text = text.length() > 1 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"' ? text.substring(1, text.length() - 1) : text.substring(1);
            values.add(text);
        }
        return values;
    }

    public static String removeCommentLines(String content) {
        String regex = "(?m)^\\s*(//|#).*|(?m)\\s*//.*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        content = matcher.replaceAll("");
        regex = "(?m)^(.*?)(//|#).*?$";
        pattern = Pattern.compile(regex);
        matcher = pattern.matcher(content);
        return matcher.replaceAll("$1");
    }
}

