/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.List;
import java.util.Optional;

public class OASResult {
    private OpenAPI openAPI;
    private String serviceName;
    private final List<OpenAPIMapperDiagnostic> diagnostics;

    public OASResult(OpenAPI openAPI, List<OpenAPIMapperDiagnostic> diagnostics) {
        this.openAPI = openAPI;
        this.diagnostics = diagnostics;
    }

    public List<OpenAPIMapperDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public Optional<OpenAPI> getOpenAPI() {
        return Optional.ofNullable(this.openAPI);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Optional<String> getYaml() {
        return Optional.ofNullable(Yaml.pretty((Object)this.openAPI));
    }

    public Optional<String> getJson() {
        return Optional.ofNullable(Json.pretty((Object)this.openAPI));
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setOpenAPI(OpenAPI openAPI) {
        this.openAPI = openAPI;
    }
}

