/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.parameter;

import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.parameter.AbstractParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapperException;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.util.Map;

public class PathParameterMapper
extends AbstractParameterMapper {
    private final TypeSymbol type;
    private final String name;
    private final String description;
    private final TypeMapper typeMapper;
    private final Location location;
    private final PathSegment.Kind pathSegmentKind;

    public PathParameterMapper(PathParameterSymbol pathParameterSymbol, Map<String, String> apiDocs, OperationInventory operationInventory, TypeMapper typeMapper) {
        super(operationInventory);
        this.location = pathParameterSymbol.getLocation().orElse(null);
        this.pathSegmentKind = pathParameterSymbol.pathSegmentKind();
        this.type = pathParameterSymbol.typeDescriptor();
        this.typeMapper = typeMapper;
        this.name = MapperCommonUtils.unescapeIdentifier((String)pathParameterSymbol.getName().get());
        this.description = apiDocs.get(pathParameterSymbol.getName().get());
    }

    public PathParameter getParameterSchema() throws ParameterMapperException {
        if (this.pathSegmentKind.equals((Object)PathSegment.Kind.PATH_REST_PARAMETER)) {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_125, this.location, this.name);
            throw new ParameterMapperException(error);
        }
        PathParameter pathParameter = new PathParameter();
        pathParameter.setName(this.name);
        pathParameter.setRequired(Boolean.valueOf(true));
        pathParameter.setSchema(this.typeMapper.getTypeSchema(this.type));
        pathParameter.setDescription(this.description);
        return pathParameter;
    }
}

