/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Objects;

public class ReadOnlyTypeMapper
extends AbstractTypeMapper {
    public ReadOnlyTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        super(typeSymbol, additionalData);
    }

    @Override
    public Schema getReferenceSchema(Components components) {
        IntersectionTypeSymbol referredType = (IntersectionTypeSymbol)this.typeSymbol.typeDescriptor();
        Schema effectiveTypeSchema = ReadOnlyTypeMapper.getSchema(referredType, components, this.additionalData);
        return Objects.nonNull(effectiveTypeSchema) ? effectiveTypeSchema.description(this.description) : null;
    }

    public static Schema getSchema(IntersectionTypeSymbol typeSymbol, Components components, AdditionalData additionalData) {
        TypeSymbol effectiveType = ReadOnlyTypeMapper.getEffectiveType(typeSymbol);
        if (Objects.isNull(effectiveType)) {
            return null;
        }
        return TypeMapperImpl.getTypeSchema(effectiveType, components, additionalData);
    }

    public static TypeSymbol getEffectiveType(IntersectionTypeSymbol typeSymbol) {
        List memberTypes = typeSymbol.memberTypeDescriptors();
        if (memberTypes.size() == 2) {
            TypeSymbol firstMember = (TypeSymbol)memberTypes.get(0);
            TypeSymbol secondMember = (TypeSymbol)memberTypes.get(1);
            if (firstMember.typeKind().equals((Object)TypeDescKind.READONLY)) {
                return secondMember;
            }
            if (secondMember.typeKind().equals((Object)TypeDescKind.READONLY)) {
                return firstMember;
            }
        }
        return null;
    }
}

