/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.mockextension;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.observability.metrics.Counter;
import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.Gauge;
import io.ballerina.runtime.observability.metrics.Metric;
import io.ballerina.runtime.observability.metrics.PolledGauge;
import io.ballerina.stdlib.observe.mockextension.model.Metrics;
import io.ballerina.stdlib.observe.mockextension.model.MockCounter;
import io.ballerina.stdlib.observe.mockextension.model.MockGauge;
import io.ballerina.stdlib.observe.mockextension.model.MockPolledGauge;
import io.ballerina.stdlib.observe.mockextension.typeadapter.DurationTypeAdapter;
import java.time.Duration;

public class MetricsUtils {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Duration.class, (Object)new DurationTypeAdapter()).create();

    public static Object getMetrics() {
        Metric[] metricsList = DefaultMetricRegistry.getInstance().getAllMetrics();
        Metrics metrics = new Metrics();
        for (Metric metric : metricsList) {
            if (metric instanceof Counter) {
                Counter counter = (Counter)metric;
                MockCounter mockCounter = new MockCounter();
                mockCounter.setId(counter.getId());
                mockCounter.setValue(counter.getValue());
                metrics.addCounter(mockCounter);
                continue;
            }
            if (metric instanceof Gauge) {
                Gauge gauge = (Gauge)metric;
                MockGauge mockGauge = new MockGauge();
                mockGauge.setId(gauge.getId());
                mockGauge.setValue(gauge.getValue());
                mockGauge.setCount(gauge.getCount());
                mockGauge.setSum(gauge.getSum());
                mockGauge.setSnapshots(gauge.getSnapshots());
                metrics.addGauge(mockGauge);
                continue;
            }
            if (!(metric instanceof PolledGauge)) continue;
            PolledGauge polledGauge = (PolledGauge)metric;
            MockPolledGauge mockPolledGauge = new MockPolledGauge();
            mockPolledGauge.setId(polledGauge.getId());
            mockPolledGauge.setValue(polledGauge.getValue());
            metrics.addPolledGauge(mockPolledGauge);
        }
        return JsonUtils.parse((String)gson.toJson((Object)metrics));
    }
}

