/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.cli;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.formatter.cli.Messages;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.FormatterUtils;
import org.ballerinalang.formatter.core.options.FormattingOptions;

final class FormatUtil {
    static final String CMD_NAME = "format";
    private static final PrintStream outStream = System.err;

    private FormatUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void execute(List<String> argList, boolean helpFlag, String moduleName, String fileName, boolean dryRun, Path sourceRootPath) {
        if (helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)CMD_NAME);
            outStream.println(commandUsageInfo);
            return;
        }
        if (moduleName != null && fileName != null) {
            throw LauncherUtils.createLauncherException((String)Messages.getCantAllowBothModuleAndFileOptions());
        }
        if (argList != null && argList.size() > 1) {
            throw LauncherUtils.createLauncherException((String)Messages.getArgumentError());
        }
        try {
            FormattingOptions options;
            BuildProject project;
            if (argList != null && !argList.isEmpty() && !argList.get(0).equals(".")) {
                FormattingOptions options2;
                BuildProject project2;
                if (FormatUtil.isBalFile(argList.get(0))) {
                    SingleFileProject project3;
                    if (moduleName != null || fileName != null) {
                        throw LauncherUtils.createLauncherException((String)Messages.getCantAllowModuleOrFileOptions());
                    }
                    String ballerinaFilePath = argList.get(0);
                    Path filePath = Path.of(ballerinaFilePath, new String[0]);
                    try {
                        project3 = SingleFileProject.load((Path)filePath, (BuildOptions)FormatUtil.constructBuildOptions());
                    }
                    catch (ProjectException e) {
                        throw LauncherUtils.createLauncherException((String)e.getMessage());
                    }
                    String source = Files.readString(project3.sourceRoot());
                    String formattedSourceCode = Formatter.format((String)source);
                    if (FormatUtil.areChangesAvailable(source, formattedSourceCode)) {
                        if (!dryRun) {
                            FormatUtil.writeFile(filePath.toAbsolutePath().toString(), formattedSourceCode);
                            outStream.println(Messages.getModifiedFiles() + System.lineSeparator() + ballerinaFilePath);
                            outStream.println(System.lineSeparator() + Messages.getSuccessMessage());
                            return;
                        } else {
                            outStream.println(Messages.getFilesToModify() + System.lineSeparator() + ballerinaFilePath);
                        }
                        return;
                    } else {
                        outStream.println(Messages.getNoChanges());
                    }
                    return;
                }
                if (Path.of(argList.get(0), new String[0]).toFile().isFile()) {
                    throw LauncherUtils.createLauncherException((String)Messages.getNotABallerinaFile());
                }
                Path projectPath = sourceRootPath.resolve(argList.get(0));
                try {
                    project2 = BuildProject.load((Path)projectPath, (BuildOptions)FormatUtil.constructBuildOptions());
                    options2 = FormatterUtils.buildFormattingOptions((BuildProject)project2);
                }
                catch (ProjectException e) {
                    throw LauncherUtils.createLauncherException((String)e.getMessage());
                }
                ArrayList<String> formattedFiles = new ArrayList<String>();
                if (moduleName != null) {
                    if (FormatUtil.isModuleExist(project2, moduleName) == null) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNoModuleFound(moduleName));
                    }
                    Module moduleToBeFormatted = project2.currentPackage().module(FormatUtil.isModuleExist(project2, moduleName));
                    try {
                        formattedFiles.addAll(FormatUtil.iterateAndFormat(FormatUtil.getDocumentPaths(project2, moduleToBeFormatted.moduleId()), sourceRootPath, options2, dryRun));
                    }
                    catch (IOException | FormatterException e) {
                        throw LauncherUtils.createLauncherException((String)(Messages.getException() + String.valueOf(e)));
                    }
                    FormatUtil.generateChangeReport(formattedFiles, dryRun);
                    return;
                }
                if (fileName != null) {
                    String formattedSourceCode;
                    if (!FormatUtil.isBalFile(fileName)) throw LauncherUtils.createLauncherException((String)Messages.getNotABallerinaFile());
                    Path filePath = projectPath.resolve(fileName);
                    if (!filePath.toFile().exists() || filePath.toFile().isDirectory()) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNoBallerinaFile(fileName));
                    }
                    String source = Files.readString(filePath);
                    if (FormatUtil.areChangesAvailable(source, formattedSourceCode = Formatter.format((String)source))) {
                        if (!dryRun) {
                            FormatUtil.writeFile(filePath.toAbsolutePath().toString(), formattedSourceCode);
                            outStream.println(Messages.getModifiedFiles() + System.lineSeparator() + fileName);
                            outStream.println(System.lineSeparator() + Messages.getSuccessMessage());
                            return;
                        } else {
                            outStream.println(Messages.getFilesToModify() + System.lineSeparator() + fileName);
                        }
                        return;
                    } else {
                        outStream.println(Messages.getNoChanges());
                    }
                    return;
                } else {
                    project2.currentPackage().moduleIds().forEach(moduleId -> {
                        try {
                            formattedFiles.addAll(FormatUtil.iterateAndFormat(FormatUtil.getDocumentPaths(project2, moduleId), sourceRootPath, options2, dryRun));
                        }
                        catch (IOException | FormatterException e) {
                            throw LauncherUtils.createLauncherException((String)(Messages.getException() + String.valueOf(e)));
                        }
                    });
                    FormatUtil.generateChangeReport(formattedFiles, dryRun);
                }
                return;
            }
            try {
                project = BuildProject.load((Path)sourceRootPath, (BuildOptions)FormatUtil.constructBuildOptions());
                options = FormatterUtils.buildFormattingOptions((BuildProject)project);
            }
            catch (ProjectException e) {
                throw LauncherUtils.createLauncherException((String)e.getMessage());
            }
            ArrayList<String> formattedFiles = new ArrayList<String>();
            if (moduleName != null) {
                if (FormatUtil.isModuleExist(project, moduleName) == null) {
                    throw LauncherUtils.createLauncherException((String)Messages.getNoModuleFound(moduleName));
                }
                Module moduleToBeFormatted = project.currentPackage().module(FormatUtil.isModuleExist(project, moduleName));
                try {
                    formattedFiles.addAll(FormatUtil.iterateAndFormat(FormatUtil.getDocumentPaths(project, moduleToBeFormatted.moduleId()), sourceRootPath, options, dryRun));
                }
                catch (IOException | FormatterException e) {
                    throw LauncherUtils.createLauncherException((String)(Messages.getException() + String.valueOf(e)));
                }
                FormatUtil.generateChangeReport(formattedFiles, dryRun);
                return;
            }
            if (fileName != null) {
                String formattedSourceCode;
                if (!FormatUtil.isBalFile(fileName)) throw LauncherUtils.createLauncherException((String)Messages.getNotABallerinaFile());
                Path filePath = sourceRootPath.resolve(fileName);
                if (!filePath.toFile().exists() || filePath.toFile().isDirectory()) {
                    throw LauncherUtils.createLauncherException((String)Messages.getNoBallerinaFile(fileName));
                }
                String source = Files.readString(filePath);
                if (FormatUtil.areChangesAvailable(source, formattedSourceCode = Formatter.format((String)source))) {
                    if (!dryRun) {
                        FormatUtil.writeFile(filePath.toAbsolutePath().toString(), formattedSourceCode);
                        outStream.println(Messages.getModifiedFiles() + System.lineSeparator() + fileName);
                        outStream.println(System.lineSeparator() + Messages.getSuccessMessage());
                        return;
                    } else {
                        outStream.println(Messages.getFilesToModify() + System.lineSeparator() + fileName);
                    }
                    return;
                } else {
                    outStream.println(Messages.getNoChanges());
                }
                return;
            } else {
                project.currentPackage().moduleIds().forEach(moduleId -> {
                    try {
                        formattedFiles.addAll(FormatUtil.iterateAndFormat(FormatUtil.getDocumentPaths(project, moduleId), sourceRootPath, options, dryRun));
                    }
                    catch (IOException | FormatterException e) {
                        throw LauncherUtils.createLauncherException((String)(Messages.getException() + String.valueOf(e)));
                    }
                });
                FormatUtil.generateChangeReport(formattedFiles, dryRun);
            }
            return;
        }
        catch (IOException | NullPointerException e) {
            throw LauncherUtils.createLauncherException((String)(Messages.getException() + String.valueOf(e)));
        }
        catch (FormatterException e) {
            throw LauncherUtils.createLauncherException((String)(Messages.getException() + e.getMessage()));
        }
    }

    private static List<Path> getDocumentPaths(BuildProject project, ModuleId moduleId) {
        ArrayList<Path> documentPaths = new ArrayList<Path>();
        Module module = project.currentPackage().module(moduleId);
        ArrayList documentIds = new ArrayList();
        documentIds.addAll(module.documentIds());
        documentIds.addAll(module.testDocumentIds());
        documentIds.forEach(documentId -> {
            if (project.documentPath(documentId).isPresent()) {
                documentPaths.add((Path)project.documentPath(documentId).get());
            }
        });
        return documentPaths;
    }

    private static void generateChangeReport(List<String> formattedFiles, boolean dryRun) {
        if (!formattedFiles.isEmpty()) {
            StringBuilder fileList = new StringBuilder();
            if (dryRun) {
                fileList.append(Messages.getFilesToModify()).append(System.lineSeparator());
            } else {
                fileList.append(Messages.getModifiedFiles()).append(System.lineSeparator());
            }
            for (String file : formattedFiles) {
                fileList.append(file).append(System.lineSeparator());
            }
            outStream.println(fileList.toString());
            if (!dryRun) {
                outStream.println(Messages.getSuccessMessage());
            }
        } else {
            outStream.println(Messages.getNoChanges());
        }
    }

    private static void formatAndWrite(Path documentPath, Path sourceRootPath, List<String> formattedFiles, FormattingOptions options, boolean dryRun) throws IOException, FormatterException {
        String formattedSource;
        String fileName = Path.of(sourceRootPath.toString(), new String[0]).resolve("modules").resolve(documentPath).toString();
        String originalSource = Files.readString(Path.of(fileName, new String[0]));
        if (FormatUtil.areChangesAvailable(originalSource, formattedSource = Formatter.format((String)originalSource, (FormattingOptions)options))) {
            if (!dryRun) {
                FormatUtil.writeFile(fileName, formattedSource);
            }
            formattedFiles.add(fileName);
        }
    }

    private static List<String> iterateAndFormat(List<Path> documentPaths, Path sourceRootPath, FormattingOptions options, boolean dryRun) throws IOException, FormatterException {
        ArrayList<String> formattedFiles = new ArrayList<String>();
        for (Path path : documentPaths) {
            FormatUtil.formatAndWrite(path, sourceRootPath, formattedFiles, options, dryRun);
        }
        return formattedFiles;
    }

    private static BuildOptions constructBuildOptions() {
        return BuildOptions.builder().setCodeCoverage(Boolean.valueOf(false)).setExperimental(Boolean.valueOf(true)).setOffline(Boolean.valueOf(false)).setSkipTests(Boolean.valueOf(false)).setTestReport(Boolean.valueOf(false)).setObservabilityIncluded(Boolean.valueOf(false)).build();
    }

    private static ModuleId isModuleExist(BuildProject project, String moduleNamePart) {
        ModuleName moduleName = ModuleName.from((PackageName)project.currentPackage().packageName(), (String)moduleNamePart);
        for (Module module : project.currentPackage().modules()) {
            if (!module.moduleName().equals((Object)moduleName)) continue;
            return module.moduleId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String filePath, String content) throws IOException {
        OutputStreamWriter fileWriter = null;
        FileOutputStream fileStream = null;
        try {
            File newFile = new File(filePath);
            fileStream = new FileOutputStream(newFile);
            fileWriter = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);
            fileWriter.write(content);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }

    private static boolean areChangesAvailable(String originalSource, String formattedSource) {
        return !originalSource.equals(formattedSource);
    }

    private static boolean isBalFile(String fileName) {
        return fileName.endsWith(".bal");
    }

    static class EmptyPrintStream
    extends PrintStream {
        EmptyPrintStream() throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true, "UTF-8");
        }
    }
}

