/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.cli;

public final class Messages {
    private static final String ARGUMENT_ERROR = "too many arguments." + System.lineSeparator() + "usage: only one argument, either a ballerina file name or a module name, can be applied at a time with or without the option." + System.lineSeparator() + "i.e: bal format [ballerinaFile | ModuleName] [-d | --dry-run]" + System.lineSeparator() + System.lineSeparator() + "run `bal format -h` for more details.";
    private static final String SUCCESS_MESSAGE = "format successful.";
    private static final String NOT_BALLERINA_PROJECT = "not a valid Ballerina project." + System.lineSeparator() + "usage: bal format should be run inside a ballerina project or pass in a ballerina file." + System.lineSeparator() + "i.e. `bal format <ballerina-file>`" + System.lineSeparator() + System.lineSeparator() + "run `bal format -h` for more details";
    private static final String NO_MODULE_FOUND = "couldn't find an existing module by the name: ";
    private static final String EXCEPTION = "formatting failed - ";
    private static final String NO_BALLERINA_FILE = "couldn't find an existing ballerina file by the name: ";
    private static final String NOT_BALLERINA_FILE = "not a valid ballerina source file." + System.lineSeparator() + "usage: ballerina source files should have the file extension as `.bal`." + System.lineSeparator() + "i.e. `bal format hello.bal`";
    private static final String NO_BALLERINA_FILE_OR_MODULE = "couldn't find an existing ballerina file or module by the name: ";
    private static final String CANT_ALLOW_BOTH_MODULE_AND_FILE_OPTIONS = "using '--module' and '--file' options at the same time is not allowed in selective formatting.";
    private static final String CANT_ALLOW_MODULE_OR_FILE_OPTIONS = "the '--module' and '--file' options are not allowed in single file projects";
    private static final String NO_CHANGES = "no changes.";
    private static final String FILES_TO_MODIFY = "files to be modified:";
    private static final String MODIFIED_FILES = "modified files:";

    private Messages() {
    }

    static String getArgumentError() {
        return ARGUMENT_ERROR;
    }

    static String getSuccessMessage() {
        return SUCCESS_MESSAGE;
    }

    static String getNotBallerinaProject() {
        return NOT_BALLERINA_PROJECT;
    }

    static String getNoModuleFound(String moduleName) {
        return NO_MODULE_FOUND + moduleName;
    }

    static String getException() {
        return EXCEPTION;
    }

    static String getNoBallerinaFile(String fileName) {
        return NO_BALLERINA_FILE + fileName;
    }

    static String getNoBallerinaModuleOrFile(String fileName) {
        return NO_BALLERINA_FILE_OR_MODULE + fileName;
    }

    static String getCantAllowBothModuleAndFileOptions() {
        return CANT_ALLOW_BOTH_MODULE_AND_FILE_OPTIONS;
    }

    static String getCantAllowModuleOrFileOptions() {
        return CANT_ALLOW_MODULE_OR_FILE_OPTIONS;
    }

    static String getNotABallerinaFile() {
        return NOT_BALLERINA_FILE;
    }

    static String getNoChanges() {
        return NO_CHANGES;
    }

    static String getFilesToModify() {
        return FILES_TO_MODIFY;
    }

    static String getModifiedFiles() {
        return MODIFIED_FILES;
    }
}

