/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.log.compiler.staticcodeanalyzer;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.ChildNodeEntry;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.InterpolationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.log.compiler.staticcodeanalyzer.LogRule;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LogStatementAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public static final String CONFIGURABLE_QUALIFIER = "CONFIGURABLE";
    public static final String LOG_MODULE = "log";
    public static final String BALLERINA_ORG = "ballerina";
    final List<String> logFunctions = Arrays.asList("printInfo", "printError", "printWarn");
    List<SemanticModel> semanticModels = new ArrayList<SemanticModel>();
    private final Reporter reporter;

    public LogStatementAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        if (this.semanticModels.isEmpty()) {
            context.currentPackage().modules().forEach(module -> {
                SemanticModel semanticModel = module.getCompilation().getSemanticModel();
                this.semanticModels.add(semanticModel);
            });
        }
        Document document = context.currentPackage().module(context.moduleId()).document(context.documentId());
        List<Object> importPrefix = new ArrayList();
        Node node2 = document.syntaxTree().rootNode();
        if (node2 instanceof ModulePartNode) {
            ModulePartNode modulePartNode = (ModulePartNode)node2;
            importPrefix = modulePartNode.imports().stream().filter(importDeclarationNode -> {
                ImportOrgNameNode importOrgNameNode = importDeclarationNode.orgName().orElse(null);
                return importOrgNameNode != null && BALLERINA_ORG.equals(importOrgNameNode.orgName().text());
            }).filter(importDeclarationNode -> importDeclarationNode.moduleName().stream().anyMatch(moduleNameNode -> LOG_MODULE.equals(moduleNameNode.text()))).map(importDeclarationNode -> {
                ImportPrefixNode importPrefixNode = importDeclarationNode.prefix().orElse(null);
                return importPrefixNode != null ? importPrefixNode.prefix().text() : LOG_MODULE;
            }).toList();
        }
        if ((node2 = context.node()) instanceof ExpressionStatementNode) {
            QualifiedNameReferenceNode qualifiedNameReferenceNode;
            ExpressionStatementNode expressionStatementNode = (ExpressionStatementNode)node2;
            List childlist = expressionStatementNode.expression().childEntries().stream().toList();
            if (childlist.size() < 4) {
                return;
            }
            Node firstChild = ((ChildNodeEntry)childlist.getFirst()).node().orElse(null);
            if (firstChild instanceof QualifiedNameReferenceNode && importPrefix.contains((qualifiedNameReferenceNode = (QualifiedNameReferenceNode)firstChild).modulePrefix().text()) && this.logFunctions.contains(qualifiedNameReferenceNode.identifier().text())) {
                NodeList logArgumentNodeList = ((ChildNodeEntry)childlist.get(2)).nodeList();
                List<Node> list = logArgumentNodeList.stream().filter(node -> node instanceof PositionalArgumentNode || node instanceof NamedArgumentNode).toList();
                for (Node node3 : list) {
                    if (node3 instanceof PositionalArgumentNode) {
                        PositionalArgumentNode positionalArgumentNode = (PositionalArgumentNode)node3;
                        positionalArgumentNode.childEntries().forEach(childNodeEntry -> {
                            Node expression = childNodeEntry.node().orElse(null);
                            if (expression instanceof SimpleNameReferenceNode) {
                                SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)expression;
                                this.checkConfigurableQualifier((ExpressionNode)simpleNameReferenceNode, document);
                            } else if (expression instanceof TemplateExpressionNode) {
                                TemplateExpressionNode templateExpressionNode = (TemplateExpressionNode)expression;
                                templateExpressionNode.content().forEach(content -> {
                                    if (content instanceof InterpolationNode) {
                                        InterpolationNode interpolationNode = (InterpolationNode)content;
                                        interpolationNode.childEntries().forEach(interpolationChild -> {
                                            Node interpolationExpression = interpolationChild.node().orElse(null);
                                            if (interpolationExpression instanceof SimpleNameReferenceNode) {
                                                SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)interpolationExpression;
                                                this.checkConfigurableQualifier((ExpressionNode)simpleNameReferenceNode, document);
                                            }
                                        });
                                    }
                                });
                            } else if (expression instanceof BinaryExpressionNode) {
                                BinaryExpressionNode binaryExpressionNode = (BinaryExpressionNode)expression;
                                binaryExpressionNode.childEntries().forEach(childEntry -> {
                                    Node childNode = childEntry.node().orElse(null);
                                    if (childNode instanceof SimpleNameReferenceNode) {
                                        SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)childNode;
                                        this.checkConfigurableQualifier((ExpressionNode)simpleNameReferenceNode, document);
                                    }
                                });
                            }
                        });
                        continue;
                    }
                    if (!(node3 instanceof NamedArgumentNode)) continue;
                    NamedArgumentNode namedArgumentNode = (NamedArgumentNode)node3;
                    this.checkConfigurableQualifier(namedArgumentNode.expression(), document);
                }
            }
        }
    }

    private void checkConfigurableQualifier(ExpressionNode argumentNode, Document document) {
        this.semanticModels.forEach(semanticModel -> {
            Symbol symbol = semanticModel.symbol((Node)argumentNode).orElse(null);
            if (symbol instanceof VariableSymbol) {
                VariableSymbol variableSymbol = (VariableSymbol)symbol;
                variableSymbol.qualifiers().stream().filter(qualifier -> qualifier.toString().equals(CONFIGURABLE_QUALIFIER)).forEach(qualifier -> this.reporter.reportIssue(document, (Location)argumentNode.location(), LogRule.AVOID_LOGGING_CONFIGURABLE_VARIABLES.getId()));
            }
        });
    }
}

