/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro;

import io.ballerina.lib.avro.ModuleUtils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;

public final class Utils {
    public static final String AVRO_SCHEMA = "avroSchema";
    public static final String ERROR_TYPE = "Error";
    public static final String SERIALIZATION_ERROR = "Avro serialization error";
    public static final String DESERIALIZATION_ERROR = "Avro deserialization error";

    private Utils() {
    }

    public static BError createError(String message, Throwable throwable) {
        BError cause = ErrorCreator.createError((Throwable)throwable);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR_TYPE, (BString)StringUtils.fromString((String)message), (BError)cause, null);
    }

    public static Type getMutableType(Type dataType) {
        if (dataType.getTag() != 34) {
            return dataType;
        }
        IntersectionType intersectionType = (IntersectionType)dataType;
        for (Type type : intersectionType.getConstituentTypes()) {
            Type referredType = TypeUtils.getImpliedType((Type)type);
            if (TypeUtils.getImpliedType((Type)intersectionType.getEffectiveType()).getTag() != referredType.getTag()) continue;
            return referredType;
        }
        throw new IllegalStateException("Unsupported intersection type found.");
    }
}

