/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.deserialize.visitor;

import io.ballerina.lib.avro.Utils;
import io.ballerina.lib.avro.deserialize.ArrayDeserializer;
import io.ballerina.lib.avro.deserialize.Deserializer;
import io.ballerina.lib.avro.deserialize.visitor.DeserializeVisitor;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public class DeserializeArrayVisitor
extends DeserializeVisitor {
    @Override
    public Object visit(ArrayDeserializer arrayDeserializer, GenericData.Array<Object> data) throws Exception {
        Object[] objects = new Object[data.size()];
        boolean isReadOnly = arrayDeserializer.getType().getTag() == 34;
        Type elementType = ((ArrayType)Utils.getMutableType(arrayDeserializer.getType())).getElementType();
        int index = 0;
        for (Object element : data) {
            GenericData.Array dataArray = (GenericData.Array)element;
            Type arrType = elementType.getTag() == 32 ? elementType : arrayDeserializer.getType();
            Schema elementSchema = arrayDeserializer.getSchema().getElementType();
            objects[index++] = this.visitNestedArray(new ArrayDeserializer(arrType, elementSchema), (GenericData.Array<Object>)dataArray);
        }
        BArray arrayValue = ValueCreator.createArrayValue((Object[])objects, (ArrayType)((ArrayType)Utils.getMutableType(arrayDeserializer.getType())));
        if (isReadOnly) {
            arrayValue.freezeDirect();
        }
        return arrayValue;
    }

    public Object visitNestedArray(ArrayDeserializer arrayDeserializer, GenericData.Array<Object> data) throws Exception {
        Deserializer deserializer = DeserializeArrayVisitor.createDeserializer(arrayDeserializer.getSchema(), arrayDeserializer.getType());
        return deserializer.accept((DeserializeVisitor)this, data);
    }
}

