/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.serialize;

import io.ballerina.lib.avro.serialize.ArraySerializer;
import io.ballerina.lib.avro.serialize.ByteSerializer;
import io.ballerina.lib.avro.serialize.EnumSerializer;
import io.ballerina.lib.avro.serialize.FixedSerializer;
import io.ballerina.lib.avro.serialize.MapSerializer;
import io.ballerina.lib.avro.serialize.PrimitiveSerializer;
import io.ballerina.lib.avro.serialize.RecordSerializer;
import io.ballerina.lib.avro.serialize.Serializer;
import org.apache.avro.Schema;

public class MessageFactory {
    public static Serializer createMessage(Schema schema) {
        return switch (schema.getType()) {
            case Schema.Type.ARRAY -> new ArraySerializer(schema);
            case Schema.Type.FIXED -> new FixedSerializer(schema);
            case Schema.Type.ENUM -> new EnumSerializer(schema);
            case Schema.Type.MAP -> new MapSerializer(schema);
            case Schema.Type.RECORD -> new RecordSerializer(schema);
            case Schema.Type.BYTES -> new ByteSerializer();
            default -> new PrimitiveSerializer(schema);
        };
    }
}

