/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.serialize.visitor;

import io.ballerina.lib.avro.serialize.ArraySerializer;
import io.ballerina.lib.avro.serialize.EnumSerializer;
import io.ballerina.lib.avro.serialize.FixedSerializer;
import io.ballerina.lib.avro.serialize.MapSerializer;
import io.ballerina.lib.avro.serialize.MessageFactory;
import io.ballerina.lib.avro.serialize.PrimitiveSerializer;
import io.ballerina.lib.avro.serialize.RecordSerializer;
import io.ballerina.lib.avro.serialize.Serializer;
import io.ballerina.lib.avro.serialize.UnionSerializer;
import io.ballerina.lib.avro.serialize.visitor.ISerializeVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.ArrayVisitorFactory;
import io.ballerina.lib.avro.serialize.visitor.array.IArrayVisitor;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public class SerializeVisitor
implements ISerializeVisitor {
    public Serializer createSerializer(Schema schema) {
        return switch (schema.getValueType().getType()) {
            case Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.BOOLEAN, Schema.Type.STRING, Schema.Type.BYTES -> new PrimitiveSerializer(schema.getValueType());
            case Schema.Type.RECORD -> new RecordSerializer(schema.getValueType());
            case Schema.Type.MAP -> new MapSerializer(schema.getValueType());
            case Schema.Type.ARRAY -> new ArraySerializer(schema.getValueType());
            case Schema.Type.ENUM -> new EnumSerializer(schema.getValueType());
            case Schema.Type.FIXED -> new FixedSerializer(schema.getValueType());
            default -> throw new IllegalArgumentException("Unsupported schema type: " + String.valueOf(schema.getValueType().getType()));
        };
    }

    @Override
    public GenericRecord visit(RecordSerializer recordSerializer, BMap<?, ?> data) throws Exception {
        GenericData.Record genericRecord = new GenericData.Record(recordSerializer.getSchema());
        for (Schema.Field field : recordSerializer.getSchema().getFields()) {
            Object fieldData = data.get((Object)StringUtils.fromString((String)field.name()));
            genericRecord.put(field.name(), this.serializeField(field.schema(), fieldData));
        }
        return genericRecord;
    }

    private Object serializeField(Schema schema, Object fieldData) throws Exception {
        Schema.Type type = schema.getType();
        return switch (type) {
            case Schema.Type.RECORD -> new RecordSerializer(schema).convert(this, fieldData);
            case Schema.Type.MAP -> new MapSerializer(schema).convert(this, fieldData);
            case Schema.Type.ARRAY -> new ArraySerializer(schema).convert(this, fieldData);
            case Schema.Type.ENUM -> new EnumSerializer(schema).convert(this, fieldData);
            case Schema.Type.UNION -> new UnionSerializer(schema).convert(this, fieldData);
            default -> new PrimitiveSerializer(schema).convert(this, fieldData);
        };
    }

    @Override
    public Object visit(PrimitiveSerializer primitiveSerializer, Object data) throws Exception {
        return switch (primitiveSerializer.getSchema().getType()) {
            case Schema.Type.INT -> {
                if (data instanceof Long) {
                    Long longValue = (Long)data;
                    yield longValue.intValue();
                }
                yield data;
            }
            case Schema.Type.FLOAT -> {
                if (data instanceof Double) {
                    Double doubleValue = (Double)data;
                    yield Float.valueOf(doubleValue.floatValue());
                }
                yield data;
            }
            case Schema.Type.DOUBLE -> {
                if (data instanceof Long) {
                    Long longValue = (Long)data;
                    yield longValue.doubleValue();
                }
                if (data instanceof BDecimal) {
                    BDecimal decimalValue = (BDecimal)data;
                    yield decimalValue.floatValue();
                }
                yield data;
            }
            case Schema.Type.BYTES -> {
                ByteBuffer byteBuffer = ByteBuffer.allocate(((BArray)data).getByteArray().length);
                byteBuffer.put(((BArray)data).getByteArray());
                byteBuffer.position(0);
                yield byteBuffer;
            }
            case Schema.Type.STRING -> data.toString();
            case Schema.Type.NULL -> {
                if (data != null) {
                    throw new Exception("The value does not match with the null schema");
                }
                yield null;
            }
            default -> data;
        };
    }

    public Map<String, Object> visit(MapSerializer mapSerializer, BMap<?, ?> data) throws Exception {
        HashMap<String, Object> avroMap = new HashMap<String, Object>();
        Schema schema = mapSerializer.getSchema();
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            for (Schema fieldSchema : schema.getTypes()) {
                if (!fieldSchema.getType().equals((Object)Schema.Type.MAP)) continue;
                schema = fieldSchema;
            }
        }
        for (Object value : data.getKeys()) {
            Serializer serializer = this.createSerializer(schema);
            avroMap.put(value.toString(), serializer.convert(this, data.get(value)));
        }
        return avroMap;
    }

    @Override
    public Object visit(EnumSerializer enumSerializer, Object data) {
        return new GenericData.EnumSymbol(enumSerializer.getSchema(), data);
    }

    @Override
    public GenericData.Fixed visit(FixedSerializer fixedSerializer, Object data) {
        return new GenericData.Fixed(fixedSerializer.getSchema(), ((BArray)data).getByteArray());
    }

    @Override
    public GenericData.Array<Object> visit(ArraySerializer arraySerializer, BArray data) {
        GenericData.Array array = new GenericData.Array(data.size(), arraySerializer.getSchema());
        IArrayVisitor visitor = ArrayVisitorFactory.createVisitor(arraySerializer.getSchema());
        return Objects.requireNonNull(visitor).visit(data, arraySerializer.getSchema(), (GenericData.Array<Object>)array);
    }

    public ArrayList<Integer> deriveBallerinaTag(Schema schema) {
        ArrayList<Integer> tags = new ArrayList<Integer>();
        switch (schema.getType()) {
            case STRING: 
            case ENUM: {
                tags.add(5);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                tags.add(3);
                tags.add(4);
                tags.add(1);
                break;
            }
            case INT: 
            case LONG: {
                tags.add(1);
                break;
            }
            case BOOLEAN: {
                tags.add(6);
                break;
            }
            case NULL: {
                tags.add(14);
                break;
            }
            case RECORD: {
                tags.add(24);
                break;
            }
            case ARRAY: {
                tags.add(32);
                break;
            }
            case MAP: {
                tags.add(27);
                break;
            }
            case BYTES: 
            case FIXED: {
                tags.add(2);
                tags.add(48);
                tags.add(32);
                break;
            }
            default: {
                tags.add(23);
            }
        }
        return tags;
    }

    public Object visit(UnionSerializer unionSerializer, Object data) throws Exception {
        Schema fieldSchema = unionSerializer.getSchema();
        Type typeName = TypeUtils.getType((Object)data);
        List types = fieldSchema.getTypes();
        for (Schema type : types) {
            ArrayList<Integer> tags = this.deriveBallerinaTag(type);
            if (!tags.contains(typeName.getTag())) continue;
            Serializer serializer = MessageFactory.createMessage(type);
            return Objects.requireNonNull(serializer).convert(this, data);
        }
        throw new Exception("Value does not match with the Avro union types");
    }
}

