/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.serialize.visitor.array;

import io.ballerina.lib.avro.serialize.visitor.array.IArrayVisitor;
import io.ballerina.runtime.api.values.BArray;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public class PrimitiveArrayVisitor
implements IArrayVisitor {
    @Override
    public GenericData.Array<Object> visit(BArray data, Schema schema, GenericData.Array<Object> array) {
        Schema.Type type = schema.getType().equals((Object)Schema.Type.ARRAY) ? schema.getElementType().getType() : schema.getType();
        switch (type) {
            case STRING: {
                array.addAll(Arrays.asList(data.getStringArray()));
                break;
            }
            case INT: {
                for (long obj : data.getIntArray()) {
                    array.add((Object)Long.valueOf(obj).intValue());
                }
                break;
            }
            case LONG: {
                long[] lArray = data.getIntArray();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long obj = lArray[i];
                    array.add((Object)obj);
                }
                break;
            }
            case FLOAT: {
                double[] dArray = data.getFloatArray();
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double obj = dArray[i];
                    array.add((Object)Float.valueOf(obj.floatValue()));
                }
                break;
            }
            case DOUBLE: {
                double[] dArray = data.getFloatArray();
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double obj = dArray[i];
                    array.add((Object)obj);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] blArray = data.getBooleanArray();
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    Boolean obj = blArray[i];
                    array.add((Object)obj);
                }
                break;
            }
            default: {
                PrimitiveArrayVisitor.visitBytes(data, array);
            }
        }
        return array;
    }

    public static GenericData.Array<Object> visitBytes(BArray data, GenericData.Array<Object> array) {
        Arrays.stream(data.getValues()).filter(Objects::nonNull).forEach(bytes -> {
            ByteBuffer byteBuffer = ByteBuffer.allocate(((BArray)bytes).getByteArray().length);
            byteBuffer.put(((BArray)bytes).getByteArray());
            byteBuffer.position(0);
            array.add((Object)byteBuffer);
        });
        return array;
    }
}

