/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.io;

import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class BallerinaByteBlockInputStream
extends InputStream {
    private final BObject iterator;
    private final Environment env;
    private final String nextMethodName;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final MethodType closeMethod;
    private final Consumer<Object> futureResultConsumer;
    private byte[] currentChunk = new byte[0];
    private int nextChunkIndex = 0;

    public BallerinaByteBlockInputStream(Environment env, BObject iterator, MethodType nextMethod, MethodType closeMethod, Consumer<Object> futureResultConsumer) {
        this.env = env;
        this.iterator = iterator;
        this.nextMethodName = nextMethod.getName();
        this.closeMethod = closeMethod;
        this.futureResultConsumer = futureResultConsumer;
    }

    @Override
    public int read() {
        if (this.done.get()) {
            return -1;
        }
        if (this.hasBytesInCurrentChunk()) {
            return this.currentChunk[this.nextChunkIndex++];
        }
        this.nextChunkIndex = 0;
        try {
            if (this.readNextChunk()) {
                return this.read();
            }
        }
        catch (InterruptedException e) {
            BError error = DiagnosticLog.getCsvError("Cannot read the stream, interrupted error");
            this.futureResultConsumer.accept((Object)error);
            return -1;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.closeMethod != null) {
            this.env.getRuntime().callMethod(this.iterator, this.closeMethod.getName(), null, new Object[0]);
        }
    }

    private boolean hasBytesInCurrentChunk() {
        return this.currentChunk.length != 0 && this.nextChunkIndex < this.currentChunk.length;
    }

    private boolean readNextChunk() throws InterruptedException {
        try {
            Object result = this.env.getRuntime().callMethod(this.iterator, this.nextMethodName, null, new Object[0]);
            if (result == null) {
                this.done.set(true);
                this.currentChunk = new byte[0];
                return !this.done.get();
            }
            if (result instanceof BMap) {
                BMap valueRecord = (BMap)result;
                BString value = Arrays.stream((BString[])valueRecord.getKeys()).findFirst().get();
                BArray arrayValue = valueRecord.getArrayValue(value);
                this.currentChunk = arrayValue.getByteArray();
            } else {
                this.done.set(true);
            }
        }
        catch (BError bError) {
            this.done.set(true);
            this.futureResultConsumer.accept((Object)bError);
            this.currentChunk = new byte[0];
        }
        return !this.done.get();
    }
}

