/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.io;

import io.ballerina.lib.data.csvdata.csv.CsvParser;
import io.ballerina.lib.data.csvdata.io.BallerinaByteBlockInputStream;
import io.ballerina.lib.data.csvdata.utils.CsvConfig;
import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class DataReaderTask
implements Runnable {
    private static final String METHOD_NAME_NEXT = "next";
    private static final String METHOD_NAME_CLOSE = "close";
    private final Environment env;
    private final BObject iteratorObj;
    private final CompletableFuture<Object> future;
    private final BTypedesc typed;
    private final CsvConfig config;
    private final BString encoding;

    public DataReaderTask(Environment env, BObject iteratorObj, CompletableFuture<Object> future, BTypedesc typed, CsvConfig config, BString encoding) {
        this.env = env;
        this.iteratorObj = iteratorObj;
        this.future = future;
        this.typed = typed;
        this.config = config;
        this.encoding = encoding;
    }

    static MethodType resolveNextMethod(BObject iterator) {
        MethodType method = DataReaderTask.getMethodType(iterator, METHOD_NAME_NEXT);
        if (method != null) {
            return method;
        }
        throw new IllegalStateException("next method not found in the iterator object");
    }

    static MethodType resolveCloseMethod(BObject iterator) {
        return DataReaderTask.getMethodType(iterator, METHOD_NAME_CLOSE);
    }

    private static MethodType getMethodType(BObject iterator, String methodNameClose) {
        MethodType[] methods;
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)iterator.getOriginalType());
        for (MethodType method : methods = objectType.getMethods()) {
            if (!method.getName().equals(methodNameClose)) continue;
            return method;
        }
        return null;
    }

    @Override
    public void run() {
        ResultConsumer<Object> resultConsumer = new ResultConsumer<Object>(this.future);
        try (BallerinaByteBlockInputStream byteBlockSteam = new BallerinaByteBlockInputStream(this.env, this.iteratorObj, DataReaderTask.resolveNextMethod(this.iteratorObj), DataReaderTask.resolveCloseMethod(this.iteratorObj), resultConsumer);){
            Object result = CsvParser.parse(new InputStreamReader((InputStream)byteBlockSteam, Charset.forName(this.encoding.toString())), this.typed, this.config);
            this.future.complete(result);
        }
        catch (Exception e) {
            this.future.complete((Object)DiagnosticLog.getCsvError("Error occurred while reading the stream: " + e.getMessage()));
        }
    }

    public record ResultConsumer<T>(CompletableFuture<Object> future) implements Consumer<T>
    {
        @Override
        public void accept(T t) {
            this.future.complete(t);
        }
    }
}

