/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.utils;

import io.ballerina.lib.data.csvdata.utils.Constants;
import io.ballerina.lib.data.csvdata.utils.CsvConfig;
import io.ballerina.lib.data.csvdata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class CsvUtils {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];

    public static void validateExpectedArraySize(int size, int currentSize) {
        if (size != -1 && size > currentSize) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_EXPECTED_ARRAY_SIZE, currentSize);
        }
    }

    public static boolean isExpectedTypeIsArray(Type expectedType) {
        expectedType = TypeUtils.getReferredType((Type)expectedType);
        return switch (expectedType.getTag()) {
            case 32, 44 -> true;
            default -> false;
        };
    }

    public static boolean isBasicType(Type type) {
        return switch (type.getTag()) {
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 23, 33, 34 -> true;
            default -> false;
        };
    }

    public static String[] createHeadersForParseLists(BArray csvElement, int headerSize, CsvConfig config) {
        String[] headers = new String[headerSize];
        Object customHeaders = config.customHeaders;
        long headerRows = config.headerRows;
        int length = headers.length;
        if (customHeaders instanceof BArray) {
            BArray array = (BArray)customHeaders;
            if (array.size() != length) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_CUSTOM_HEADER_LENGTH, new Object[0]);
            }
            for (int i = 0; i < length; ++i) {
                headers[i] = array.get((long)i).toString();
            }
            return headers;
        }
        if (headerRows == 1L) {
            return csvElement.getStringArray();
        }
        if (headerRows > 1L) {
            throw DiagnosticLog.error(DiagnosticErrorCode.NO_CUSTOM_HEADER_PROVIDED, new Object[0]);
        }
        for (int i = 0; i < length; ++i) {
            headers[i] = String.valueOf(i + 1);
        }
        return headers;
    }

    public static Optional<Type> getMutableType(IntersectionType intersectionType) {
        for (Type constituentType : intersectionType.getConstituentTypes()) {
            if (constituentType.getTag() == 51) continue;
            return Optional.of(constituentType);
        }
        return Optional.empty();
    }

    public static Object convertToBasicType(Object csv, Type targetType, CsvConfig config) {
        if (csv == null) {
            csv = config.nilValue;
        }
        return ValueUtils.convert((Object)csv, (Type)targetType);
    }

    public static void checkRequiredFieldsAndLogError(Map<String, Field> filedHierarchy, boolean absentAsNilableType) {
        filedHierarchy.values().forEach(field -> {
            if (absentAsNilableType && field.getFieldType().isNilable()) {
                return;
            }
            if (SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_FIELD_IN_CSV, field.getFieldName());
            }
        });
    }

    public static boolean isHeaderFieldsEmpty(Map<String, Field> currentField) {
        for (Field field : currentField.values()) {
            if (!SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTypeCompatibility(Type constraintType, Object csv, boolean stringConversion) {
        int tag = constraintType.getTag();
        if (csv instanceof BString) {
            return stringConversion || TypeTags.isStringTypeTag((int)tag) || CsvUtils.isJsonOrAnyDataOrAny(tag);
        }
        if (csv instanceof Long) {
            return TypeTags.isIntegerTypeTag((int)tag) || tag == 3 || tag == 4 || tag == 2 || CsvUtils.isJsonOrAnyDataOrAny(tag);
        }
        if (csv instanceof BDecimal && (tag == 4 || tag == 3 || TypeTags.isIntegerTypeTag((int)tag) || CsvUtils.isJsonOrAnyDataOrAny(tag))) {
            return true;
        }
        if (csv instanceof Double) {
            return tag == 3 || tag == 4 || TypeTags.isIntegerTypeTag((int)tag) || CsvUtils.isJsonOrAnyDataOrAny(tag);
        }
        if (csv instanceof Boolean) {
            return tag == 6 || CsvUtils.isJsonOrAnyDataOrAny(tag);
        }
        if (csv == null) {
            return tag == 14 || CsvUtils.isJsonOrAnyDataOrAny(tag);
        }
        return false;
    }

    private static boolean isJsonOrAnyDataOrAny(int tag) {
        return tag == 15 || tag == 23 || tag == 29;
    }

    public static int getTheExpectedArraySize(Type type) {
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            if (tupleType.getRestType() != null) {
                return -1;
            }
            return tupleType.getTupleTypes().size();
        }
        return ((ArrayType)type).getSize();
    }

    public static Map<String, String> processNameAnnotationsAndBuildCustomFieldMap(RecordType recordType, Map<String, Field> fieldHierarchy) {
        BMap annotations = recordType.getAnnotations();
        HashMap<String, String> updatedRecordFieldNames = new HashMap<String, String>();
        HashSet<String> updatedFields = new HashSet<String>();
        HashSet<String> updatedValues = new HashSet<String>();
        block0: for (BString annotationsKey : (BString[])annotations.getKeys()) {
            String key = annotationsKey.getValue();
            if (!key.contains("$field$.")) continue;
            BMap annotMap = (BMap)annotations.get((Object)annotationsKey);
            for (BString mapKey : (BString[])annotMap.getKeys()) {
                if (!mapKey.getValue().endsWith("Name")) continue;
                String name = ((Map)annotMap.get((Object)mapKey)).get(Constants.VALUE).toString();
                String originalName = key.substring("$field$.".length());
                if (updatedValues.contains(name)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, name);
                }
                if (updatedFields.contains(originalName)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, originalName);
                }
                updatedFields.add(originalName);
                updatedValues.add(name);
                updatedRecordFieldNames.put(name, originalName);
                continue block0;
            }
        }
        for (String field : fieldHierarchy.keySet()) {
            if (updatedFields.contains(field)) continue;
            if (updatedValues.contains(field) || updatedRecordFieldNames.containsKey(field)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, field);
            }
            updatedRecordFieldNames.put(field, field);
        }
        return updatedRecordFieldNames;
    }

    public static String getUpdatedHeaders(Map<String, String> updatedRecords, String key, boolean isKeyContains) {
        String fieldName = updatedRecords.get(key);
        if (fieldName != null) {
            return fieldName;
        }
        if (isKeyContains) {
            throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, key);
        }
        return key;
    }

    public static long[] getSkipLinesFromStringConfigValue(String configValue) {
        String[] parts = configValue.split("-");
        if (parts.length != 2) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_RANGE_FOR_SKIPLINES, new Object[0]);
        }
        try {
            int start = Integer.parseInt(parts[0]);
            int end = Integer.parseInt(parts[1]);
            int size = end - start + 1;
            if (size <= 0) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_RANGE_FOR_SKIPLINES, new Object[0]);
            }
            long[] result = new long[size];
            for (int i = 0; i < size; ++i) {
                result[i] = start + i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_VALUE_FOR_SKIPLINES, new Object[0]);
        }
    }

    public static long[] getSkipDataRows(Object skipLines) {
        if (skipLines == null) {
            return EMPTY_LONG_ARRAY;
        }
        if (skipLines instanceof BArray) {
            BArray skipLinesArray = (BArray)skipLines;
            if (skipLinesArray.getLength() == 0L) {
                return EMPTY_LONG_ARRAY;
            }
            return skipLinesArray.getIntArray();
        }
        return CsvUtils.getSkipLinesFromStringConfigValue(StringUtils.getStringValue((Object)skipLines));
    }

    public static boolean isNullValue(Object nullValue, Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof BString) {
            BString bString = (BString)value;
            value = StringUtils.getStringValue((Object)bString);
        }
        if (value instanceof String) {
            String v = (String)value;
            return CsvUtils.handleStringNullValue(nullValue, v, value);
        }
        return false;
    }

    private static boolean handleStringNullValue(Object nullValue, String v, Object value) {
        if (nullValue == null && ("null".equalsIgnoreCase(v) || "()".equalsIgnoreCase(v))) {
            return true;
        }
        return nullValue != null && value.equals(StringUtils.getStringValue((Object)nullValue));
    }

    public static boolean isCharContainsInLineTerminatorUserConfig(char c, Object lineTerminatorObj, boolean isCarriageTokenPresent) {
        if (lineTerminatorObj instanceof BArray) {
            Object[] lineTerminators;
            BArray array = (BArray)lineTerminatorObj;
            for (Object lineTerminator : lineTerminators = array.getValues()) {
                Optional<Boolean> value = CsvUtils.handleLineTerminator(lineTerminator, c, isCarriageTokenPresent);
                if (value.isEmpty()) continue;
                return value.get();
            }
            return false;
        }
        Optional<Boolean> value = CsvUtils.handleLineTerminator(lineTerminatorObj, c, isCarriageTokenPresent);
        if (value.isEmpty()) {
            return false;
        }
        return value.get();
    }

    private static Optional<Boolean> handleLineTerminator(Object lineTerminator, char c, boolean isCarriageTokenPresent) {
        if (lineTerminator == null || c != '\n') {
            return Optional.empty();
        }
        if (lineTerminator.equals("\r\n")) {
            return Optional.of(isCarriageTokenPresent);
        }
        return Optional.of(true);
    }

    public static Locale createLocaleFromString(String localeString) {
        String[] parts = localeString.split("_");
        int length = parts.length;
        if (length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        if (length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0]);
    }

    public static void validateConfigs(CsvConfig config) {
        if (config.headerRows > 1L && config.customHeaders == null) {
            throw DiagnosticLog.error(DiagnosticErrorCode.NO_CUSTOM_HEADER_PROVIDED, new Object[0]);
        }
    }

    public static class SkipMappedValue {
        public static final SkipMappedValue VALUE = new SkipMappedValue();
    }

    public static class UnMappedValue {
        public static final UnMappedValue VALUE = new UnMappedValue();
    }
}

