/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.utils;

import io.ballerina.lib.data.csvdata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.csvdata.utils.ModuleUtils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class DiagnosticLog {
    private static final String ERROR_PREFIX = "error";
    private static final String CSV_CONVERSION_ERROR = "Error";
    private static final String UNSUPPORTED_OPERATION_ERROR = "Error";
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("csv_error", Locale.getDefault());

    private DiagnosticLog() {
    }

    public static BError error(DiagnosticErrorCode code, Object ... args) {
        String msg = DiagnosticLog.formatMessage(code, args);
        return DiagnosticLog.getCsvError(msg);
    }

    private static String formatMessage(DiagnosticErrorCode code, Object[] args) {
        String msgKey = MESSAGES.getString("error." + code.messageKey());
        return MessageFormat.format(msgKey, args);
    }

    public static BError getCsvError(String message, String errorType) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorType, (BString)StringUtils.fromString((String)message), null, null);
    }

    public static BError getCsvError(String message) {
        return DiagnosticLog.getCsvError(message, "Error");
    }
}

