/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.string;

import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import org.ballerinalang.langlib.string.utils.StringUtils;

public final class Substring {
    private Substring() {
    }

    public static BString substring(BString value, long startIndex, long endIndex) {
        if (value == null) {
            throw StringUtils.createNullReferenceError();
        }
        if (startIndex != (long)((int)startIndex)) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.STRING_OPERATION_ERROR, (ErrorCodes)ErrorCodes.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{startIndex});
        }
        if (endIndex != (long)((int)endIndex)) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.STRING_OPERATION_ERROR, (ErrorCodes)ErrorCodes.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{endIndex});
        }
        if (startIndex < 0L || endIndex > (long)value.length()) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.STRING_OPERATION_ERROR, (ErrorCodes)ErrorCodes.SUBSTRING_INDEX_OUT_OF_RANGE, (Object[])new Object[]{value.length(), startIndex, endIndex});
        }
        if (endIndex < startIndex) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.STRING_OPERATION_ERROR, (ErrorCodes)ErrorCodes.INVALID_SUBSTRING_RANGE, (Object[])new Object[]{value.length(), startIndex, endIndex});
        }
        return value.substring((int)startIndex, (int)endIndex);
    }
}

