/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.deref;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.deref.ReferencedNodeImporter;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.Server;
import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import io.apicurio.datamodels.models.asyncapi.AsyncApiCorrelationID;
import io.apicurio.datamodels.models.asyncapi.AsyncApiDocument;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessageBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessageTrait;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperationBindings;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperationTrait;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServerBindings;

public class AsyncApi2NodeImporter
extends ReferencedNodeImporter {
    public AsyncApi2NodeImporter(Document doc, Node nodeWithUnresolvedRef, String ref, boolean shouldInline) {
        super(doc, nodeWithUnresolvedRef, ref, shouldInline);
    }

    @Override
    protected void setPathToImportedNode(Node importedNode, String type, String name) {
        this.setPathToImportedNode(importedNode, "#/components/" + type + "/" + name);
    }

    @Override
    public void visitChannelBindings(AsyncApiChannelBindings node) {
        String componentType = "channelBindings";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedChannelBinding"), this.getComponentNames(components.getChannelBindings()));
            components.addChannelBinding(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitChannelItem(AsyncApiChannelItem node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), null);
    }

    @Override
    public void visitCorrelationID(AsyncApiCorrelationID node) {
        String componentType = "correlationIds";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedCorrelationID"), this.getComponentNames(components.getCorrelationIds()));
            components.addCorrelationId(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitMessage(AsyncApiMessage node) {
        String componentType = "messages";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedMessage"), this.getComponentNames(components.getMessages()));
            components.addMessage(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitMessageBindings(AsyncApiMessageBindings node) {
        String componentType = "messageBindings";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedMessageBinding"), this.getComponentNames(components.getMessageBindings()));
            components.addMessageBinding(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitMessageTrait(AsyncApiMessageTrait node) {
        String componentType = "messageTraits";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedMessageTrait"), this.getComponentNames(components.getMessageTraits()));
            components.addMessageTrait(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitOperationBindings(AsyncApiOperationBindings node) {
        String componentType = "operationBindings";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedOperationBinding"), this.getComponentNames(components.getOperationBindings()));
            components.addOperationBinding(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitOperationTrait(AsyncApiOperationTrait node) {
        String componentType = "operationTraits";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedOperationTrait"), this.getComponentNames(components.getOperationTraits()));
            components.addOperationTrait(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitParameter(Parameter node) {
        String componentType = "parameters";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedParameter"), this.getComponentNames(components.getParameters()));
            components.addParameter(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitSchema(Schema node) {
        String componentType = "schemas";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedSchema"), this.getComponentNames(components.getSchemas()));
            components.addSchema(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        String componentType = "securitySchemes";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedSecurityScheme"), this.getComponentNames(components.getSecuritySchemes()));
            components.addSecurityScheme(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitServer(Server node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), null);
    }

    @Override
    public void visitServerBindings(AsyncApiServerBindings node) {
        String componentType = "serverBindings";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            AsyncApiComponents components = this.ensureAsyncApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedServerBinding"), this.getComponentNames(components.getServerBindings()));
            components.addServerBinding(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitServerVariable(ServerVariable node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), null);
    }

    private AsyncApiComponents ensureAsyncApiComponents() {
        AsyncApiDocument doc = (AsyncApiDocument)this.getDoc();
        if (doc.getComponents() == null) {
            doc.setComponents(doc.createComponents());
        }
        return doc.getComponents();
    }
}

