/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.deref;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.deref.ReferencedNodeImporter;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.openapi.OpenApiCallback;
import io.apicurio.datamodels.models.openapi.OpenApiComponents;
import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.OpenApiLink;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.models.openapi.OpenApiRequestBody;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.OpenApiResponses;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Document;
import io.apicurio.datamodels.util.ModelTypeUtil;

public class OpenApi3NodeImporter
extends ReferencedNodeImporter {
    public OpenApi3NodeImporter(Document doc, Node nodeWithUnresolvedRef, String ref, boolean shouldInline) {
        super(doc, nodeWithUnresolvedRef, ref, shouldInline);
    }

    @Override
    protected void setPathToImportedNode(Node importedNode, String type, String name) {
        this.setPathToImportedNode(importedNode, "#/components/" + type + "/" + name);
    }

    @Override
    public void visitSchema(Schema node) {
        String componentType = "schemas";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedSchema"), this.getComponentNames(components.getSchemas()));
            components.addSchema(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitCallback(OpenApiCallback node) {
        String componentType = "callbacks";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedCallback"), this.getComponentNames(components.getCallbacks()));
            components.addCallback(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitExample(OpenApiExample node) {
        String componentType = "examples";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedExample"), this.getComponentNames(components.getExamples()));
            components.addExample(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitHeader(OpenApiHeader node) {
        String componentType = "headers";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedHeader"), this.getComponentNames(components.getHeaders()));
            components.addHeader(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitLink(OpenApiLink node) {
        String componentType = "links";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedLink"), this.getComponentNames(components.getLinks()));
            components.addLink(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitParameter(Parameter node) {
        String componentType = "parameters";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedParameter"), this.getComponentNames(components.getParameters()));
            components.addParameter(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitPathItem(OpenApiPathItem node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), null);
    }

    @Override
    public void visitRequestBody(OpenApiRequestBody node) {
        String componentType = "requestBodies";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedRequestBody"), this.getComponentNames(components.getRequestBodies()));
            components.addRequestBody(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitResponse(OpenApiResponse node) {
        String componentType = "responses";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedResponse"), this.getComponentNames(components.getResponses()));
            components.addResponse(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    @Override
    public void visitResponses(OpenApiResponses node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), null);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        String componentType = "securitySchemes";
        if (this.shouldInline()) {
            this.inlineComponent(componentType, node);
        } else {
            OpenApiComponents components = this.ensureOpenApiComponents();
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedSecurityScheme"), this.getComponentNames(components.getSecuritySchemes()));
            components.addSecurityScheme(name, node);
            node.attach(components);
            this.setPathToImportedNode(node, componentType, name);
        }
    }

    private OpenApiComponents ensureOpenApiComponents() {
        if (ModelTypeUtil.isOpenApi30Model(this.getDoc())) {
            OpenApi30Document doc = (OpenApi30Document)this.getDoc();
            if (doc.getComponents() == null) {
                doc.setComponents(doc.createComponents());
            }
            return doc.getComponents();
        }
        if (ModelTypeUtil.isOpenApi31Model(this.getDoc())) {
            OpenApi31Document doc = (OpenApi31Document)this.getDoc();
            if (doc.getComponents() == null) {
                doc.setComponents(doc.createComponents());
            }
            return doc.getComponents();
        }
        return null;
    }
}

