/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.asyncapi.v26.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.Tag;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiTag;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Binding;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26ChannelBindings;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26ChannelItem;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Channels;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Components;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Contact;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26CorrelationID;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Document;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26ExternalDocumentation;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Info;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26License;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Message;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26MessageBindings;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26MessageExample;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26MessageTrait;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26OAuthFlow;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26OAuthFlows;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26OneOfMessages;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Operation;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26OperationBindings;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26OperationTrait;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Parameter;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Parameters;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Schema;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26SecurityScheme;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Server;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26ServerBindings;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26ServerVariable;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Servers;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Tag;
import io.apicurio.datamodels.models.io.ModelWriter;
import io.apicurio.datamodels.models.union.Union;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.WriterUtil;
import java.util.List;
import java.util.Map;

public class AsyncApi26ModelWriter
implements ModelWriter {
    public void writeDocument(AsyncApi26Document node, ObjectNode json) {
        Map<String, JsonNode> values;
        List<Tag> models;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "asyncapi", node.getAsyncapi());
        JsonUtil.setStringProperty(json, "id", node.getId());
        if (node.getInfo() != null) {
            object = JsonUtil.objectNode();
            this.writeInfo((AsyncApi26Info)node.getInfo(), object);
            JsonUtil.setObjectProperty(json, "info", object);
        }
        if (node.getServers() != null) {
            object = JsonUtil.objectNode();
            this.writeServers((AsyncApi26Servers)node.getServers(), object);
            JsonUtil.setObjectProperty(json, "servers", object);
        }
        JsonUtil.setStringProperty(json, "defaultContentType", node.getDefaultContentType());
        if (node.getChannels() != null) {
            object = JsonUtil.objectNode();
            this.writeChannels((AsyncApi26Channels)node.getChannels(), object);
            JsonUtil.setObjectProperty(json, "channels", object);
        }
        if (node.getComponents() != null) {
            object = JsonUtil.objectNode();
            this.writeComponents((AsyncApi26Components)node.getComponents(), object);
            JsonUtil.setObjectProperty(json, "components", object);
        }
        if ((models = node.getTags()) != null) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi26Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi26ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    @Override
    public ObjectNode writeRoot(RootNode node) {
        ObjectNode json = JsonUtil.objectNode();
        this.writeDocument((AsyncApi26Document)node, json);
        return json;
    }

    public void writeInfo(AsyncApi26Info node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "version", node.getVersion());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "termsOfService", node.getTermsOfService());
        if (node.getContact() != null) {
            object = JsonUtil.objectNode();
            this.writeContact((AsyncApi26Contact)node.getContact(), object);
            JsonUtil.setObjectProperty(json, "contact", object);
        }
        if (node.getLicense() != null) {
            object = JsonUtil.objectNode();
            this.writeLicense((AsyncApi26License)node.getLicense(), object);
            JsonUtil.setObjectProperty(json, "license", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeContact(AsyncApi26Contact node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        JsonUtil.setStringProperty(json, "email", node.getEmail());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeLicense(AsyncApi26License node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServers(AsyncApi26Servers node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeServer((AsyncApi26Server)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServer(AsyncApi26Server node, ObjectNode json) {
        Map<String, JsonNode> values;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        JsonUtil.setStringProperty(json, "protocol", node.getProtocol());
        JsonUtil.setStringProperty(json, "protocolVersion", node.getProtocolVersion());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<AsyncApi26Tag> models = node.getVariables();
        if (models != null) {
            ObjectNode object = JsonUtil.objectNode();
            models.keySet().forEach(arg_0 -> this.lambda$writeServer$6((Map)((Object)models), object, arg_0));
            JsonUtil.setObjectProperty(json, "variables", object);
        }
        if ((models = node.getSecurity()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityRequirement((AsyncApi26SecurityRequirement)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getTags()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi26Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getBindings() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeServerBindings((AsyncApi26ServerBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServerVariable(AsyncApi26ServerVariable node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setStringProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringArrayProperty(json, "examples", node.getExamples());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannels(AsyncApi26Channels node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeChannelItem((AsyncApi26ChannelItem)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannelItem(AsyncApi26ChannelItem node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringArrayProperty(json, "servers", node.getServers());
        if (node.getSubscribe() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((AsyncApi26Operation)node.getSubscribe(), object);
            JsonUtil.setObjectProperty(json, "subscribe", object);
        }
        if (node.getPublish() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((AsyncApi26Operation)node.getPublish(), object);
            JsonUtil.setObjectProperty(json, "publish", object);
        }
        if (node.getParameters() != null) {
            object = JsonUtil.objectNode();
            this.writeParameters((AsyncApi26Parameters)node.getParameters(), object);
            JsonUtil.setObjectProperty(json, "parameters", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeChannelBindings((AsyncApi26ChannelBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperation(AsyncApi26Operation node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "operationId", node.getOperationId());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<Node> models = node.getSecurity();
        if (models != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityRequirement((AsyncApi26SecurityRequirement)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getTags()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi26Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi26ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationBindings((AsyncApi26OperationBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((models = node.getTraits()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeOperationTrait((AsyncApi26OperationTrait)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "traits", (JsonNode)array);
        }
        if (node.getMessage() != null) {
            object = JsonUtil.objectNode();
            this.writeMessage((AsyncApi26Message)node.getMessage(), object);
            JsonUtil.setObjectProperty(json, "message", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationTrait(AsyncApi26OperationTrait node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "operationId", node.getOperationId());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<Node> models = node.getSecurity();
        if (models != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityRequirement((AsyncApi26SecurityRequirement)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getTags()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi26Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi26ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationBindings((AsyncApi26OperationBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeParameters(AsyncApi26Parameters node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeParameter((AsyncApi26Parameter)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeParameter(AsyncApi26Parameter node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getSchema() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getSchema(), object);
            JsonUtil.setObjectProperty(json, "schema", object);
        }
        JsonUtil.setStringProperty(json, "location", node.getLocation());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServerBindings(AsyncApi26ServerBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannelBindings(AsyncApi26ChannelBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationBindings(AsyncApi26OperationBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageBindings(AsyncApi26MessageBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi26Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOneOfMessages(AsyncApi26OneOfMessages node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<AsyncApiMessage> models = node.getOneOf();
        if (models != null) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessage((AsyncApi26Message)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessage(AsyncApi26Message node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        List<Node> models = node.getOneOf();
        if (models != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessage((AsyncApi26Message)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        JsonUtil.setStringProperty(json, "messageId", node.getMessageId());
        if (node.getHeaders() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getHeaders(), object);
            JsonUtil.setObjectProperty(json, "headers", object);
        }
        JsonUtil.setAnyProperty(json, "payload", node.getPayload());
        if (node.getCorrelationId() != null) {
            object = JsonUtil.objectNode();
            this.writeCorrelationID((AsyncApi26CorrelationID)node.getCorrelationId(), object);
            JsonUtil.setObjectProperty(json, "correlationId", object);
        }
        JsonUtil.setStringProperty(json, "schemaFormat", node.getSchemaFormat());
        JsonUtil.setStringProperty(json, "contentType", node.getContentType());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        models = node.getTags();
        if (models != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi26Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi26ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeMessageBindings((AsyncApi26MessageBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if (node.getExamples() != null) {
            object = JsonUtil.objectNode();
            this.writeMessageExample(node.getExamples(), object);
            JsonUtil.setObjectProperty(json, "examples", object);
        }
        if ((models = node.getTraits()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessageTrait((AsyncApi26MessageTrait)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "traits", (JsonNode)array);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageTrait(AsyncApi26MessageTrait node, ObjectNode json) {
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "messageId", node.getMessageId());
        if (node.getHeaders() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getHeaders(), object);
            JsonUtil.setObjectProperty(json, "headers", object);
        }
        if (node.getCorrelationId() != null) {
            object = JsonUtil.objectNode();
            this.writeCorrelationID((AsyncApi26CorrelationID)node.getCorrelationId(), object);
            JsonUtil.setObjectProperty(json, "correlationId", object);
        }
        JsonUtil.setStringProperty(json, "schemaFormat", node.getSchemaFormat());
        JsonUtil.setStringProperty(json, "contentType", node.getContentType());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<AsyncApiTag> models = node.getTags();
        if (models != null) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi26Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi26ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeMessageBindings((AsyncApi26MessageBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        JsonUtil.setAnyMapProperty(json, "examples", node.getExamples());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageExample(AsyncApi26MessageExample node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setAnyMapProperty(json, "headers", node.getHeaders());
        JsonUtil.setAnyProperty(json, "payload", node.getPayload());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeTag(AsyncApi26Tag node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getExternalDocs() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi26ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeExternalDocumentation(AsyncApi26ExternalDocumentation node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeComponents(AsyncApi26Components node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        Map<String, Node> models = node.getSchemas();
        if (models != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi26Schema)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "schemas", object);
        }
        if ((models = node.getServers()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServer((AsyncApi26Server)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "servers", object);
        }
        if ((models = node.getServerVariables()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServerVariable((AsyncApi26ServerVariable)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "serverVariables", object);
        }
        if ((models = node.getChannels()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeChannelItem((AsyncApi26ChannelItem)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "channels", object);
        }
        if ((models = node.getMessages()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessage((AsyncApi26Message)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messages", object);
        }
        if ((models = node.getSecuritySchemes()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSecurityScheme((AsyncApi26SecurityScheme)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "securitySchemes", object);
        }
        if ((models = node.getParameters()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeParameter((AsyncApi26Parameter)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "parameters", object);
        }
        if ((models = node.getCorrelationIds()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeCorrelationID((AsyncApi26CorrelationID)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "correlationIds", object);
        }
        if ((models = node.getOperationTraits()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationTrait((AsyncApi26OperationTrait)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "operationTraits", object);
        }
        if ((models = node.getMessageTraits()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessageTrait((AsyncApi26MessageTrait)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messageTraits", object);
        }
        if ((models = node.getServerBindings()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServerBindings((AsyncApi26ServerBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "serverBindings", object);
        }
        if ((models = node.getChannelBindings()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeChannelBindings((AsyncApi26ChannelBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "channelBindings", object);
        }
        if ((models = node.getOperationBindings()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationBindings((AsyncApi26OperationBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "operationBindings", object);
        }
        if ((models = node.getMessageBindings()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessageBindings((AsyncApi26MessageBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messageBindings", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSchema(AsyncApi26Schema node, ObjectNode json) {
        ArrayNode array;
        ObjectNode jsonValue;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "type", node.getType());
        JsonUtil.setStringArrayProperty(json, "required", node.getRequired());
        JsonUtil.setNumberProperty(json, "multipleOf", node.getMultipleOf());
        JsonUtil.setNumberProperty(json, "maximum", node.getMaximum());
        JsonUtil.setNumberProperty(json, "exclusiveMaximum", node.getExclusiveMaximum());
        JsonUtil.setNumberProperty(json, "minimum", node.getMinimum());
        JsonUtil.setNumberProperty(json, "exclusiveMinimum", node.getExclusiveMinimum());
        JsonUtil.setIntegerProperty(json, "maxLength", node.getMaxLength());
        JsonUtil.setIntegerProperty(json, "minLength", node.getMinLength());
        JsonUtil.setStringProperty(json, "pattern", node.getPattern());
        JsonUtil.setIntegerProperty(json, "maxItems", node.getMaxItems());
        JsonUtil.setIntegerProperty(json, "minItems", node.getMinItems());
        JsonUtil.setBooleanProperty(json, "uniqueItems", node.isUniqueItems());
        JsonUtil.setIntegerProperty(json, "maxProperties", node.getMaxProperties());
        JsonUtil.setIntegerProperty(json, "minProperties", node.getMinProperties());
        JsonUtil.setAnyArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setAnyProperty(json, "const", node.getConst());
        JsonUtil.setAnyArrayProperty(json, "examples", node.getExamples());
        if (node.getIf() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getIf(), object);
            JsonUtil.setObjectProperty(json, "if", object);
        }
        if (node.getThen() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getThen(), object);
            JsonUtil.setObjectProperty(json, "then", object);
        }
        if (node.getElse() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getElse(), object);
            JsonUtil.setObjectProperty(json, "else", object);
        }
        JsonUtil.setBooleanProperty(json, "readOnly", node.isReadOnly());
        JsonUtil.setBooleanProperty(json, "writeOnly", node.isWriteOnly());
        List<AsyncApiSchema> models = node.getProperties();
        if (models != null) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi26Schema)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object2, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "properties", object2);
        }
        JsonUtil.setStringMapProperty(json, "patternProperties", node.getPatternProperties());
        Union union = node.getAdditionalProperties();
        if (union != null) {
            if (union.isBoolean()) {
                JsonUtil.setBooleanProperty(json, "additionalProperties", union.asBoolean());
            }
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi26Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "additionalProperties", jsonValue);
            }
        }
        if (node.getAdditionalItems() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getAdditionalItems(), object);
            JsonUtil.setObjectProperty(json, "additionalItems", object);
        }
        if ((union = node.getItems()) != null) {
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi26Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "items", jsonValue);
            }
            if (union.isSchemaList()) {
                List<Schema> models2 = union.asSchemaList();
                ArrayNode array2 = JsonUtil.arrayNode();
                models2.forEach(model -> {
                    ObjectNode object = JsonUtil.objectNode();
                    this.writeSchema((AsyncApi26Schema)model, object);
                    JsonUtil.addToArray(array2, (JsonNode)object);
                });
                JsonUtil.setAnyProperty(json, "items", (JsonNode)array2);
            }
        }
        if (node.getPropertyNames() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getPropertyNames(), object);
            JsonUtil.setObjectProperty(json, "propertyNames", object);
        }
        if (node.getContains() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getContains(), object);
            JsonUtil.setObjectProperty(json, "contains", object);
        }
        if ((models = node.getAllOf()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi26Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "allOf", (JsonNode)array);
        }
        if ((models = node.getOneOf()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi26Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        if ((models = node.getAnyOf()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi26Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "anyOf", (JsonNode)array);
        }
        if (node.getNot() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi26Schema)node.getNot(), object);
            JsonUtil.setObjectProperty(json, "not", object);
        }
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "format", node.getFormat());
        JsonUtil.setAnyProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "discriminator", node.getDiscriminator());
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi26ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        JsonUtil.setBooleanProperty(json, "deprecated", node.isDeprecated());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSecurityScheme(AsyncApi26SecurityScheme node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "type", node.getType());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "in", node.getIn());
        JsonUtil.setStringProperty(json, "scheme", node.getScheme());
        JsonUtil.setStringProperty(json, "bearerFormat", node.getBearerFormat());
        if (node.getFlows() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeOAuthFlows((AsyncApi26OAuthFlows)node.getFlows(), object);
            JsonUtil.setObjectProperty(json, "flows", object);
        }
        JsonUtil.setStringProperty(json, "openIdConnectUrl", node.getOpenIdConnectUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlows(AsyncApi26OAuthFlows node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getImplicit() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi26OAuthFlow)node.getImplicit(), object);
            JsonUtil.setObjectProperty(json, "implicit", object);
        }
        if (node.getPassword() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi26OAuthFlow)node.getPassword(), object);
            JsonUtil.setObjectProperty(json, "password", object);
        }
        if (node.getClientCredentials() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi26OAuthFlow)node.getClientCredentials(), object);
            JsonUtil.setObjectProperty(json, "clientCredentials", object);
        }
        if (node.getAuthorizationCode() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi26OAuthFlow)node.getAuthorizationCode(), object);
            JsonUtil.setObjectProperty(json, "authorizationCode", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlow(AsyncApi26OAuthFlow node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "authorizationUrl", node.getAuthorizationUrl());
        JsonUtil.setStringProperty(json, "tokenUrl", node.getTokenUrl());
        JsonUtil.setStringProperty(json, "refreshUrl", node.getRefreshUrl());
        JsonUtil.setStringMapProperty(json, "scopes", node.getScopes());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSecurityRequirement(AsyncApi26SecurityRequirement node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            List value = (List)node.getItem((String)propertyName);
            JsonUtil.setStringArrayProperty(json, propertyName, value);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeCorrelationID(AsyncApi26CorrelationID node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "location", node.getLocation());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeBinding(AsyncApi26Binding node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            JsonNode value = (JsonNode)node.getItem((String)propertyName);
            JsonUtil.setAnyProperty(json, propertyName, value);
        });
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    private /* synthetic */ void lambda$writeServer$6(Map models, ObjectNode object, String jsonName) {
        ObjectNode jsonValue = JsonUtil.objectNode();
        this.writeServerVariable((AsyncApi26ServerVariable)models.get(jsonName), jsonValue);
        JsonUtil.setObjectProperty(object, jsonName, jsonValue);
    }
}

