/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.name;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.openapi.OpenApiPaths;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidPropertyNameRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OasIdenticalPathTemplateRule
extends OasInvalidPropertyNameRule {
    Map<String, List<ValidationRule.PathSegment>> indexedPathTemplates = new HashMap<String, List<ValidationRule.PathSegment>>();

    public OasIdenticalPathTemplateRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private List<String> findIdenticalPaths(String pathToCheck) {
        ArrayList<String> identicalPaths = new ArrayList<String>();
        List<ValidationRule.PathSegment> pathSegments = this.indexedPathTemplates.get(pathToCheck);
        for (String checkAgainst : this.indexedPathTemplates.keySet()) {
            if (this.equals(checkAgainst, pathToCheck)) continue;
            boolean segmentsIdentical = true;
            List<ValidationRule.PathSegment> pathSegmentsToCheckAgainst = this.indexedPathTemplates.get(checkAgainst);
            if (pathSegments.size() != pathSegmentsToCheckAgainst.size()) {
                segmentsIdentical = false;
            } else {
                int idx = 0;
                for (ValidationRule.PathSegment pathSegment : pathSegments) {
                    segmentsIdentical = segmentsIdentical && this.isSegmentIdentical(pathSegment, pathSegmentsToCheckAgainst.get(idx));
                    ++idx;
                }
            }
            if (!segmentsIdentical) continue;
            identicalPaths.add(checkAgainst);
        }
        return identicalPaths;
    }

    private boolean isSegmentIdentical(ValidationRule.PathSegment segment1, ValidationRule.PathSegment segment2) {
        if (this.equals(segment1.prefix, segment2.prefix)) {
            if (!this.hasValue(segment1.normalizedName) && !this.hasValue(segment2.normalizedName)) {
                return true;
            }
            if (!this.hasValue(segment1.normalizedName) && this.hasValue(segment2.normalizedName) || this.hasValue(segment1.normalizedName) && !this.hasValue(segment2.normalizedName)) {
                return false;
            }
            return this.equals(segment1.normalizedName, segment2.normalizedName);
        }
        return false;
    }

    @Override
    public void visitPaths(OpenApiPaths node) {
        node.getItemNames().forEach(pathTemplate -> {
            if (this.isPathWellFormed((String)pathTemplate)) {
                List<ValidationRule.PathSegment> pathSegments = this.getPathSegments((String)pathTemplate);
                this.indexedPathTemplates.put((String)pathTemplate, pathSegments);
            }
        });
        node.getItemNames().forEach(pathTemplate -> {
            List<String> identicalPaths;
            if (this.isPathWellFormed((String)pathTemplate) && (identicalPaths = this.findIdenticalPaths((String)pathTemplate)).size() > 0) {
                this.reportPathError((Node)node.getItem((String)pathTemplate), this.map("path", (String)pathTemplate));
            }
        });
    }
}

