/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.refs.ReferenceUtil;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;
import java.util.List;

public class OasPathParamNotFoundRule
extends AbstractInvalidPropertyValueRule {
    private String pathItemTemplate;

    public OasPathParamNotFoundRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitPathItem(OpenApiPathItem node) {
        this.pathItemTemplate = this.getPathTemplate(node);
    }

    @Override
    public void visitParameter(Parameter node) {
        OpenApiParameter resolvedParam;
        if (!this.isDefinition(node) && this.hasValue(resolvedParam = (OpenApiParameter)ReferenceUtil.resolveNodeRef(node)) && this.equals(resolvedParam.getIn(), "path")) {
            List<ValidationRule.PathSegment> pathSegs = this.getPathSegments(this.pathItemTemplate);
            this.reportIf(!this.hasPathParamSegment(pathSegs, resolvedParam.getName()), node, "name", this.map("name", resolvedParam.getName()));
        }
    }

    protected boolean hasPathParamSegment(List<ValidationRule.PathSegment> segments, String paramName) {
        for (ValidationRule.PathSegment seg : segments) {
            if (!this.equals(seg.formalName, paramName)) continue;
            return true;
        }
        return false;
    }
}

