/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.required;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.util.NodeUtil;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.Map;

public abstract class RequiredPropertyValidationRule
extends ValidationRule {
    public RequiredPropertyValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected void requireProperty(Node node, String propertyName, Map<String, String> messageParams) {
        Object propertyValue = NodeUtil.getProperty(node, propertyName);
        if (!this.isDefined(propertyValue)) {
            this.report(node, propertyName, messageParams);
        }
    }

    protected void requirePropertyWhen(Node node, String propertyName, String dependentPropertyName, Object dependentPropertyExpectedValue, Map<String, String> messageParams) {
        Object dependentPropertyActualValue = NodeUtil.getProperty(node, dependentPropertyName);
        if (NodeUtil.equals(dependentPropertyActualValue, dependentPropertyExpectedValue)) {
            this.requireProperty(node, propertyName, messageParams);
        }
    }
}

