/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.visitors;

import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.Server;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServer;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.util.ModelTypeUtil;
import java.util.List;

public class SecurityRequirementsFromParentVisitor
extends CombinedVisitorAdapter {
    private List<? extends SecurityRequirement> securityRequirements;

    public List<? extends SecurityRequirement> getSecurityRequirements() {
        return this.securityRequirements;
    }

    @Override
    public void visitServer(Server node) {
        if (ModelTypeUtil.isAsyncApiModel(node)) {
            AsyncApiServer server = (AsyncApiServer)node;
            this.securityRequirements = server.getSecurity();
        }
    }

    @Override
    public void visitDocument(Document node) {
        OpenApiDocument doc = (OpenApiDocument)node;
        this.securityRequirements = doc.getSecurity();
    }

    @Override
    public void visitOperation(Operation node) {
        OpenApiOperation op = (OpenApiOperation)node;
        this.securityRequirements = op.getSecurity();
    }
}

